/*******************************************************************************
+
+  LEDA  3.0
+
+
+  _panel.c
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/


#include <math.h>
#include <string.h>
#include <stdio.h>
#include <values.h>

#ifdef XVIEW

#include <X11/X.h>
#include <X11/Xlib.h>

#include <xview/xview.h>
#include <xview/xv_xrect.h>
#include <xview/panel.h>
#include <xview/font.h>
#include <xview/openmenu.h>
#include <xview/icon.h>


#else

#include <suntool/sunview.h>
#include <suntool/canvas.h>
#include <suntool/panel.h>

#endif

#define MAX_BUT  64
#define MAX_ITEM 16

static short icon_image[] = {

#include "leda.icon"

};

mpr_static(panel_icon_pixrect,64,64,1,icon_image);


typedef struct {

Frame   panel_frame;
Panel   panel;

Panel_item choice_item[MAX_ITEM];
int*       choice_ref[MAX_ITEM];
int        choice_step[MAX_ITEM];
int        choice_offset[MAX_ITEM];
int        choice_count;

Panel_item slider_item[MAX_ITEM];
int*       slider_ref[MAX_ITEM];
int        slider_count;

Panel_item string_item[MAX_ITEM];
Menu       string_menu[MAX_ITEM];
char*      string_ref[MAX_ITEM];
int        string_count;

Panel_item int_item[MAX_ITEM];
int*       int_ref[MAX_ITEM];
int        int_count;

Panel_item float_item[MAX_ITEM];
double*    float_ref[MAX_ITEM];
int        float_count;

Panel_item but_item[MAX_BUT]; 
int        but_centered[MAX_BUT];
int        but_count;
int        but_line_count;
int        button_width;

int panel_row;

} LEDA_PANEL;

typedef LEDA_PANEL *leda_panel;

static leda_panel current_panel;
static int        panel_button_answer;


void  x_draw_panel_init(p)
leda_panel p;
{
  p->choice_count = 0;
  p->slider_count = 0;
  p->string_count = 0;
  p->int_count    = 0;
  p->float_count  = 0;
  p->but_count    = 0;
  p->but_line_count = 0;
  p->button_width = 0;
  p->panel_row    = 0;

}


leda_panel x_draw_panel_create()
{ 

#ifdef XVIEW
  Xv_Font panel_font;
#endif

  Icon icon = icon_create(ICON_IMAGE, &panel_icon_pixrect, 0);

  leda_panel p = (leda_panel) malloc(sizeof(LEDA_PANEL));


  p->panel_frame = window_create(0, FRAME,
                              FRAME_ICON, icon,
                              FRAME_NO_CONFIRM, TRUE, 
                              WIN_WIDTH, 1000,
                              WIN_X,      100, 
                              WIN_Y,      100, 
                              0);

#ifdef XVIEW

  panel_font = (Xv_Font)xv_find(p->panel_frame, FONT,
                         FONT_FAMILY, FONT_FAMILY_DEFAULT_FIXEDWIDTH,
                         FONT_STYLE,  FONT_STYLE_NORMAL,
                         FONT_SIZE,   14,
                         0);

  p->panel = window_create(p->panel_frame, PANEL, WIN_FONT, panel_font, 0);

#else

  p->panel = window_create(p->panel_frame, PANEL,0);

#endif


 x_draw_panel_init(p);

 return p;

}

void x_draw_panel_destroy(p) 
leda_panel p;
{ window_destroy(p->panel_frame);
  free(p); 
 }


static void panel_button_notify(item, event)
Panel_item	item;
Event		*event;
{
  int i,n;
  char buf[256];
  float f;

  panel_button_answer = (int)panel_get(item,PANEL_CLIENT_DATA);

  for (i=0; i<current_panel->slider_count; i++)
    *(current_panel->slider_ref[i]) = 
                        (int)panel_get_value(current_panel->slider_item[i]);

  for (i=0; i<current_panel->choice_count; i++)
   { n = (int)panel_get_value(current_panel->choice_item[i]);
    *(current_panel->choice_ref[i]) = 
        current_panel->choice_offset[i] + n * current_panel->choice_step[i];
    }

  for (i=0; i<current_panel->string_count; i++)
   strcpy(current_panel->string_ref[i],
          (char*)panel_get_value(current_panel->string_item[i]));

  for (i=0; i<current_panel->int_count; i++)
  { strcpy(buf,(char*)panel_get_value(current_panel->int_item[i]));
    sscanf(buf,"%d",current_panel->int_ref[i]);
   }

  for (i=0; i<current_panel->float_count; i++)
  { strcpy(buf,(char*)panel_get_value(current_panel->float_item[i]));
    sscanf(buf,"%f",&f);
    *(current_panel->float_ref[i]) = (double)f;
   }

  notify_stop();

 }


#ifdef XVIEW

static void menu_proc(menu, menu_item)  /* selecting menu */
Menu menu;
Menu_item menu_item;
{
   Panel_item text_item = window_get(menu,MENU_CLIENT_DATA);
   window_set(text_item,PANEL_VALUE,window_get(menu_item, MENU_STRING),0);
 }

#else

static char** menu_strings;

static void panel_menu_proc(item, event)
Panel_item item;
Event *event;
{ int i;
  Menu_item menu_item;
  int j = (int)panel_get(item,PANEL_CLIENT_DATA);

  if (event_id(event) == MS_RIGHT && event_is_down(event))
  { menu_item = menu_show(current_panel->string_menu[j], current_panel->panel, event,0);
    panel_set(current_panel->string_item[j],PANEL_VALUE, menu_get(menu_item, MENU_STRING),0);
   }
  else panel_default_handle_event(item,event);
}

#endif


void x_draw_panel_choice_item(p,text,address,argc,argv,step,offset)
leda_panel p;
char* text;
int* address;
int argc;
char** argv;
int step;
int offset;
{
  int i;
  char* choices[16];

  if (p->choice_count == MAX_ITEM) return;

  for(i=0;i<16;i++) 
     choices[i] = (i<argc) ? argv[i] : 0;

  p->panel_row+=40;

  p->choice_ref[p->choice_count] = address;

  p->choice_step[p->choice_count] = step;
  p->choice_offset[p->choice_count] = offset;

  p->choice_item[p->choice_count] = panel_create_item(p->panel, PANEL_CHOICE, 
                          PANEL_LABEL_STRING, text,       
                          PANEL_LABEL_X, 20,
                          PANEL_VALUE_X, 180,
                          PANEL_ITEM_Y, p->panel_row,
                          PANEL_DISPLAY_LEVEL,	PANEL_ALL,
                          PANEL_VALUE, (*address-offset)/step,
                          PANEL_CHOICE_STRINGS, 
                             choices[0],  choices[1],  choices[2],  choices[3], 
                             choices[4],  choices[5],  choices[6],  choices[7], 
                             choices[8],  choices[9],  choices[10], choices[11],
                             choices[12], choices[13], choices[14], choices[15],
                             0,0);
 p->choice_count++;

}


void x_draw_panel_slider_item(p,text,address,Min,Max)
leda_panel p;
char* text;
int* address;
int Min;
int Max;
{
  int i;
  char label[18];

  if (p->slider_count == MAX_ITEM) return;

  for (i=0; i<17; i++)  
    label[i] = (i<strlen(text)) ? text[i] : ' ';

  label[17] = 0;

  p->panel_row+=40;

  p->slider_ref[p->slider_count] = address;

  p->slider_item[p->slider_count] = panel_create_item(p->panel, PANEL_SLIDER, 
                          PANEL_LABEL_STRING, label,       
                          PANEL_LABEL_X,      20,
                          PANEL_VALUE_X,      180,
                          PANEL_ITEM_Y,       p->panel_row,
                          PANEL_VALUE,        *address,
                          PANEL_MIN_VALUE,    Min,
                          PANEL_MAX_VALUE,    Max,
                          PANEL_SLIDER_WIDTH, 180,
                          PANEL_SHOW_RANGE,   FALSE,
                      /*  PANEL_VALUE_DISPLAY_LENGTH, 20, */
                          0);
 p->slider_count++;

}



void x_draw_panel_text_item(p,text)
leda_panel p;
char* text;
{
  p->panel_row+=20;

  panel_create_item(p->panel, PANEL_MESSAGE, 
                           PANEL_LABEL_BOLD, TRUE,
                           PANEL_LABEL_STRING, text,
                           PANEL_ITEM_X, 20,
                           PANEL_ITEM_Y, p->panel_row,
	                   0);

}


void x_draw_panel_string_menu_item(p,text,s,menu_label,n,items)
leda_panel p;
char* text;
char* s;
char	*menu_label;
int      n;
char  **items;
{
    Menu menu;
    char menu_l[32];
    int i;
    int cols = 1 +n/15;

    if (p->string_count == MAX_ITEM) return;

    p->panel_row+=40;

    p->string_ref[p->string_count] = s;

    p->string_item[p->string_count] = panel_create_item(p->panel, PANEL_TEXT, 
                                PANEL_ITEM_X, 20,
                                PANEL_ITEM_Y, p->panel_row,
                                PANEL_LABEL_STRING, text,
                                PANEL_VALUE,s,
                                PANEL_VALUE_X,180,
                                PANEL_LABEL_X,20,
                                PANEL_VALUE_DISPLAY_LENGTH, 20,
                                PANEL_VALUE_STORED_LENGTH, 256, 
         	                   0);
    
#ifdef XVIEW

    if (n>0)
    {
      menu = (Menu)window_create(NULL, MENU,
                             MENU_NCOLS, cols,
                             MENU_CLIENT_DATA, p->string_item[p->string_count],
                             MENU_NOTIFY_PROC, menu_proc,
                             0);

      for(i=0;i<n;i++) menu_set(menu,MENU_STRING_ITEM,items[i],i,0);

      (void) window_create(p->panel, PANEL_BUTTON,
                              PANEL_LABEL_STRING, menu_label,
                              PANEL_ITEM_MENU,    menu, 
                              0);
     }

#else


    if (n > 0)
    { 
     sprintf(menu_l,"%s -> ",menu_label);
     menu_label = menu_l;

      menu = menu_create(MENU_NCOLS, cols,
                         MENU_NOTIFY_PROC, menu_return_item,
                        0);

      for(i=0;i<n;i++) menu_set(menu,MENU_STRING_ITEM,items[i],i,0);

      panel_create_item(p->panel, PANEL_BUTTON,
              PANEL_LABEL_IMAGE,panel_button_image(p->panel,menu_label,0,0), 
              PANEL_EVENT_PROC, panel_menu_proc,
              PANEL_CLIENT_DATA,p->string_count,
                        0);
     }

    p->string_menu[p->string_count] = menu;

#endif

    p->string_count++;

 }

void x_draw_panel_string_item(p,text,s)
leda_panel p;
char* text;
char* s;
{ x_draw_panel_string_menu_item(p,text,s,"",0,0); }


void x_draw_panel_int_item(p,text,i)
leda_panel p;
char* text;
int* i;
{
    char s[32];

    if (p->int_count == MAX_ITEM) return;

    sprintf(s,"%d",*i);

    p->panel_row+=40;

   
    p->int_ref[p->int_count] = i;

    p->int_item[p->int_count] = panel_create_item(p->panel, PANEL_TEXT, 
                                PANEL_ITEM_X, 20,
                                PANEL_ITEM_Y, p->panel_row,
                                PANEL_LABEL_STRING, text,
                                PANEL_VALUE,s,
                                PANEL_VALUE_X,180,
                                PANEL_LABEL_X,20,
                                PANEL_VALUE_DISPLAY_LENGTH, 10,
                                PANEL_VALUE_STORED_LENGTH, 32, 
         	                   0);
    

/*
   p->int_item[p->int_count] = panel_create_item(p->panel, PANEL_NUMERIC_TEXT,
                                            PANEL_ITEM_X, 20,
                                            PANEL_ITEM_Y, p->panel_row,
                                            PANEL_LABEL_STRING,	text,
                                            PANEL_VALUE, *i,
                                            PANEL_MIN_VALUE, -MAXINT,
                                            PANEL_MAX_VALUE, MAXINT,
                                            PANEL_VALUE_X,180,
                                            PANEL_LABEL_X,20,
                                            PANEL_VALUE_DISPLAY_LENGTH, 10,
                                            NULL);
*/

    p->int_count++;
    
 }

void x_draw_panel_float_item(p,text,f)
leda_panel p;
char* text;
double* f;
{
    char s[256];
    sprintf(s,"%f",*f); 

    if (p->float_count == MAX_ITEM) return;

    p->panel_row+=40;
    p->float_item[p->float_count] = panel_create_item(p->panel, PANEL_TEXT, 
                                PANEL_ITEM_X, 20,
                                PANEL_ITEM_Y, p->panel_row,
                                PANEL_LABEL_STRING, text,
                                PANEL_VALUE, s,
                                PANEL_VALUE_X,180,
                                PANEL_LABEL_X,20,
                                PANEL_VALUE_DISPLAY_LENGTH, 10,
                                PANEL_VALUE_STORED_LENGTH, 256, 
         	                   0);
    p->float_ref[p->float_count] = f;

    p->float_count++;
    
 }


int x_draw_panel_button(p,button)
leda_panel p;
char* button;
{ 
  Rect	*r;

  int i;

  if (p->but_count == MAX_BUT) return;

  p->but_centered[p->but_count] = 0;

  if (p->but_line_count==0)
  {  
    if (p->panel_row==0) 
       p->panel_row = 20;
    else 
       if (p->but_count==0) 
          p->panel_row+=50;
       else
          p->panel_row+=35;

 p->but_item[p->but_count] =  panel_create_item(p->panel, PANEL_BUTTON, 

#ifdef XVIEW
             PANEL_LABEL_STRING, button,       
#else
             PANEL_LABEL_IMAGE,panel_button_image(p->panel,button,0,0),
#endif
                           PANEL_NOTIFY_PROC, panel_button_notify,
                           PANEL_CLIENT_DATA,p->but_count,
                           PANEL_ITEM_Y, p->panel_row,
                           PANEL_ITEM_X,20,
                           0);
   }
    else
   {
     p->but_item[p->but_count] =  panel_create_item(p->panel, PANEL_BUTTON, 

#ifdef XVIEW
             PANEL_LABEL_STRING, button,       
#else
             PANEL_LABEL_IMAGE,panel_button_image(p->panel,button,0,0),
#endif
                           PANEL_NOTIFY_PROC, panel_button_notify,
                           PANEL_CLIENT_DATA,p->but_count,
                           PANEL_ITEM_Y, p->panel_row,
                           0);

   if ( panel_get(p->but_item[p->but_count],PANEL_ITEM_X)
                           < panel_get(p->but_item[p->but_count-1],PANEL_ITEM_X) )
   { /* new line */
     p->panel_row += 35;
     p->but_line_count = 0;
     panel_set(p->but_item[p->but_count],PANEL_ITEM_Y,p->panel_row,0);
     p->button_width = (int) window_get(p->panel,WIN_WIDTH) - 10;
    }

  }

    p->but_line_count++;
    p->but_count++;

  return(p->but_count-1);

}



int x_draw_panel_button_line(p,n,buttons)
leda_panel p;
int n;
char** buttons;
{ int i;
  int w;
  Panel_item dummy;



  for(i=0; i<n; i++)  x_draw_panel_button(p,buttons[i]);

  dummy =  panel_create_item(p->panel, PANEL_BUTTON, PANEL_ITEM_Y, p->panel_row, 0);

  w = (int)panel_get(dummy,PANEL_ITEM_X);

  panel_destroy_item(dummy);

  if (w < (int)panel_get(p->but_item[p->but_count-1],PANEL_ITEM_X)) 
     p->button_width = (int)window_get(p->panel,WIN_WIDTH) - 10;
  else
     if (w > p->button_width) p->button_width = w;

  p->but_line_count = 0;
}


void x_draw_panel_label(p,label)
leda_panel p;
char* label;
{ window_set(p->panel_frame,FRAME_LABEL, label,0); }



int x_draw_panel_open(p,left,top,win_left,win_top,win_width,win_height)
leda_panel p;
int left,top;
int win_left;
int win_top;
int win_width;
int win_height;
{ 
  Panel_item cont_but, quit_but;
  Rect	*r;

  int width,height,delta;
  int i;

  current_panel = p;

  if (p->but_count == 0)   /* default buttons: continue /quit */
  {
   p->panel_row+=50;
   
   cont_but = panel_create_item(p->panel, PANEL_BUTTON, 

#ifdef XVIEW
             PANEL_LABEL_STRING, "continue",       
#else
             PANEL_LABEL_IMAGE,panel_button_image(p->panel,"continue",0,0),
#endif
                           PANEL_NOTIFY_PROC, panel_button_notify,
                           PANEL_CLIENT_DATA,-1,
                           PANEL_ITEM_Y, p->panel_row,
                           PANEL_ITEM_X, 180,
                  0);

   quit_but = panel_create_item(p->panel, PANEL_BUTTON, 

#ifdef XVIEW
             PANEL_LABEL_STRING, "quit",       
#else
             PANEL_LABEL_IMAGE,panel_button_image(p->panel,"quit",0,0),
#endif
                           PANEL_NOTIFY_PROC, panel_button_notify,
                           PANEL_CLIENT_DATA,-2,
                           PANEL_ITEM_Y, p->panel_row,
                    0);

   }

   else 
     if (p->but_line_count > 0) x_draw_panel_button_line(p,0,0);



#ifndef XVIEW
  panel_create_item(p->panel, PANEL_MESSAGE, 
                           PANEL_LABEL_BOLD, TRUE,
                           PANEL_LABEL_STRING, " ",
                           PANEL_ITEM_X, 20,
                           PANEL_ITEM_Y, p->panel_row+25,
	                   0);
#endif

 
  window_fit(p->panel);
  window_fit(p->panel_frame);


/* center buttons */

   delta = ((int) window_get(p->panel,WIN_WIDTH) - p->button_width - 10)/2;

   for (i=0;i<p->but_count;i++)
     if (p->but_centered[i] == 0)
     { panel_set(p->but_item[i],PANEL_ITEM_X, 
                 panel_get(p->but_item[i],PANEL_ITEM_X) + delta, 0);
       p->but_centered[i] = 1;
      }


  if (left<0 || top <0)
  {
    /* center panel frame on the screen */

    width = (int) window_get(p->panel_frame, WIN_WIDTH);
    height = (int) window_get(p->panel_frame, WIN_HEIGHT);

    if (win_width == 0)
    {  r = (Rect *) window_get(p->panel_frame, WIN_SCREEN_RECT);
      left = (r->r_width  - width) / 2;
      top  = (r->r_height - height)/ 2;
      if (left < 0) left = 0;
      if (top < 0) top = 0;
     }
    else
    { left = (win_width  - width) / 2;
      top  = (win_height - height)/ 2;
     }
  }

  left += win_left;
  top  += win_top;


  window_set(p->panel_frame, WIN_X, left, WIN_Y, top, 0);

 
  window_main_loop(p->panel_frame);
 
  window_set(p->panel_frame,WIN_SHOW,FALSE,0);


  if (p->but_count == 0)
  { panel_destroy_item(cont_but);
    panel_destroy_item(quit_but);
    p->panel_row -= 50;
   }
 

  if (panel_button_answer == -2) exit(0);
 
  return panel_button_answer;

}

