/*******************************************************************************
+
+  LEDA  3.0
+
+
+  node_pq.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/


#ifndef LEDA_NODE_PQ_H
#define LEDA_NODE_PQ_H

//------------------------------------------------------------------------------
// node priority queues
//------------------------------------------------------------------------------

#include <LEDA/graph.h>
#include <LEDA/impl/f_heap.h>


template <class itype>

class _CLASSTYPE node_pq : private f_heap, private graph_array(node)
{

int cmp(GenPtr x, GenPtr y)  const
                         { return compare(ACCESS(itype,x),ACCESS(itype,y)); }
void print_key(GenPtr x)    const { Print(ACCESS(itype,x)); }
void print_inf(GenPtr x)    const { Print(GenPtr(x));  }
void clear_key(GenPtr& x)   const { Clear(ACCESS(itype,x)); }
void copy_key(GenPtr& x)    const { x=Copy(ACCESS(itype,x));  }

int  int_type()             const { return INT_TYPE(itype); }

public:
 node_pq(const graph& G) { graph_array(node)::init(G,0); }
~node_pq()               { graph_array(node)::clear();   }

void decrease_inf(node v, itype i)
{ f_heap::decrease_key(f_heap_item(arr[index(v)]),Convert(i)); }

void insert(node v,itype i)
{ arr[index(v)]=(GenPtr)f_heap::insert(Convert(i),GenPtr(v));}

itype inf(node v)
{ return ACCESS(itype,f_heap::key((f_heap_item)arr[index(v)])); }

void del(node v) 
{ f_heap::del_item(f_heap_item(arr[index(v)])); arr[index(v)] = 0; }

node find_min()  
{ return (node)f_heap::inf(f_heap::find_min());   }

node del_min()   
{ node v = find_min(); f_heap::del_min(); arr[index(v)] = 0; return v; }

bool member(node v) 
{ return (arr[index(v)] == 0) ? false : true; } 

void clear()     { f_heap::clear(); }
int size()       { return f_heap::size(); }
int empty()      { return f_heap::empty(); }

};


#endif
