 /*
  * Khoros: $Id$
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vhgline.c
 >>>>
 >>>>      Program Name: vhgline
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Draw lines for Fast Inverse Hough (Grey level) Transforms.
 >>>>	
 >>>>	

 >>>>            Author: Patrick Arnoul, Jean-Pierre Guerin, Jean-Francois Larue
 >>>>
 >>>> Date Last Updated: Thu Mar 26 10:43:14 1992
 >>>>
 >>>>          Routines: main- the main program for vhgline
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vhgline.h"


/****************************************************************
 *
 * Routine Name:  main program for vhgline
 *
 *       Input:  
 *         -i  input plot file to be drawn 
 *         -o  resulting output image 
 *
 *
 *         [-s] Size of the Output Image  (value > 0)
 *         [-d] draw 4 lines surrounding the inverse transformed image
 *         [-l] selects one (one pixel wide) or zero (Not Aliased Line)
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct  xvimage  *image2, *writeimage();
long vff_type;
FILE *grid_file;
 
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
grid_file = fopen(vhgline->i_file,"r");
if ( grid_file == (FILE *)NULL )
        {
        printf("Can't open %s ...\n",vhgline->i_file);
        exit(0);
        }

image2 = createimage(vhgline->s_int,vhgline->s_int,
                     VFF_TYP_1_BYTE,1,
                     1,"", 0, 0, VFF_MS_NONE,
                     VFF_MAPTYP_NONE, VFF_LOC_IMPLICIT, 0);
   
/* -main_before_lib_call_end */

/* -main_library_call */

  if (!lvhgline(grid_file, image2,  vhgline->d_logic, vhgline->l_logic))
    {
        (void) fprintf (stderr,"%s: lvhgline failed ...\n", program);
        exit (1);
    }
  
/* -main_library_call_end */

/* -main_after_lib_call */
  fclose( grid_file );
  WRITEOUTPUT(image2); 
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vhgline 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vhgline :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tDraw lines for Fast Inverse Hough (Grey level) Transforms.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input plot file to be drawn  (infile)\n");
	fprintf(stderr,"\t-o  resulting output image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-s]  Size of the Output Image (integer, > 0) [256]\n");
	fprintf(stderr,"\t[-d]  draw 4 lines surrounding the inverse transformed image (boolean) [false]\n");
	fprintf(stderr,"\t[-l]  selects one (one pixel wide) or zero (Not Aliased Line) (boolean) [false]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vhgline\n");
	fprintf(stderr, "\t[-U] Gives the usage for vhgline\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vhgline.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vhgline.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vhgline
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input plot file to be drawn \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output image \n        {outfile}: "; 
char	*s_pstr = 
	"\nEnter: (s) Size of the Output Image \n        {integer, > 0 [256] }: "; 
char	*d_pstr = 
	"\nEnter: (d) draw 4 lines surrounding the inverse transformed image \n        {boolean, (y/n)  [no] }: "; 
char	*l_pstr = 
	"\nEnter: (l) selects one (one pixel wide) or zero (Not Aliased Line) \n        {boolean, (y/n)  [no] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vhgline", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vhgline.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vhgline: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vhgline.ans");
		}

	     }

	}

	/*
	 * allocate the vhgline structure
	 */
	vhgline = (vhgline_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vhgline_struct));

	/*
	 * get required arguments for vhgline
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vhgline->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vhgline->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vhgline->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vhgline->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vhgline->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vhgline->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vhgline->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vhgline->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vhgline->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vhgline->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vhgline
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vhgline->s_flag = vget_int(fid, prompt_flag,
	"-s", s_pstr, &(vhgline->s_int),
	256, 2, 2);

	vhgline->d_flag = vget_logic(fid, prompt_flag,
	"-d", d_pstr, &(vhgline->d_logic), 0);

	vhgline->l_flag = vget_logic(fid, prompt_flag,
	"-l", l_pstr, &(vhgline->l_logic), 0);


}



