 /*
  * Khoros: $Id$
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lissaj.c
 >>>>
 >>>>      Program Name: lissaj
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Create a lissajou Ascii XY data file from two 1D  Viff  data
 >>>>	files.  The output file is to be plotted by xprism2.
 >>>>	
 >>>>	

 >>>>            Author: Patrick Arnoul
 >>>>
 >>>> Date Last Updated: Thu Mar 26 10:43:51 1992
 >>>>
 >>>>          Routines: main- the main program for lissaj
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "lissaj.h"


/****************************************************************
 *
 * Routine Name:  main program for lissaj
 *
 *       Input:  
 *        -i1  input 1D data file to be used as X data 
 *        -i2  input 1D data file to be used as X data 
 *        -o  resulting ascii XY data to be plotted by prism2 
 *
 *
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *sig1, *sig2, *readimage();
FILE *ascii;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
sig1 = readimage(lissaj->i1_file);
        if (sig1 == NULL) exit(1);

sig2 = readimage(lissaj->i2_file);
        if (sig2 == NULL) exit(1);

if ( ( sig1->row_size != 1 ) || ( sig2->row_size != 1 ) )
    {
    fprintf(stderr,"%s : Input Signals must be 1D...\n",program);
    exit(1);
    }

if ( sig1->col_size != sig2->col_size )
    {
    fprintf(stderr,"%s : Input Signals must have same size...\n",program);
    exit(1);
    }



ascii = fopen(lissaj->o_file,"w");
if ( ascii == (FILE *)NULL )
        {
        printf("Can't open %s ...\n",lissaj->o_file);
        exit(0);
        }
/* -main_before_lib_call_end */

/* -main_library_call */
if ( !llissaj(sig1,sig2,ascii) )
    {
        (void)fprintf(stderr,"%s: llissaj failed ...\n",program);
        exit(1);
    }

/* -main_library_call_end */

/* -main_after_lib_call */
fclose(ascii);

/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for lissaj 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "lissaj :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tCreate a lissajou Ascii XY data file from two 1D  Viff  data\n");
	fprintf(stderr, "\tfiles.  The output file is to be plotted by xprism2.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i1  input 1D data file to be used as X data  (infile)\n");
	fprintf(stderr,"\t-i2  input 1D data file to be used as X data  (infile)\n");
	fprintf(stderr,"\t-o  resulting ascii XY data to be plotted by prism2  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for lissaj\n");
	fprintf(stderr, "\t[-U] Gives the usage for lissaj\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called lissaj.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses lissaj.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for lissaj
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i1_pstr = 
	"\nEnter: (i1) input 1D data file to be used as X data \n        {infile}: "; 
char	*i2_pstr = 
	"\nEnter: (i2) input 1D data file to be used as X data \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting ascii XY data to be plotted by prism2 \n        {outfile}: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "lissaj", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "lissaj.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "lissaj: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "lissaj.ans");
		}

	     }

	}

	/*
	 * allocate the lissaj structure
	 */
	lissaj = (lissaj_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (lissaj_struct));

	/*
	 * get required arguments for lissaj
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(lissaj->i1_flag = vget_infile(fid, prompt_flag,
			"-i1", i1_pstr, &(lissaj->i1_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(lissaj->i1_flag))
		{
		    fprintf(stderr, "\t\ti1 is required, please re-enter: \n");
		    lissaj->i1_flag = vget_infile(fid, prompt_flag,
		    "-i1", i1_pstr, &(lissaj->i1_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i1' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(lissaj->i2_flag = vget_infile(fid, prompt_flag,
			"-i2", i2_pstr, &(lissaj->i2_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(lissaj->i2_flag))
		{
		    fprintf(stderr, "\t\ti2 is required, please re-enter: \n");
		    lissaj->i2_flag = vget_infile(fid, prompt_flag,
		    "-i2", i2_pstr, &(lissaj->i2_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i2' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(lissaj->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(lissaj->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(lissaj->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    lissaj->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(lissaj->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}


}



