 /*
  * Khoros: $Id: run_output.c,v 1.3 1991/12/18 08:58:52 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: run_output.c,v 1.3 1991/12/18 08:58:52 dkhoros Exp $";
#endif

 /*
  * $Log: run_output.c,v $
 * Revision 1.3  1991/12/18  08:58:52  dkhoros
 * HellPatch3
 *
  */ 



/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 *
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "xprism3.h"
#include "vsignal.h"


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    file name: run_output
   >>>>               
   >>>>   description: runs the output subform
   >>>>              
   >>>>      routines:
   >>>>			run_output
   >>>>			run_output_files
   >>>>			run_output_postscr
   >>>>			run_output_imagen
   >>>>			run_output_hpgl
   >>>>			run_output_ln03
   >>>>			get_filename
   >>>>			get_printer_file
   >>>>			send_printer_output
   >>>>              
   >>>> modifications:
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


#define Vector		1
#define RASTER		2

#define TEMPLATE	"XprismXXXXXX"

struct  xvimage *raster_screendump();
FILE *get_printer_file();
FILE *get_filename();

/************************************************************
*
*  MODULE NAME: run_output
*
*
*      PURPOSE: Drives the Output subform --
*               Called after the user clicks on an action
*               button on one of the "Output" subform's panes.
*
*	INPUT:  form - pointer to the form tree
*		output_info - pointer to the Output Pane information structure
*
*       OUTPUT: none
*
*    CALLED BY: main
*
*    WRITTEN BY: Danielle Argiro and Mark Young
*
*
*************************************************************/


run_output(form, output_info)

xvf_form	*form;
Master_output	*output_info;
{
	char *mesg;

	 /*
	  * get the form information structure indicating
	  * selections & and input provided by the user
	  */
	_xvf_get_output(form, output_info);
	            
	if (output_info->quit)
	    xvf_change_active(form, false);

	else if (gwin == NULL)
        {
             mesg = xvf_strcpy("Cannot output anything-- no graphics workspace present!\n");
             xvf_error_wait(mesg, "run_output", NULL);
             free(mesg);
             return;
        }

	else if (output_info->file_selected)
	   run_output_files(form, output_info->file);

	else if (output_info->postscr_selected)
	   run_output_postscr(form, output_info->postscr);

	else if (output_info->imagen_selected)
	   run_output_imagen(form, output_info->imagen);

	else if (output_info->hpgl_selected)
           run_output_hpgl(form, output_info->hpgl);

	else if (output_info->ln03_selected)
	   run_output_ln03(form, output_info->ln03);

}  /* end run_output */



/************************************************************
*
*  MODULE NAME: run_output_files
*
*
*      PURPOSE: Drives the Files pane of the Output subform --
*               Called after the user clicks on "OUTPUT EXPLICIT FILE",
*		"OUTPUT IMPLICIT FILE", or "OUTPUT SCREEN DUMP",
*		creates the specified output file under the filename given.
*
*	INPUT:  form - pointer to the form tree
*		output_info - pointer to the Output Pane information structure
*
*       OUTPUT: none
*
*    CALLED BY: main
*
*    WRITTEN BY: Danielle Argiro and Mark Young
*
*
*************************************************************/

run_output_files(form, file_info)

xvf_form *form;
output_file *file_info;
{
	struct	xvimage *image;
	char 	temp[512], *filename = NULL, *filestring, *mesg;

	_xvf_get_file(form, file_info);

	if (file_info->expl_filename_selected)
	{
	    if (file_info->expl_filename == NULL)
	    {
 	    	mesg = xvf_strcpy("\nPlease specify the name of the output \
file on the 'Filename' parameter for Explicit Khoros Files\n");
            	xvf_error_wait(mesg, "run_output_files", NULL);
            	free(mesg);
            	return;
            }
	    filestring = vfullpath(file_info->expl_filename, 
				    global_outdir, NULL);
    	    if (output_IFF_explicit(filestring))
	    {
    	         sprintf(temp,"Explicit khoros file created in '%s'\n", filestring);
                 xvf_error_wait(temp, "run_output", NULL);
	    }
        }
	else if (file_info->impl_filename_selected)
	{
	    if (file_info->impl_filename == NULL)
	    {
	         mesg = xvf_strcpy("\nPlease specify the name of the output \
file on the 'Filename' parameter for Implicit Khoros Files\n");
		 xvf_error_wait(mesg, "run_output_files", NULL);
		 free(mesg);
		 return;
	    }

	    filestring = vfullpath(file_info->impl_filename, 
				    global_outdir, NULL);
    	    if (output_IFF_implicit(filestring))
	    {
    	        sprintf(temp,"Implicit khoros file created in '%s'\n", filestring);
                xvf_error_wait(temp, "run_output", NULL);
	    }
	}
        else if (file_info->cm_filename_selected)
        {
            if (file_info->cm_filename == NULL)
            {
                 mesg = xvf_strcpy("\nPlease specify the name of the output \
file on the 'Filename' parameter for outputting a VIFF colormap file\n");
                 xvf_error_wait(mesg, "run_output_files", NULL);
                 free(mesg);
                 return;
            }

            filestring = vfullpath(file_info->cm_filename,
                                      global_outdir, NULL);

            if (output_colormap(filestring))
            {
                sprintf(temp,"Khoros VIFF Colormap file created in '%s'\n",
		         filestring);
                xvf_error_wait(temp, "run_output", NULL);
            }
        }
	else if (file_info->dump_filename_selected)
	{
	    if (file_info->dump_filename == NULL)
	    {
	         mesg = xvf_strcpy("\nPlease specify the name of the output \
file on the 'Filename' parameter for Screen Dump Files\n");
		 xvf_error_wait(mesg, "run_output_files", NULL);
		 free(mesg);
		 return;
	    }
	    filestring = vfullpath(file_info->dump_filename, 
				    global_outdir, NULL);
	    if (!(image = raster_screendump(FALSE)))
	    {
	       return;
	    }

	    if (writeimage(filestring, image))
	    {
    	       sprintf(temp,"Screen Dump created in '%s'\n", filestring);
               xvf_error_wait(temp, "run_output_files", NULL);
	    }
	    else
	    {
    	       sprintf(temp,"Unable to write image file '%s'\n", filestring);
               xvf_error_wait(temp, "run_output_files", NULL);
	    }
	    freeimage(image);
    	}
	else
	{
    	    sprintf(temp,"Internal error.  Unknown action.\n");
            xvf_error_wait(temp, "run_output_files", NULL);
	}
        if (filename != NULL)
	  free(filename); 
 	if (filestring != NULL)
          free(filestring);
}



/************************************************************
*
*  MODULE NAME: run_output_postscr
*
*
*      PURPOSE: Drives the Postscript pane of the Output subform --
*               Called after the user clicks on "OUTPUT TO FILE" or
*		"OUTPUT TO PRINTER", sends the workspace to the specified
*		postscript printer, or in postscript format to the file
*		given.
*
*	INPUT:  form - pointer to the form tree
*		postscr - pointer to the Postscript Pane information 
*		structure
*
*       OUTPUT: none
*
*    CALLED BY: main
*
*    WRITTEN BY: Danielle Argiro and Mark Young
*
*
*************************************************************/


run_output_postscr(form, postscr)

xvf_form *form;
output_postscr *postscr;
{
	char	temp[512], *tmpfile;
	FILE	*file;
	static  FILE	*ffile = NULL, *pfile = NULL;
	struct  xvimage *image;

	_xvf_get_postscr(form, postscr);

	if (postscr->printer_selected)
	{
	   if (pfile == NULL)
	   {
	      tmpfile = vtempnam(TEMPLATE);
	      if (!(pfile = get_printer_file(pfile, tmpfile, postscr->printer)))
                 return;
	   }
	   file = pfile;
	}
	else if (postscr->filename_selected)
	{
	   if (!(ffile = get_filename(ffile, postscr->filename)))
               return;
	   file = ffile;
	}
	else
	   return;

	/* outputting in RASTER (screen dump)  format */
	if (postscr->output_type_val == RASTER)
	{
	   /* Create raster image.  */
 	   if (!(image = raster_screendump(FALSE)))
	      return;

	   if (!lvpostscr(file, image, postscr->flush, postscr->invert,1,1,1,1,
		          postscr->width, postscr->height, postscr->x_offset,
			  postscr->y_offset, postscr->landscape))
	   {
	      sprintf(temp,"lvpostscr failed!  Unable to send output.\n");
              xvf_error_wait(temp, "run_output_postscr", NULL);
	      freeimage(image); return;
	   }
	   freeimage(image);
	}
	/*outputting Vector quality output */
	else if(postscr->output_type_val == Vector)
	{
	   X3D_set_postscript(gwin->id, file, postscr->width, postscr->height,
		postscr->x_offset, postscr->y_offset, postscr->flush, 
		postscr->landscape, postscr->mono, postscr->invert, &bg);
	   xp_device = xpPostscript;
	   plot_routine();

	   if (postscr->flush)
	      X3D_close_device(gwin->id);
	   else
	      fprintf(file, "restore\n");

	   X3D_set_X11(gwin->id, display, gwin->workspace, gwin->xprism_widget);
	   X3D_set_line_width(gwin->id, ExtraFine);
	   xp_device = xpX11;
	}

	/*
	 *  If flush is true then close the file and set the file pointer to
	 *  NULL.  Send the file to the printer (if the printer command was
	 *  specified).
	 */
	if (postscr->flush)
	{
	   fclose(file);
	   if (postscr->filename_selected)
	   {
              sprintf(temp,"Workspace sent to file '%s'\n", postscr->filename);
              xvf_error_wait(temp, "run_output_postscr", NULL);
	      ffile = NULL;
	   }
	   else if (postscr->printer_selected)
	   {
              if ((VStrlen(postscr->printer_cmd)) == 0)
              {
                 xvf_error_wait("Error: Printer command was not specified. \
Please specify a printer command",
                 "run_output_postscr", NULL);
                 return;
              }
	      pfile = NULL;
	      send_printer_output(tmpfile, postscr->printer,
				  postscr->printer_cmd);
	      free(tmpfile);
	   }
	}
	else
	{
           (void) sprintf(temp,"Workspace sent to temporary file.  Output will \
not be created until 'flush postscript output' is specified.\n");
           xvf_error_wait(temp, "run_output_postscr", NULL);
	}
}



/************************************************************
*
*  MODULE NAME: run_output_imagen
*
*
*      PURPOSE: Drives the Imagen pane of the Output subform --
*               Called after the user clicks on "OUTPUT TO FILE" or
*		"OUTPUT TO PRINTER", sends the workspace to the specified
*		imagen printer, or in impress format to the file given.
*
*	INPUT:  form - pointer to the form tree
*		imagen_info - pointer to the Postscript Pane information 
*			      structure
*
*       OUTPUT: none
*
*    CALLED BY: main
*
*    WRITTEN BY: Danielle Argiro and Mark Young
*
*
*************************************************************/

run_output_imagen(form, imagen)

xvf_form *form;
output_imagen *imagen;
{
	char	temp[512], *tmpfile;
	FILE	*file;
	static  FILE	*ffile = NULL, *pfile = NULL;
	struct  xvimage *image;


	_xvf_get_imagen(form, imagen);

	if (imagen->printer_selected)
	{
	   if (pfile == NULL)
	   {
	      tmpfile = vtempnam(TEMPLATE);
	      if (!(pfile = get_printer_file(pfile, tmpfile, imagen->printer)))
                 return;
	   }
	   file = pfile;
	}
	else if (imagen->filename_selected)
	{
	   if (!(ffile = get_filename(ffile, imagen->filename)))
               return;
	   file = ffile;
	}
	else
	   return;

	/* outputting in RASTER (screen dump)  format */
	if (imagen->output_type_val == RASTER)
	{
	   /* Create raster image.  */
 	   if (!(image = raster_screendump(TRUE)))
	      return;

	   if (!lvlaser(file, image, 1, imagen->x_offset, imagen->y_offset,
			 imagen->invert, !imagen->flush))
	   {
	      sprintf(temp,"lvlaser failed!  Unable to send output.\n");
              xvf_error_wait(temp, "run_output_imagen", NULL);
	      freeimage(image); return;
	   }
	   freeimage(image);
	}
	/*outputting Vector quality output */
	else if(imagen->output_type_val == Vector)
	{
	   X3D_set_impress(gwin->id, file, imagen->width, imagen->height,
		imagen->x_offset, imagen->y_offset, imagen->flush, 
		imagen->invert);
	   xp_device = xpImpress;
	   plot_routine();

	   if (imagen->flush)
	      X3D_close_device(gwin->id);

	   X3D_set_X11(gwin->id, display, gwin->workspace, gwin->xprism_widget);
	   X3D_set_line_width(gwin->id, ExtraFine);
	   xp_device = xpX11;
	}

	/*
	 *  If flush is true then close the file and set the file pointer to
	 *  NULL.  Send the file to the printer (if the printer command was
	 *  specified).
	 */
	if (imagen->flush)
	{
	   fclose(file);
	   if (imagen->filename_selected)
	   {
	      ffile = NULL;
              sprintf(temp,"Workspace sent to file '%s'\n", imagen->filename);
              xvf_error_wait(temp, "run_output_imagen", NULL);
	   }
	   else if (imagen->printer_selected)
	   {
              if ((VStrlen(imagen->printer_cmd)) == 0)
              {
                 xvf_error_wait("Error: Printer command was not specified. \
Please specify a printer command",
                 "run_output_imagen", NULL);
                 return;
              }
	      pfile = NULL;
	      send_printer_output(tmpfile, imagen->printer,imagen->printer_cmd);
	      free(tmpfile);
	   }
	}
	else
	{
           (void) sprintf(temp,"Workspace sent to temporary file.  Output will \
not be created until 'flush imagen output' is specified.\n");
           xvf_error_wait(temp, "run_output_imagen", NULL);
	}
}  /* end run_output_imagen */



/************************************************************
*
*  MODULE NAME: run_output_hpgl
*
*
*      PURPOSE: Drives the HPGL pane of the Output subform --
*               Called after the user clicks on "OUTPUT TO FILE" or
*		"OUTPUT TO PRINTER", sends the workspace to the specified
*		plotter printer, or in HPGL format to the file
*		given.
*
*	INPUT:  form - pointer to the form tree
*		hpgl - pointer to the Postscript Pane information 
*		structure
*
*       OUTPUT: none
*
*    CALLED BY: main
*
*    WRITTEN BY: Danielle Argiro and Mark Young
*
*
*************************************************************/


run_output_hpgl(form, hpgl)

xvf_form *form;
output_hpgl *hpgl;
{
	char	temp[512], *tmpfile;
	FILE	*file, *get_printer_file(), *get_filename();
	static  FILE	*ffile = NULL, *hfile = NULL;

	_xvf_get_hpgl(form, hpgl);

	if (hpgl->printer_selected)
	{
	   if (hfile == NULL)
	   {
	      tmpfile = vtempnam(TEMPLATE);
	      if (!(hfile = get_printer_file(hfile, tmpfile, hpgl->printer)))
                 return;
	   }
	   file = hfile;
	}
	else if (hpgl->filename_selected)
	{
	   if (!(ffile = get_filename(ffile, hpgl->filename)))
               return;
	   file = ffile;
	}
	else
	   return;

	/*outputting Vector quality output */
	X3D_set_HPGL(gwin->id, file, hpgl->width, hpgl->height,
	   hpgl->x_offset, hpgl->y_offset, hpgl->flush, 
	   hpgl->landscape);
	xp_device = xpHPGL;
	plot_routine();

	if (hpgl->flush)
	   X3D_close_device(gwin->id);

	X3D_set_X11(gwin->id, display, gwin->workspace, gwin->xprism_widget);
	X3D_set_line_width(gwin->id, ExtraFine);
	xp_device = xpX11;

	/*
	 *  If flush is true then close the file and set the file pointer to
	 *  NULL.  Send the file to the printer (if the printer command was
	 *  specified).
	 */
	if (hpgl->flush)
	{
	   fclose(file);
	   if (hpgl->filename_selected)
	   {
              sprintf(temp,"Workspace sent to file '%s'\n", hpgl->filename);
              xvf_error_wait(temp, "run_output_hpgl", NULL);
	      ffile = NULL;
	   }
	   else if (hpgl->printer_selected)
	   {
              if ((VStrlen(hpgl->printer_cmd)) == 0)
              {
                 xvf_error_wait("Error: Printer command was not specified. \
Please specify a printer command",
                 "run_output_hpgl", NULL);
                 return;
              }
	      hfile = NULL;
	      send_printer_output(tmpfile, hpgl->printer, hpgl->printer_cmd);
	      free(tmpfile);
	   }
	}
	else
	{
           (void) sprintf(temp,"Workspace sent to temporary file.  Output will \
not be created until 'flush hpgl output' is specified.\n");
           xvf_error_wait(temp, "run_output_hpgl", NULL);
	}
}



/************************************************************
*
*  MODULE NAME: run_output_ln03
*
*
*      PURPOSE: Drives the Imagen pane of the Output subform --
*               Called after the user clicks on "OUTPUT TO FILE" or
*		"OUTPUT TO PRINTER", sends the workspace to the specified
*		ln03 printer, or in impress format to the file given.
*
*	INPUT:  form - pointer to the form tree
*		ln03 - pointer to the Postscript Pane information structure
*
*       OUTPUT: none
*
*    CALLED BY: main
*
*    WRITTEN BY: Danielle Argiro, Mark Young, and Mike Lang
*
*
*************************************************************/


run_output_ln03(form, ln03)

xvf_form *form;
output_ln03 *ln03;
{
	char	temp[512], *tmpfile;
	FILE	*file;
	static	FILE *pfile = NULL, *ffile = NULL;
	struct  xvimage *image;


	_xvf_get_ln03(form, ln03);

	if (ln03->printer_selected)
	{
	   if (pfile == NULL)
	   {
	      tmpfile = vtempnam(TEMPLATE);
	      if (!(pfile = get_printer_file(pfile, tmpfile, ln03->printer)))
                 return;
	      file = pfile;
	   }
	}
	else if (ln03->filename_selected)
	{
	   if (!(ffile = get_filename(ffile, ln03->filename)))
               return;
	   file = ffile;
	}
	else
	   return;

	if (!(image = raster_screendump(TRUE)))
	   return;

	if (!lvln03(file, image, ln03->invert))
	{
    	   sprintf(temp,"lvln03 failed!  Unable to send output.\n");
           xvf_error_wait(temp, "run_output_ln03", NULL);
	   freeimage(image); return;
	}
	freeimage(image);

	/*
	 *  flush is always true; so close the file and set the file pointer to
	 *  NULL.  Send the file to the printer (if the printer command was
	 *  specified).
	 */
	fclose(file);
	if (ln03->filename_selected)
	{
            sprintf(temp,"Workspace sent to file '%s'\n", ln03->filename);
            xvf_error_wait(temp, "run_output_ln03", NULL);
            ffile = NULL;
        }
	else
	{
           if ((VStrlen(ln03->printer_cmd)) == 0)
           {
              xvf_error_wait("Error: Printer command was not specified. \
Please specify a printer command",
                "run_output_postscr", NULL);
              return;
           }
	   pfile = NULL;
	   send_printer_output(tmpfile, ln03->printer, ln03->printer_cmd);
	   free(tmpfile);
	}
}



/************************************************************
*
*  MODULE NAME: get_filename
*
*      PURPOSE:
*
*        INPUT:
*
*       OUTPUT:
*
*    CALLED BY:
*
*   WRITTEN BY:  Mike Lang & Mark Young
*
*************************************************************/


FILE *get_filename(file, filename)

FILE	*file;
char	*filename;
{
	char 	*mesg, temp[512], *filestring;

	if (filename == NULL)
	{
	   mesg = xvf_strcpy("\nPlease specify the name of the file on the 'Filename' parameter for outputting the workspace.\n");
	   xvf_error_wait(mesg, "get_filename", NULL);
	   free(mesg); return(NULL);
	}

	if (file == NULL)
	{
	   filestring = vfullpath(filename, global_outdir, NULL);
	   if (!(file = fopen(filestring, "w+")))
	   {
	      sprintf(temp,"Unable to open temporary file '%s'\n",filename);
	      xvf_error_wait(temp, "get_filename", NULL);
	      free(filestring);
	      return(NULL);
	   }
	   free(filestring);
	}
	return(file);
}



/************************************************************
*
*  MODULE NAME: get_printer_file
*
*      PURPOSE:
*
*        INPUT:
*
*       OUTPUT:
*
*    CALLED BY:
*
*   WRITTEN BY:  Mike Lang & Mark Young
*
*************************************************************/


FILE *get_printer_file(file, filename, printer)

FILE	*file;
char	*filename, *printer;
{
	char	temp[512];

	/* check that user has specified a valid printer */
	if (printer == NULL)
	{
	   xvf_error_wait("Please specify the name of the printer on the 'Printer' parameter for outputting workspace.", "get_printer_file", NULL);
	   return(NULL);
	}

	if (file == NULL)
	{
           if (!(file = fopen(filename, "w+")))
	   {
    	      sprintf(temp,"Unable to open temporary file '%s'\n",filename);
              xvf_error_wait(temp, "get_printer_file", NULL);
	      return(NULL);
	    }
	}
	return(file);
}



/************************************************************
*
*  MODULE NAME: send_printer_output
*
*      PURPOSE:
*
*        INPUT: fid - the file descriptor to dump to
*
*
*       OUTPUT:
*
*    CALLED BY:
*
*   WRITTEN BY:
*
*************************************************************/

send_printer_output(filename, printer, cmd)

char	*filename, *printer, *cmd;
{
	int	pid;
	char	*mesg, *argv[4], temp[512];
	vstatus status;

	/* check that user has specified a valid printer */
	if (printer == NULL)
	{
	   mesg = xvf_strcpy("\nPlease specify the name of the printer on the 'Printer' parameter for outputting workspace.\n");
	   xvf_error_wait(mesg, "send_printer_output", NULL);
	   free(mesg); 
	   return;
	}

	/*
	 * send the file to the named printer
	 */
#ifdef VFORK
        if ((pid = vfork()) == 0)
#else
        if ((pid = fork()) == 0)
#endif
	{
           (void) sprintf(temp,"%s%s %s >& /dev/null", cmd, printer, filename);
           (void) execl("/bin/csh", "csh", "-cf", temp, (char *)0);
           _exit(1);
	}

	while (pid != vwait3(&status, NULL, NULL))
		  ;

	if (WIFEXITED(status) == 0)
	{
	   (void) sprintf(temp, "Could not send temporary file '%s' to printer '%s'. Please make sure that the printer exists.", filename, printer);
	   xvf_error_wait(temp, "send_printer_output", NULL);
	}
	else if (WEXITSTATUS(status) != 0)
	{
	   (void) sprintf(temp, "Could not send temporary file '%s' to printer '%s'. Please make sure that the printer exists and is avalable for printing",
	   filename, printer);
	   xvf_error_wait(temp, "send_printer_output", NULL);
	}
	else
	{
           (void) sprintf(temp,"Workspace sent to printer '%s'\n", printer);
           xvf_error_wait(temp, "send_printer_output", NULL);
	}
	unlink(filename);
}
