 /*
  * Khoros: $Id: viewimage.h,v 1.3 1992/03/20 22:51:56 dkhoros Exp $
  */

 /*
  * $Log: viewimage.h,v $
 * Revision 1.3  1992/03/20  22:51:56  dkhoros
 * VirtualPatch5
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: viewimage.h
 >>>>            Author: Mark Young
 >>>> Date Last Updated: Fri Apr 26 10:42:31 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _viewimage_h_
#define _viewimage_h_

#include "xvinclude.h"


/* -include_includes */
#include "xvforms.h"
#include "xvdisplay.h"
#include "form_info.h"
#include "structs.h"

#include "Plot.h"
#include "PlotObj.h"
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    viewimage Argument Structure
*
****************************************************************/

typedef struct _viewimage  {

/*
 *  input image filename (Required infile)
 */
char	*i;     	/* input image filename FILENAME */
int	 i_flag;	/* input image filename FLAG */

/*
 *  image with alternate elevation coordinates (Optional infile)
 */
char	*e;     	/* image with alternate elevation coordinates FILENAME */
int	 e_flag;	/* image with alternate elevation coordinates FLAG */

/*
 *  x value of upper-left corner of image (Optional integer)
 */
int	 x;    	/* x value of upper-left corner of image INT */
int	 x_flag;	/* x value of upper-left corner of image FLAG */

/*
 *  y value of upper-left corner of image (Optional integer)
 */
int	 y;    	/* y value of upper-left corner of image INT */
int	 y_flag;	/* y value of upper-left corner of image FLAG */

/*
 *  initial update time (Optional float)
 */
float	 update;      	/* initial update time FLOAT */
int	 update_flag;   	/* initial update time FLAG */

/*
 *  host:display.screen (Optional string)
 */
char	*display;       	/* host:display.screen STRING */
int	 display_flag;   	/* host:display.screen FLAG */

/*
 *  image with alternate colormap filename (Optional infile)
 */
char	*cmap_image;     	/* image with alternate colormap filename FILENAME */
int	 cmap_image_flag;	/* image with alternate colormap filename FLAG */

/*
 *  use colormap? (Optional logical)
 */
int	 use_cmap;      	/* use colormap? LOGIC */
int	 use_cmap_flag;  	/* use colormap? FLAG */

/*
 *  use proportional plotting (makes the data be a unit cube) (Optional logical)
 */
int	 prop;      	/* use proportional plotting (makes the data be a unit cube) LOGIC */
int	 prop_flag;  	/* use proportional plotting (makes the data be a unit cube) FLAG */

}  viewimage_struct;

viewimage_struct *viewimage;

/* -include_additions */

/*
 *  Colorspace encoding schemes used by Pseudo, Pixels, & Lut
 */
#define RGB     1
#define CMY     2
#define HSV     3
#define HLS     4
#define YIQ     5
#define XYZ     6
#define UVW     7
#define GREY    8

/*
 *   global input & output directories
 */
char *global_indir;
char *global_outdir;

/*
 *  Viewing defines
 */
#define EyeDist   8.0
#define Alpha    63.7
#define Theta    31.8

/*
 *  structure holding information about the threshold display
 */
#define Windowing    1
#define Thresholding 2

/*
 *  Types for histogram
 */
#define Continuous 0
#define Filled     1
#define Discrete   2

#define MaxArg 25

void update_palette();
void update_pseudo_cont(), update_pseudo_incr();
void update_thres_cont(), update_thres_incr();
void update_persp_cont(), update_persp_incr();

void update_lut();
void update_canvas();
void redisplay_lut();


int      index1, index2;
int      lut_width, lut_height, lut_xpos, lut_ypos;
Boolean  active[MAX_PIXELS];

Display   *display;
xvf_form  *form;
view view_info;

DisplayStructure *xvdisplay;
PlotStructure    *plot;
PseudoStructure  *pseudo;
LutStructure     *lut;
ThresStructure   *thres;
PerspStructure   *persp;

struct xvimage *images, **band, *elevation;
struct xvimage *overlays, **ovband;

GC     gc, gc_xor, gc_set;
Pixel  white, black, red, green, blue,
       grey, cyan, magenta, yellow,
       plot_foreground, plot_background, plot_color;

int    update_id;
float  update_time;
int    update_file();

/* -include_additions_end */

/* -include_macros */
/* -include_macros_end */

#endif
