 /*
  * Khoros: $Id: create.c,v 1.2 1992/03/20 22:51:49 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: create.c,v 1.2 1992/03/20 22:51:49 dkhoros Exp $";
#endif

 /*
  * $Log: create.c,v $
 * Revision 1.2  1992/03/20  22:51:49  dkhoros
 * VirtualPatch5
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1990 by UNM */
#include "viewimage.h"
#include <X11/Xaw/Box.h>


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>      Creation of Custom Widget Routines		      <<<<
   >>>>                                                       <<<<
   >>>>		create_plot_display()			      <<<<
   >>>>		create_pseudo_display()			      <<<<
   >>>>		create_lut_display()			      <<<<
   >>>>		create_thres_display()			      <<<<
   >>>>		create_persp_display()			      <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */



/****************************************************************
*
* Routine Name:  create_plot_display
*
*
* Purpose:  creates the plot widget in which the image will be plotted
*	    inside the workspace that is part of the graphical user interface
*
* Input:  form   - the form that the raster display will belong
*	  parent - the workspace on which the raster widget will be created
*	  image  - pointer to the imagery VIFF image
*	  elevation - pointer to the elevation VIFF image
*	  proportional - whether the image should be initially displayed
*			 as a proportional plot.
*
* Output:  subsample - return the sub sampling factor. 
*
* Written By:  Mark Young
*
****************************************************************/

create_plot_display(form, parent, image, elevation, proportional, subsample)

xvf_form *form;
Widget parent;
struct xvimage *image, *elevation;
int    proportional;
float  *subsample;
{
	int	i, width, height;
	Arg	args[MaxArgs];


	plot = (PlotStructure *) XtCalloc(1, sizeof(PlotStructure));
	plot->parent = parent;

	if (image->row_size < 100)
	   width = image->row_size;
	else
	   width = 100;

	if (image->col_size < 100)
	   height = image->col_size;
	else
	   height = 100;

	*subsample = MAX(((float) image->col_size)/height,
			((float) image->row_size)/width);

	/*
	 *  Create the main plot workspace
	 */
	i = 0;
	set_floatarg(args, i, XtNeye,   &persp->eye_dist);      i++;
	set_floatarg(args, i, XtNalpha, &persp->alpha_val);     i++;
	set_floatarg(args, i, XtNtheta, &persp->theta_val);     i++;
	XtSetArg(args[i], XtNforeground, plot_foreground);	i++;
	XtSetArg(args[i], XtNbackground, plot_background);	i++;
	XtSetArg(args[i], XtNvisual, xvdisplay->visual);	i++;
	XtSetArg(args[i], XtNcolormap, xvdisplay->colormap);	i++;
	XtSetArg(args[i], XtNdepth, xvdisplay->depth);		i++;
	XtSetArg(args[i], XtNwidth, 512);			i++;
	XtSetArg(args[i], XtNheight, 512);			i++;
	XtSetArg(args[i], XtNlabel,   "Main Plot");		i++;
	XtSetArg(args[i], XtNproportional, proportional);	i++;
	plot->workspace = XtCreateManagedWidget("plot", plotWidgetClass,
				parent, args, i);

	i = 0;
	XtSetArg(args[i], XtNimage, image);			i++;
	XtSetArg(args[i], XtNelevation, elevation);		i++;
	XtSetArg(args[i], XtNplot,    PLOT_WIREFRAME);		i++;
	XtSetArg(args[i], XtNmarker,  MarkerDot);		i++;
	XtSetArg(args[i], XtNncolors, xvdisplay->pixelnum);	i++;
	XtSetArg(args[i], XtNcolors,  xvdisplay->xcolors);	i++;
	XtSetArg(args[i], XtNforeground, plot_color);		i++;
	XtSetArg(args[i], XtNbackground, plot_background);	i++;
	XtSetArg(args[i], XtNplotwidth,  width);			i++;
	XtSetArg(args[i], XtNplotheight, height);			i++;
	plot->plotobj = XtCreateManagedWidget("plotobj", plotObjectClass,
				plot->workspace, args, i);
}



/****************************************************************
*
* Routine Name:  create_pseudo_display 
*
*
* Purpose:  creates the psuedocoloring display on the pseudocoloring 
*	    workspace that is part of the user interface. 
*
* Input:  parent - the workspace on which the zoom widget will be created
*
* Output:  none 
*
* Written By:  Mark Young & Danielle Argiro
*
****************************************************************/

create_pseudo_display(parent)

Widget parent;
{
        int     i;
        Arg     args[15];
        Widget  create_pseudo_back(), create_color_palette();
	void	undo_cb();

	pseudo = (PseudoStructure *) malloc(sizeof(PseudoStructure));
        pseudo->pseudo = parent;

	i = 0;
	XtSetArg(args[i], XtNfromVert, NULL);                   i++;
	XtSetArg(args[i], XtNfromHoriz, NULL);			i++;
        XtSetArg(args[i], XtNheight, 30);                       i++;
        XtSetArg(args[i], XtNlabel, "UNDO");                	i++;
	pseudo->undo = XtCreateManagedWidget("Undo", commandWidgetClass,
                                              parent, args, i);
	XtAddCallback(pseudo->undo,XtNcallback, undo_cb, NULL);


	/*
	 * create two color boxes at the top of the pseudocolor display
	 */
	i = 0;
        XtSetArg(args[i], XtNwidth, 30);                        i++;
        XtSetArg(args[i], XtNheight, 30);                       i++;
        XtSetArg(args[i], XtNhSpace, 30);                       i++;
        XtSetArg(args[i], XtNvSpace, 30);                       i++;
        XtSetArg(args[i], XtNfromVert, NULL);                   i++;
        XtSetArg(args[i], XtNfromHoriz, pseudo->undo);          i++;
        XtSetArg(args[i], XtNforeground, white);                i++;
        XtSetArg(args[i], XtNbackground, white);                i++;
        XtSetArg(args[i], XtNborderColor, black);               i++;
        XtSetArg(args[i], XtNhorizDistance, 50);          	i++;
	pseudo->color1 = XtCreateManagedWidget("color1", boxWidgetClass,
                                         	parent, args, i);


        i--; XtSetArg(args[i], XtNfromHoriz, pseudo->color1);        i++;
        pseudo->color2 = XtCreateManagedWidget("color2", boxWidgetClass,
                                         	parent, args, i);

        XtSetMappedWhenManaged(pseudo->color1, FALSE);
        XtSetMappedWhenManaged(pseudo->color2, FALSE);
	pseudo->palette = create_color_palette(parent, pseudo->color1, NULL);

	/*
         *  Create the colorspace pseudo display.
         */
	pseudo->rgb_back = create_pseudo_back(parent, "R", "G", "B",
			red, green, blue, red, green, blue,
			pseudo->rgb, pseudo->palette, NULL);
	pseudo->cmy_back = create_pseudo_back(parent, "C", "M", "Y",
			cyan, magenta, yellow, cyan, magenta, yellow,
			pseudo->cmy, pseudo->palette, NULL);
	pseudo->hsv_back = create_pseudo_back(parent, "H", "S", "V",
			black, black, black, white, white, white,
			pseudo->hsv, pseudo->palette, NULL);
	pseudo->hls_back = create_pseudo_back(parent, "H", "L", "S",
			black, black, black,  white, white, white,
			pseudo->hls, pseudo->palette, NULL);
	pseudo->yiq_back = create_pseudo_back(parent, "Y", "I", "Q",
			black, black, black,  white, white, white,
			pseudo->yiq, pseudo->palette, NULL);
	pseudo->uvw_back = create_pseudo_back(parent, "U", "V", "W",
			black, black, black, white, white, white,
			pseudo->uvw, pseudo->palette, NULL);
	pseudo->xyz_back = create_pseudo_back(parent, "X", "Y", "Z",
			black, black, black, white, white, white,
			pseudo->xyz, pseudo->palette, NULL);
	pseudo->grey_back = create_pseudo_back(parent, "G", NULL, NULL,
			black, black, black,  white, white, white,
			pseudo->grey, pseudo->palette, NULL);

        pseudo->model = RGB;
	XtMapWidget(pseudo->rgb_back);
	XRaiseWindow(display, XtWindow(pseudo->rgb_back));
}


/****************************************************************
*
* Routine Name:  create_lut_display 
*
*
*      Purpose:  creates the lookup table display on the lookup table 
*	         workspace that is part of the user interface. 
*
*        Input:  parent - the workspace on which the lookup table widget 
*		 will be created
*
*       Output:  none 
*
*   Written By:  Mark Young & Danielle Argiro
*
****************************************************************/

create_lut_display(parent)

Widget parent;
{
	int       i;
        Arg      args[MaxArgs];
        unsigned long mask;
	Widget   ybeg, xbeg, yend, xend;
	Widget   create_lut_back(); 
	void	 refresh_palette(), undo_cb();

	lut = (LutStructure *) malloc(sizeof(LutStructure));
        lut->toplevel  = parent;
        lut->hist_type = Continuous;
        lut->histogram = True;

	lut_width  = 350;
        lut_height = 100;
        lut_xpos   = -1;
        lut_ypos   = -1;


	i = 0;
	XtSetArg(args[i], XtNfromVert, NULL);                   i++;
	XtSetArg(args[i], XtNfromHoriz, NULL);			i++;
        XtSetArg(args[i], XtNheight, 30);                       i++;
        XtSetArg(args[i], XtNlabel, "UNDO");                	i++;
	lut->undo = XtCreateManagedWidget("Undo", commandWidgetClass,
                                              parent, args, i);
	XtAddCallback(lut->undo,XtNcallback, undo_cb, NULL);

	/*
	 *  Create the lookup table palette.
	 */
	i = 0;
	XtSetArg(args[i], XtNforeground, black);                i++;
	XtSetArg(args[i], XtNbackground, black);                i++;
	XtSetArg(args[i], XtNborderColor, black);               i++;
	XtSetArg(args[i], XtNfromVert, NULL); 		        i++;
	XtSetArg(args[i], XtNhorizDistance, 10);		i++;
	XtSetArg(args[i], XtNfromHoriz, lut->undo);             i++;
	XtSetArg(args[i], XtNwidth, (Dimension) 350);           i++;
	XtSetArg(args[i], XtNheight, (Dimension) 30);           i++;
	lut->palette = XtCreateManagedWidget("palette", 
				formWidgetClass, parent, args, i);

	XtAddEventHandler(lut->palette, ExposureMask, False, refresh_palette,
			  NULL);
	lut->rgb_back = create_lut_back(parent, "Red", "Green", "Blue",
				red, green, blue, red, green, blue,
				lut->rgb, lut->palette, NULL);
	lut->cmy_back = create_lut_back(parent, "Cyan", "Magenta", "Yellow",
				cyan, magenta, yellow, cyan, magenta, yellow,
				lut->cmy, lut->palette, NULL);
	lut->hsv_back = create_lut_back(parent, "Hue", "Saturation", "Value",
				black, black, black, white, white, white,
				lut->hsv, lut->palette, NULL);
	lut->hls_back = create_lut_back(parent, "Hue", "Luminance","Saturation",
				black, black, black, white, white, white,
				lut->hls, lut->palette, NULL);
	lut->yiq_back = create_lut_back(parent, "Y", "I","Q",
				black, black, black, white, white, white,
				lut->yiq, lut->palette, NULL);
	lut->uvw_back = create_lut_back(parent, "U", "V","W",
				black, black, black, white, white, white,
				lut->uvw, lut->palette, NULL);
	lut->xyz_back = create_lut_back(parent, "X", "Y","Z",
				black, black, black, white, white, white,
				lut->xyz, lut->palette, NULL);
	lut->grey_back = create_lut_back(parent, "Grey", NULL, NULL,
				black, black, black, white, white, white,
				lut->grey, lut->palette, NULL);

        lut->model = RGB;
        lut->current_lut = lut->rgb;
	lut->active_canvas = NULL;
	XtMapWidget(lut->rgb_back);
	XRaiseWindow(display, XtWindow(lut->rgb_back));
}



/****************************************************************
*
* Routine Name:  create_thres_display 
*
*
*      Purpose:  creates the threshold display on the threshold
*	         workspace that is part of the user interface. 
*
*        Input:  parent - the workspace on which the threshold widget 
*		 will be created
*
*       Output:  none 
*
*   Written By:  Mark Young & Danielle Argiro
*
****************************************************************/

create_thres_display(parent)

Widget parent;
{
	int       i;
        Arg      args[MaxArgs];
        unsigned long mask;
	Widget   scroll_back, create_thres_scrollbar();
	void	 refresh_palette(), thres_reset_cb();

	thres = (ThresStructure *) malloc(sizeof(ThresStructure));
        thres->toplevel = parent;
	thres->mode   = Windowing;
	thres->accept = True;
	thres->invert = False;
	thres->fill_pixel = 0;
	thres->nonzero_pixel = 255;
	thres->lower = (ScrollStruct *) malloc(sizeof(ScrollStruct));
	thres->upper = (ScrollStruct *) malloc(sizeof(ScrollStruct));


	i = 0;
	XtSetArg(args[i], XtNfromVert, NULL);                   i++;
	XtSetArg(args[i], XtNfromHoriz, NULL);			i++;
        XtSetArg(args[i], XtNheight, 30);                       i++;
        XtSetArg(args[i], XtNlabel, "RESET");                	i++;
        XtSetArg(args[i], XtNhorizDistance, 10);                	i++;
	thres->reset = XtCreateManagedWidget("RESET", commandWidgetClass,
                                              parent, args, i);
	XtAddCallback(thres->reset,XtNcallback, thres_reset_cb, NULL);

	/*
	 *  Create the threshold palette.
	 */
	i = 0;
	XtSetArg(args[i], XtNforeground, black);                i++;
	XtSetArg(args[i], XtNbackground, white);                i++;
	XtSetArg(args[i], XtNborderColor, black);               i++;
	XtSetArg(args[i], XtNfromVert, NULL);                   i++;
	XtSetArg(args[i], XtNfromHoriz, thres->reset);            i++;
	XtSetArg(args[i], XtNwidth, (Dimension) 256);           i++;
	XtSetArg(args[i], XtNheight, (Dimension) 30);           i++;
	thres->palette = XtCreateManagedWidget("palette", 
				formWidgetClass, parent, args, i);

	XtAddEventHandler(thres->palette, ExposureMask, False,
			refresh_palette, NULL);


	/*
  	 *  Create the lower scroll bar
	 */
	thres->lower->num = 0;

	scroll_back = create_thres_scrollbar(thres, thres->lower, "lower",
			black, red, parent, thres->palette, NULL);
	update_int_scroll(thres->lower, thres->lower->num, 255);
	 
	/*
  	 *  Create the upper scroll bar
	 */
	thres->upper->num = 255;

	scroll_back = create_thres_scrollbar(thres, thres->upper, "upper", red,
			black, parent, scroll_back, NULL);
	update_int_scroll(thres->upper, thres->upper->num, 255);
}



/****************************************************************
*
* Routine Name:  create_persp_display 
*
*
*      Purpose:  creates the perspective display on the persp
*	         workspace that is part of the user interface. 
*
*        Input:  parent - the workspace on which the perspective widget 
*		 will be created
*
*       Output:  none 
*
*   Written By:  Mark Young
*
****************************************************************/

create_persp_display(parent)

Widget parent;
{
	int       i;
        Arg      args[MaxArgs];
        unsigned long mask;
	Widget   scroll_back, create_persp_scrollbar();


	persp = (PerspStructure *) malloc(sizeof(PerspStructure));
        persp->toplevel = parent;
	persp->eye   = (ScrollStruct *) malloc(sizeof(ScrollStruct));
	persp->alpha = (ScrollStruct *) malloc(sizeof(ScrollStruct));
	persp->theta = (ScrollStruct *) malloc(sizeof(ScrollStruct));


	/*
	 *  Initialize the perspective defaults
	 */
	persp->eye_dist  = EyeDist;
	persp->alpha_val = Alpha;
	persp->theta_val = Theta;

	/*
  	 *  Create the eye scroll bar
	 */
	persp->eye->num = 0;
	scroll_back = create_persp_scrollbar(persp, persp->eye, "eye  ",
			black, red, parent, NULL, NULL);
	update_float_scroll(persp->eye, persp->eye_dist, 1000.0);

	/*
  	 *  Create the alpha scroll bar
	 */
	persp->alpha->num = 0;
	scroll_back = create_persp_scrollbar(persp, persp->alpha, "alpha",
			black, red, parent, scroll_back, NULL);
	update_float_scroll(persp->alpha, persp->alpha_val, 360.0);

	/*
  	 *  Create the alpha scroll bar
	 */
	persp->theta->num = 0;
	scroll_back = create_persp_scrollbar(persp, persp->theta, "theta",
			black, red, parent, scroll_back, NULL);
	update_float_scroll(persp->theta, persp->theta_val, 360.0);
}


void undo_cb(widget, clientData, callData)
Widget widget;
caddr_t clientData, callData;
{
	int index, num;


	if (!pop_cstack(xvdisplay->xcolors, &index1, &index2))
	   return;

	index = MIN(index1, index2);
	num = abs(index2 - index1) +1;
	store_colors(xvdisplay->xcolors, index, num);
}
