 /*
  * Khoros: $Id: lreader.c,v 1.2 1991/10/02 00:11:26 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lreader.c,v 1.2 1991/10/02 00:11:26 khoros Exp $";
#endif

 /*
  * $Log: lreader.c,v $
 * Revision 1.2  1991/10/02  00:11:26  khoros
 * HellPatch2
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lreader.c
 >>>>
 >>>>      Program Name: reader
 >>>>
 >>>> Date Last Updated: Tue Apr  2 15:50:06 1991 
 >>>>
 >>>>          Routines: lreader - the library call for reader
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "xvinclude.h"


/* -library_includes */
#include "reader.h"
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lreader - library call for reader
*
* Purpose:
*    
*         lreader() is the driver for  ghostreader.   First,  it  gets
*    pathname  information  about  input  files from the configuration
*    file, if one is specified.  It reads in the old *.prog  file  (if
*    reader->prog  is True), so that textblocks that may not appear in
*    the input files will not be blanked out.   It  then  calls  other
*    routines  to  get  textblocks  from  each of the input files, and
*    finally, writes out the new *.prog file.
*    
*    
* Input:
*    
*    none
*    
*    
* Output:
*    
*    none
*    
*    
*
* Written By: Danielle Argiro
*    
*    
****************************************************************/


/* -library_def */
int lreader()
/* -library_def_end */

/* -library_code */
{
        int  i, man3_ok, lib_ok, others_ok;
        FILE *ps_file;
        int  cstat, hstat, lstat, man1stat, man3stat;
        char **prog_spec = NULL, *fullpath, filename[MaxLength];
        char **keynames[2];
        char *config_keys[ConfigKeyNum], *config_paths[ConfigKeyNum];
        char *global_src_dir;
        char  temp[MaxLength];

       /*
        *  initialize key names for .prog file 
        */
        gw_init_keynames(keynames);


       /*
        *   Read configuration file info into path strings for later use.
        */
        if (reader->config)
        {
           sprintf(temp, "%s.conf", reader->name);
           gw_init_config_keys(config_keys);
           if (!(gr_read_configfile(temp, config_keys, 
                                    ConfigKeyNum, config_paths)))
                return(false);
           if(!(gw_check_config_paths(2,config_paths,reader->lib,reader->man3)))
               return(false);
        }
        else
        {
           for (i = 0; i < ConfigKeyNum; i++)
                config_paths[i] = xvf_strcpy("./");
        }

        if (config_paths[TOPSRC] == NULL)
           global_src_dir = NULL;
        else if (strcmp(config_paths[TOPSRC], "./") == 0)
           global_src_dir = NULL;
        else
           global_src_dir = xvf_strcpy(config_paths[TOPSRC]);

       /*
        *   Get information for code generation from .prog file (if specified).
        *   Read program specification description into internal prog_spec
        *   structure for use.
        */
        if (reader->prog)
        {
           if (strcmp(config_paths[PROGPATH], "./") != 0)
               sprintf(filename, "%s/%s.prog", 
                       config_paths[PROGPATH],reader->name);
           else
               sprintf(filename, "%s.prog", reader->name);
           fullpath = vfullpath(filename, global_src_dir, NULL);

           ps_file = fopen(fullpath, "r");
           if (ps_file == NULL)
           {
              fprintf(stderr, "ghostreader:\n");
              fprintf(stderr, "Unable to open '%s' to read .prog file",
                               fullpath);
              return(false);
           }
           prog_spec = gw_read_progfile(ps_file, keynames);
           if (prog_spec == NULL)
           {
              fclose(ps_file);
              return(false);
           }
        }
        else
        {
           prog_spec = (caddr_t *) calloc(1,sizeof(char *)*MaxProgSpecSize);
           for (i = 0; i < MaxProgSpecSize; i++)
               prog_spec[i] = NULL;
        }

       /*
        *  append name of each file to each path specified in the config
        *  file, and get each appropriate piece of info from file
        */
        
        sprintf(filename, "%s/%s.c", config_paths[CPATH], reader->name); 
        fullpath = vfullpath(filename, global_src_dir, NULL);
        cstat = gr_get_cfile_info(fullpath, prog_spec);

        sprintf(filename, "%s/%s.h", config_paths[HPATH], reader->name); 
        fullpath = vfullpath(filename, global_src_dir, NULL);
        hstat = gr_get_hfile_info(fullpath, prog_spec);

        sprintf(filename, "%s/%s.1", config_paths[MAN1PATH], reader->name); 
        man1stat = gr_get_man1file_info(filename, prog_spec, 
                                        reader->name, reader->format);
        lib_ok = true;
        if (reader->lib)
        {
           sprintf(filename, "%s/l%s.c", config_paths[LPATH], reader->name); 
           fullpath = vfullpath(filename, global_src_dir, NULL);
           lstat = gr_get_lfile_info(fullpath, prog_spec);
           lib_ok = lstat;
        }

        man3_ok = true;
        if (reader->man3)
        {
           sprintf(filename, "%s/l%s.3", config_paths[MAN3PATH], reader->name); 
           man3stat = gr_get_man3file_info(filename, prog_spec, 
                      reader->name, reader->format);
           man3_ok = lstat;
        }

        if (reader->install)
        {
           if (strcmp(config_paths[PROGPATH], "./") != 0)
               sprintf(filename, "%s/%s.prog", 
                       config_paths[PROGPATH],reader->name);
           else
               sprintf(filename, "%s.prog", reader->name);
           fullpath = vfullpath(filename, global_src_dir, NULL);
        }
        else
        {
            sprintf(filename,"%s.prog", reader->name);
            fullpath = vfullpath(filename, NULL, NULL);
        }

        others_ok = cstat && hstat && man1stat;
         
        if (lib_ok && man3_ok && others_ok)
        {
             if (gr_write_progfile(fullpath, prog_spec,
                                   keynames, reader->force))
                fprintf(stderr, "\nghostreader:  done generating '%s'\n", 
                        filename);
        }
        
        return(true);
}
/* -library_code_end */
