 /*
  * Khoros: $Id: run_options.c,v 1.1 1991/05/10 15:57:41 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: run_options.c,v 1.1 1991/05/10 15:57:41 khoros Exp $";
#endif

 /*
  * $Log: run_options.c,v $
 * Revision 1.1  1991/05/10  15:57:41  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1990 by UNM */
#include "animate.h"


/********************************************************
*
*  Routine Name:  run_animate_options
*
*       Purpose:  drives the subform 'animate_options'
*
*         Input:  form - pointer to the form tree 
*		  animate_options_info  - information structure for subform 'animate_options'
*        Output:  action of the application program
*
*     Called By:  run_animate_form()
*
*   Automatically Generated By:  conductor -i animate.form -l 3 -b
*
********************************************************/


run_animate_options(form, animate_options_info)

xvf_form *form;
animate_form_options_subform *animate_options_info;
{

	_xvf_get_options_subform(form, animate_options_info);

	/*
	 * action came from the 'options' pane
	 */
	if (animate_options_info->options_selected)
	    run_options(form, animate_options_info->options);


}   /* end run_animate_options */





/********************************************************
*
*  Routine Name:  run_options
*
*       Purpose:  drives the pane 'options'
*
*         Input:  form - pointer to the form tree 
*		  options_info  - information structure for pane 'options'
*        Output:  action of the application program
*
*     Called By:  run_animate_options()
*
*   Automatically Generated By:  conductor -i animate.form -l 3 -b
*
********************************************************/


run_options(form, options_info)

xvf_form *form;
options_subform_options *options_info;
{

	_xvf_get_options(form, options_info);

	/*
	 * user clicked on 'live' toggle selection 'control'
	 */
	if (options_info->control_selected)
	{
	    xvanimate->control = options_info->control_val;
	}

	/*
	 * user clicked on 'live' logical selection 'show_band'
	 */
	if (options_info->show_band_selected)
	{
	    xvanimate->show_band = options_info->show_band;
	    update_animate_mode();
	}

	/*
	 * user clicked on 'live' logical selection 'use_root'
	 */
	if (options_info->use_root_selected)
	{
	    if (xvanimate->use_root == True && options_info->use_root == False)
	       refresh_rootwindow();

	    xvanimate->use_root = options_info->use_root;
	}

	/*
	 * user clicked on 'live' float selection 'speed'
	 */
	else if (options_info->speed_selected)
	{
	    xvanimate->speed = options_info->speed;
	}
}
