 /*
  * Khoros: $Id: text.c,v 1.2 1991/12/18 09:17:11 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: text.c,v 1.2 1991/12/18 09:17:11 dkhoros Exp $";
#endif

 /*
  * $Log: text.c,v $
 * Revision 1.2  1991/12/18  09:17:11  dkhoros
 * HellPatch3
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "xvutils.h"	


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    	    file name: text.c                         <<<<
   >>>>                                                       <<<<
   >>>>         Creates a Text Widget			      <<<<
   >>>>                                                       <<<<
   >>>>                xvf_text_wait()			      <<<<              
   >>>>                xvf_create_text_widget()		      <<<<              
   >>>>                xvf_use_text_cb()		      <<<<              
   >>>>                xvf_cancel_text_cb()		      <<<<              
   >>>>                xvf_unglyph_text()		      <<<<              
   >>>>                xvf_glyph_text()		  	      <<<<              
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

void xvf_use_text_cb();
void xvf_cancel_text_cb();
void xvf_glyph_text();
void xvf_unglyph_text();

/*******************************************************************
*
*  Routine Name:  char *xvf_text_wait()
*
*      Purpose:   This routine is called directly by the user application.
*		  It takes a string, and displays that string in a text
*		  widget.  The text widget is popped up, and the user edits
*		  the string as desired.  This string is then returned 
*		  to the application program.  NOTE: this routine will grab 
*		  all events while running.
*
*        Input:   default_text - the text to be initially displayed (in the
*			 	 form of one long string - \n's are permitted,
*				 but not necessary, as the text widget will
*				 place carriage returns where needed.
*
*		  prompt - a prompt indicating expected action by the user 
*		  label  - label for the text widget
*
*
*
*	 Output:  returns the edited string
*
*    Called By:   the application program
*
*******************************************************************/

char *xvf_text_wait(default_text, label, prompt)
char *default_text, *label, *prompt;
{
      char *string_return;
      char *new_text;
      DisplayWid_Data *display_data, *xvf_create_text_widget();
      int  i;
      Arg arg[MaxArgs];

      TEXT_DONE = false;
      USE_TEXT  = false;

      display_data = xvf_create_text_widget(default_text, label, prompt);
     
      while (!TEXT_DONE)
      {
	   /* this does XtNextEvent/DispatchEvent*/
           xvf_process_event();
      }


      if (USE_TEXT)
      {
        i = 0;
        XtSetArg(arg[i], XtNstring, &string_return);    i++;
        XtGetValues(display_data->text, arg, i);
	new_text = xvf_strcpy(string_return);
      }
      else 
	 new_text = xvf_strcpy(default_text);
       
   
     /*
      * delete the text box's toplevel & glyph from the list 
      * used by journal playback before destroying them, and
      * other associated widgets. Set all pointers to NULL.
      */
      xvf_delete_toplevel(display_data->toplevel);
      xvf_delete_toplevel(display_data->glyph);

      XtDestroyWidget(display_data->label);
      XtDestroyWidget(display_data->text);
      XtDestroyWidget(display_data->back);
      XtDestroyWidget(display_data->toplevel);
      XtDestroyWidget(display_data->glyph);

      display_data->label    = NULL;
      display_data->text     = NULL;
      display_data->back     = NULL;
      display_data->toplevel = NULL;
      display_data->glyph    = NULL;

       

      return(new_text);
}



/************************************************************
*
*  Routine Name:  xvf_create_text_widget()
*
*      Purpose:   Create a large read-write text widget in which a predefined
*		  segment of text is displayed, so that the user
*		  may add or modify text, until the user clicks on "ok".
*		  Will not grab events from the application program.
*		  Can have the contents of the text widget updated 
*		  with xvf_update_text_widget(), or the text may be extracted
*		  using xvf_get_text_widget().
*
*        Input:   text_string  - character string containing the text to
*				 be initially displayed in text widget
*
*		  text_prompt  - prompt for user
*                 text_label   - short label for top of widget.
*			         NULL gives default of "Edit Text".
*
*       Output:   Returns a pointer to DisplayWid_Data
*
*    Called By:   the application program
*
*   Written By:   Danielle Argiro
*
*************************************************************/

#define TEXT_WIDTH  80
#define TEXT_HEIGHT 40

DisplayWid_Data *xvf_create_text_widget(text_string, text_label, text_prompt)
char *text_string;
char *text_label;
char *text_prompt;
{
   DisplayWid_Data *display_data;	/* data return structure */
   Widget use;	  			/* use button */
   Widget cancel;	  		/* cancel button */
   Widget glyph_button;  		/* glyph widget on text widget */
   Widget glyph_to_form; 		/* command widget of glyph */
   Widget prompt_widget;		/* prompt widget */
   char   *top_name, *cap_top_name;
   char   name[MaxLength], glyph_name[MaxLength];
   Arg    arg[25];
   int    i, label_width;
   

   display_data = (DisplayWid_Data *) calloc(1, sizeof(DisplayWid_Data));

   if (text_label == NULL)
   {
	text_label = xvf_strcpy("Edit Text");
   }

   /*
    * create identifying widget name
    */
   sprintf(name,"%d_Text",Text_cnt);
   sprintf(glyph_name,"%d_text_glyph",Text_cnt); Text_cnt++;
   top_name = xvf_strcpy(glyph_name);
   cap_top_name = xvf_cap_first_letter(top_name);

   /* 
    * create the text box's glyph, and add it to the 
    * list of toplevels that is used with journal playback.
    */
   i = 0;
   XtSetArg(arg[i], XtNscreen, xvf_screen); 		i++;
   XtSetArg(arg[i], XtNargc, xvf_ac); 	         	i++;
   XtSetArg(arg[i], XtNargv, xvf_av);	          	i++;
   XtSetArg(arg[i], XtNwinGravity, StaticGravity);	i++; 
   XtSetArg(arg[i], XtNmappedWhenManaged,False);        i++;
   display_data->glyph = XtAppCreateShell(top_name,cap_top_name,
 			 applicationShellWidgetClass, xvf_display, arg, i);
   xvf_add_toplevel(display_data->glyph);


   i = 0;
   XtSetArg(arg[i],XtNwidth,10*xvf_font_width);		i++;
   XtSetArg(arg[i],XtNheight, (Dimension) 2*xvf_font_height);	i++;
   XtSetArg(arg[i],XtNlabel, "text glyph");		i++;
   XtSetArg(arg[i],XtNmappedWhenManaged,True);     	i++;
   glyph_to_form = XtCreateManagedWidget("glyph_to_form",
	commandWidgetClass,display_data->glyph,arg,i);
   XtAddCallback(glyph_to_form,XtNcallback,xvf_unglyph_text,display_data);

   top_name = xvf_strcpy(name);
   cap_top_name = xvf_cap_first_letter(top_name);

   /* 
    * create the text widget's toplevel widget, and add it to the
    * list of toplevels that is used with journal playback.
    */
   i = 0;
   XtSetArg(arg[i], XtNscreen, xvf_screen); 		i++;
   XtSetArg(arg[i], XtNargc, xvf_ac); 	         	i++;
   XtSetArg(arg[i], XtNargv, xvf_av);	          	i++;
   XtSetArg(arg[i], XtNwinGravity, StaticGravity);	i++; 
   display_data->toplevel = XtAppCreateShell(top_name,cap_top_name,
	                     applicationShellWidgetClass, xvf_display, arg, i);
   xvf_add_toplevel(display_data->toplevel);

   /* 
    * create the backplane widget 
    */
   i = 0;
   XtSetArg(arg[i],XtNmappedWhenManaged,True);          i++;
   XtSetArg(arg[i],XtNborderWidth,1);			i++;
   XtSetArg(arg[i],XtNdefaultDistance,4);		i++;
   display_data->back = XtCreateManagedWidget("form_back",
		                formWidgetClass, display_data->toplevel,arg,i);  

   /* 
    * create the glyph button widget 
    */
   i = 0;
   XtSetArg(arg[i],XtNlabel,xvf_strcpy("glyph"));		i++;
   XtSetArg(arg[i],XtNwidth,(Dimension) 6*xvf_font_width);	i++;
   XtSetArg(arg[i],XtNmappedWhenManaged,True);			i++;
   if (xvf_font != NULL)
   {
       XtSetArg(arg[i],XtNfont,xvf_font);               	i++;
   }
   glyph_button = XtCreateManagedWidget("glyph",
      	commandWidgetClass,display_data->back,arg,i);
   XtAddCallback(glyph_button,XtNcallback,xvf_glyph_text,display_data);

   /* 
    * create the label widget 
    */
   i = 0;
   label_width = TEXT_WIDTH*xvf_font_width - 19*xvf_font_width;
   XtSetArg(arg[i],XtNlabel,xvf_strcpy(text_label)); 	i++;
   XtSetArg(arg[i],XtNwidth,(Dimension) label_width);	i++;
   XtSetArg(arg[i],XtNmappedWhenManaged,True);		i++;
   XtSetArg(arg[i],XtNfromVert, NULL);			i++;
   XtSetArg(arg[i],XtNfromHoriz,glyph_button);		i++;
   if (xvf_font != NULL)
   {
       XtSetArg(arg[i],XtNfont,xvf_font);               i++;
   }
   display_data->label = XtCreateManagedWidget("text_wid",
                labelWidgetClass,display_data->back,arg,i);

   /*
    * create prompt widget
    */
    i = 0;
    if (xvf_font != NULL)
    {
         XtSetArg(arg[i],XtNfont,xvf_font);             i++;
    }
    XtSetArg(arg[i],XtNlabel,xvf_strcpy(text_prompt));  i++;
    XtSetArg(arg[i],XtNfromHoriz,NULL);                 i++;
    XtSetArg(arg[i],XtNfromVert,display_data->label);   i++;
    XtSetArg(arg[i],XtNmappedWhenManaged,True);         i++;
    XtSetArg(arg[i],XtNborderWidth, 0);                 i++;
    XtSetArg(arg[i],XtNwidth ,(Dimension) 
		TEXT_WIDTH*xvf_font_width);		i++;
    if (xvf_font != NULL)
    {
       XtSetArg(arg[i],XtNfont,xvf_font);               i++;
    }
    prompt_widget = XtCreateManagedWidget("prompt", labelWidgetClass,
                                           display_data->back,arg,i);




   /* 
    * create text widget 
    */
   i = 0;
   if (text_string != NULL)
   {
      XtSetArg(arg[i],XtNstring,  text_string);		i++;
   }
   else
   {
      XtSetArg(arg[i],XtNstring,  " ");			i++;
   }
   XtSetArg(arg[i],XtNeditType,XawtextEdit);		i++;
   XtSetArg(arg[i],XtNtype,    XawAsciiString);		i++;
   XtSetArg(arg[i],XtNscrollVertical,  
		XawtextScrollWhenNeeded);		i++;
   XtSetArg(arg[i],XtNwrap,    XawtextWrapWord);	i++;
   XtSetArg(arg[i],XtNheight,(Dimension) 
		TEXT_HEIGHT*xvf_font_height);		i++;
   XtSetArg(arg[i],XtNwidth ,(Dimension) 
		TEXT_WIDTH*xvf_font_width);		i++;
   XtSetArg(arg[i],XtNleftMargin,LEFT_MARGIN);		i++;
   XtSetArg(arg[i],XtNfromVert, prompt_widget );	i++;
   if (xvf_font != NULL)
   {
       XtSetArg(arg[i],XtNfont,xvf_font);               i++;
   }
   display_data->text=  XtCreateManagedWidget("text",
		asciiTextWidgetClass, display_data->back,arg,i); 

   /* 
    * create the use button 
    */
   i = 0;
   XtSetArg(arg[i],XtNfromVert,NULL);			i++;
   XtSetArg(arg[i],XtNfromHoriz,display_data->label);	i++;
   XtSetArg(arg[i],XtNlabel,"Use");			i++;
   XtSetArg(arg[i],XtNwidth,5*xvf_font_width);		i++;
   if (xvf_font != NULL)
   {
       XtSetArg(arg[i],XtNfont,xvf_font);               i++;
   }
   use = XtCreateManagedWidget("use_wid",
	commandWidgetClass,display_data->back,arg,i);
   XtAddCallback(use,XtNcallback,xvf_use_text_cb,display_data);

   /* 
    * create the cancel button 
    */
   i = 0;
   XtSetArg(arg[i],XtNfromVert,NULL);			i++;
   XtSetArg(arg[i],XtNfromHoriz,use);			i++;
   XtSetArg(arg[i],XtNlabel,"Cancel");			i++;
   XtSetArg(arg[i],XtNwidth,8*xvf_font_width);		i++;
   if (xvf_font != NULL)
   {
       XtSetArg(arg[i],XtNfont,xvf_font);               i++;
   }
   cancel = XtCreateManagedWidget("cancel_wid",
	commandWidgetClass,display_data->back,arg,i);
   XtAddCallback(cancel,XtNcallback,xvf_cancel_text_cb,display_data);

   XtRealizeWidget(display_data->toplevel);
   XtRealizeWidget(display_data->glyph);

   xvf_add_protocol_handler(display_data->toplevel, "WM_DELETE_WINDOW", 
			    xvf_cancel_text_cb, display_data);
   XFlush(XtDisplay(display_data->toplevel));
   return(display_data);
}


/* callback used to use text in text widget */

void xvf_use_text_cb(widget, clientData, callData)
Widget widget;
caddr_t clientData, callData;
{
   TEXT_DONE = true;
   USE_TEXT = true;
}

/* callback used to cancel text */
void xvf_cancel_text_cb(widget, clientData, callData)

Widget widget;
caddr_t clientData, callData;
{
   DisplayWid_Data *display_data;
   display_data = (DisplayWid_Data *) clientData;

   xvf_remove_protocol_handler(display_data->toplevel, "WM_DELETE_WINDOW", 
			       xvf_cancel_text_cb, display_data->toplevel);
   TEXT_DONE = true;
   USE_TEXT = false;
}


void xvf_unglyph_text(widget, clientData, callData)
Widget widget;
caddr_t clientData, callData;
{
   DisplayWid_Data *display_data;

   display_data = (DisplayWid_Data *) clientData;

   XtUnmapWidget(display_data->glyph);
   XtMapWidget(display_data->toplevel);
   XSync(xvf_display,0);
}


void xvf_glyph_text(widget, clientData, callData)
Widget widget;
caddr_t clientData, callData;
{
   DisplayWid_Data *display_data;

   display_data = (DisplayWid_Data *) clientData;

   XtUnmapWidget(display_data->toplevel);
   XtMapWidget(display_data->glyph);
   XSync(xvf_display,0);
}
