 /*
  * Khoros: $Id: stats.h,v 1.2 1991/10/02 00:13:56 khoros Exp $
  */

 /*
  * $Log: stats.h,v $
 * Revision 1.2  1991/10/02  00:13:56  khoros
 * HellPatch2
 *
  */ 


/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "xprism.h"	

#ifndef _stats_h_
#define _stats_h_

/****************************************************************
 *								*
 *	This structure defines general information 		*
 *	about a plot to be displayed to the user		*
 *								*
 ***************************************************************/

struct plotstats
{
	Coord mean;	/* X, Y, Z means */
	Coord rms;	/* X, Y, Z root mean square */
	Coord std_dev;	/* X, Y, Z standard deviation */
	Coord var;	/* X, Y, Z variance */
	Coord min;	/* X, Y, Z min points */
	Coord max;	/* X, Y, Z max points */
	Coord pos_pts;  /* number of X, Y, and Z positive points */
	Coord neg_pts;  /* number of X, Y, and Z negative points */
	float area;	/* area under the surface */
	float pos_area;	/* positive area under the surface */
	float neg_area;	/* negative area under the surface */
	int pt_num;     /* number of points in the plot */
	int row_size;     /* number of columns in the plot */

	int   input_type; /* where plot originated */
	char  *xrange;	  /* if originated as a function, X domain */
	char  *yrange;    /* if originated as a function, Y range */
	char  *function;  /* if originated as a function, function string */
	char  *filename;  /* if originated as a function, the file input */
	char  *color;	  /* color plot is currently displayed in */
	int   plotnum;    /* id number of the plot */
};

#endif /* _stats_h_ */
/* Do not add after endif */
