 /*
  * Khoros: $Id: diagram.c,v 1.1 1991/05/10 15:57:18 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: diagram.c,v 1.1 1991/05/10 15:57:18 khoros Exp $";
#endif

 /*
  * $Log: diagram.c,v $
 * Revision 1.1  1991/05/10  15:57:18  khoros
 * Initial revision
 *
  */ 


/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.

 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "xprism.h"	


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    file name:  diagram.c
   >>>>                    
   >>>>   description: axes and legend drawing utilities
   >>>>                   
   >>>>      routines: 
   >>>>			initialize_axes_diagram
   >>>>			draw_axes_diagram
   >>>>			draw_axes_legend
   >>>>			draw_legend_value
   >>>>              
   >>>> modifications:
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


/************************************************************
*
*  MODULE NAME: initialize_axes_diagram
*
*      PURPOSE: For efficiency, this routine initializes the
*		three arrow Coord arrays
*		that describe (in world coordinates) the 
*		axes diagram of the plot(s) that are
*		currently in the gwin.
*
*        INPUT: arrowx - describes the X Axis arrow
*		arrowy - describes the Y Axis arrow
*		arrowz - describes the Z Axis arrow
*
*    CALLED BY: Change_Viewing_System_Interactively
*
*   WRITTEN BY: Danielle Argiro
*
*************************************************************/


init_axes_diag(arrow_x, arrow_y, arrow_z)

Coord arrow_x[];
Coord arrow_y[];
Coord arrow_z[];
{
	arrow_x[0].x = arrow_y[0].x = arrow_z[0].x = 0.0;
	arrow_x[0].y = arrow_y[0].y = arrow_z[0].y = 0.0;
	arrow_x[0].z = arrow_y[0].z = arrow_z[0].z = 0.0;

	arrow_x[1].x = arrow_x[3].x = arrow_x[5].x = 1.0;
	arrow_x[1].y = arrow_x[3].y = arrow_x[5].y = 0.0;
	arrow_x[1].z = arrow_x[3].z = arrow_x[5].z = 0.0;

	arrow_y[1].x = arrow_y[3].x = arrow_y[5].x = 0.0;
	arrow_y[1].y = arrow_y[3].y = arrow_y[5].y = 1.0;
	arrow_y[1].z = arrow_y[3].z = arrow_y[5].z = 0.0;

	arrow_z[1].x = arrow_z[3].x = arrow_z[5].x = 0.0;
	arrow_z[1].y = arrow_z[3].y = arrow_z[5].y = 0.0;
	arrow_z[1].z = arrow_z[3].z = arrow_z[5].z = 1.0;

	arrow_x[2].x = arrow_x[4].x = 0.9; 
	arrow_x[2].y = arrow_x[4].y = 0.0;
	arrow_x[2].z = 0.1; arrow_x[4].z = -0.1;

	arrow_y[2].y = arrow_y[4].y = 0.9;
	arrow_y[2].z = arrow_y[4].z = 0.0; 
	arrow_y[2].x = 0.1; arrow_y[4].x = -0.1; 

	arrow_z[2].z = arrow_z[4].z = 0.9;
	arrow_z[2].y = arrow_z[4].y = 0.0;
	arrow_z[2].x = 0.1; arrow_z[4].x = -0.1; 
}


/************************************************************
*
*  MODULE NAME: draw_axes_diagram
*
*      PURPOSE: Draws the axes diagram for manipulation with
*		the interactive changing of the viewing system.
*		The axes diagram is drawn and re-drawn according
*		to changes in the eye distance, view distance,
*		alpha and theta.  The reason the axes diagram is
*		used is that if we attempted to draw and re-draw
*		the entire plot with every change in a viewing parameter,
*		the entire process would be far too slow to be
*		satisfying to the user.  This way, only a limited
*		number of lines are drawn.
*
*
*       INPUT:  id   - id of the current gwin 
*		window - workspace of the current gwin 
*	        arrowx - array of Coords describing X Axis arrow
*	        arrowy - array of Coords describing X Axis arrow
*	        arrowz - array of Coords describing X Axis arrow
*		(arrowx, arrowy, arrowz set with init_bounding_box)
*
*       OUTPUT: the axes diagram is drawn in the workspace
*
*    CALLED BY: Change_Viewing_System_Interactively
*
*   WRITTEN BY: Danielle Argiro
*
*
*************************************************************/


draw_axes_diag(id, arrow_x, arrow_y, arrow_z)
int id;
Coord arrow_x[], arrow_y[], arrow_z[];
{
    XSync(display, 0);

    X3D_draw_polyline (id, arrow_x, 6, &Colors[1]);
    X3D_draw_polyline (id, arrow_y, 6, &Colors[2]);
    X3D_draw_polyline (id, arrow_z, 6, &Colors[3]);

    XFlush(display);
}



/************************************************************
*
*  MODULE NAME: draw_axes_legend
*
*      PURPOSE: Draws the legend of axes diagram for manipulation with
*		the interactive changing of the viewing system.
*		The legend is updated according
*		to changes in the eye distance, view distance,
*		alpha and theta.  
*
*       INPUT:  id   - id of the current gwin 
*		window - workspace of the current gwin 
*
*       OUTPUT: the legend is drawn under the axes diagram 
*		at the bottom of the workspace
*
*    CALLED BY: Change_Viewing_System_Interactively
*
*   WRITTEN BY: Danielle Argiro
*
*
*************************************************************/

draw_axes_legend(window, eye_dist, view_dist, alpha, theta)
Window window;
float eye_dist, view_dist, alpha, theta;

{  
    unsigned int width, height, border_width, depth;
    int x, y;
    unsigned long fg;
    Window rootwin;
    char *string1 = "camera distance: ",
         *string2 = "viewport distance: ",
         *string3 = "alpha: ",
         *string4 = "theta: ";

    XSync(display, 0);
    
    XGetGeometry(display, window, &rootwin, &x, &y, 
                 &width, &height,  &border_width, &depth);

    fg = WhitePixel(display, DefaultScreen(display));
    XSetForeground(display, gc_draw, fg);

    XDrawString(display, window, gc_draw, 20, height - 40, 
		string1, VStrlen(string1));
    draw_legend_value(window, 1, eye_dist);

    XDrawString(display, window, gc_draw, 20, height - 20, 
		string2, VStrlen(string2));
    draw_legend_value(window, 2, view_dist);

    XDrawString(display, window, gc_draw, 250, height - 40, 
		string3, VStrlen(string3));
    draw_legend_value(window, 3, alpha);

    XDrawString(display, window, gc_draw, 250, height - 20, 
		string4, VStrlen(string4));
    draw_legend_value(window, 4, theta);

    XFlush(display);

}
	
/************************************************************
*
*  MODULE NAME: draw_legend_value
*
*      PURPOSE: Puts in a value for "camera distance", "viewport
*		distance", "alpha", or "theta" on
*		the legend of axes diagram 
*
*       INPUT:  window - workspace of the current gwin 
*		legend_key - which value is to be filled in
*		value - the value to be filled in
*
*       OUTPUT: the value of the parameter is filled in
*		in the appropriate place at the bottom of the workspace
*
*    CALLED BY: Change_Viewing_System_Interactively
*
*   WRITTEN BY: Danielle Argiro
*
*
*************************************************************/

#define camera_val 1
#define view_val   2 
#define alpha_val  3
#define theta_val  4

draw_legend_value(window, legend_key, value)
Window window;
int legend_key; 
float value;
{  
    unsigned int width, height, border_width, depth;
    int x, y;
    Window rootwin;
    char number[25];

    XSync(display, 0);
    
    XGetGeometry(display, window, &rootwin, &x, &y, 
                 &width, &height,  &border_width, &depth);

    (void) sprintf(number, "%g", value);

    switch (legend_key) {

	case camera_val:
             XDrawString(display, window, gc_draw, 200, height - 40, 
		         number, VStrlen(number));
	     break;

	case view_val:
             XDrawString(display, window, gc_draw, 200, height - 20, 
		         number, VStrlen(number));
	     break;

	case alpha_val:
    	     XDrawString(display, window, gc_draw, 320, height - 40, 
		         number, VStrlen(number));
	     break;

	case theta_val:
    	     XDrawString(display, window, gc_draw, 320, height - 20, 
		         number, VStrlen(number));
	     break;

	} /* end switch */

}  /* end draw_legend_value */
