 /*
  * Khoros: $Id: window_3D.c,v 1.1 1991/05/10 15:56:56 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: window_3D.c,v 1.1 1991/05/10 15:56:56 khoros Exp $";
#endif

 /*
  * $Log: window_3D.c,v $
 * Revision 1.1  1991/05/10  15:56:56  khoros
 * Initial revision
 *
  */ 


/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "X3D.h"


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    	    file name: window_3D.c                    <<<<
   >>>>                                                       <<<<
   >>>>               3D Window Utilities		      <<<<
   >>>>                                                       <<<<
   >>>>                X3D_clear_area()			      <<<<              
   >>>>                X3D_clear_window()		      <<<<              
   >>>>                X3D_raise_window()		      <<<<              
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */



/************************************************************
*
*  MODULE NAME: X3D_clear_area
*
*      PURPOSE: Clears a window that is used for 3D graphical operations
*
*        INPUT: id - xvgraphics id
*		wc_min - Coord containing minimum X, Y, and Z world coordinates
*		         of the rectangle to be cleared
*		wc_max - Coord containing maximum X, Y, and Z world coordinates
*		         of the rectangle to be cleared
*       OUTPUT: clears the area specified
*
*    CALLED BY: application program
*
*   WRITTEN BY: Mark Young
*
*************************************************************/


X3D_clear_area(id, wc_min, wc_max)

int     id;
Coord   wc_min, wc_max;
{
        X3DGraphics     *graphics;
        int             x, y;
        unsigned int    width, height;
        Real            xmin, xmax, ymin, ymax;


        if (!(graphics = _X3D_get_graphics(id)))
        {
           fprintf (stderr,"X3D_clear_area:");
           fprintf (stderr,"\t unknown graphics id %d\n",id);
           return;
        }

        if(!(X3D_convert_point_wc_to_dc (id, wc_min, &xmin, &ymin)))
	   return;

        if(!(X3D_convert_point_wc_to_dc (id, wc_max, &xmax, &ymax)))
	   return;

        x = xmin; y = ymin;
        width = (xmax - xmin);
        height = (ymax - ymin);
        XClearArea(graphics->display, graphics->workspace, x, y, width, 
		   height, FALSE);
}



/************************************************************
*
*  MODULE NAME: X3D_clear_window
*
*      PURPOSE: clears the window specified by the ID
*
*        INPUT: id - xvgraphics ID
*
*       OUTPUT: clears the window specified
*
*    CALLED BY: application program
*
*   WRITTEN BY: Mark Young & Mike Lang
*
*************************************************************/


X3D_clear_window(id)

int     id;
{
        X3DGraphics     *graphics;
        int             x, y;
        unsigned int    width, height;

        if (!(graphics = _X3D_get_graphics(id)))
        {
           fprintf (stderr,"X3D_clear_window:");
           fprintf (stderr,"\t unknown graphics id %d\n",id);
           return;
        }

	if (graphics->device == X11)
	   XClearWindow(graphics->display, graphics->workspace);
}



/************************************************************
*
*  MODULE NAME: X3D_raise_window
*
*      PURPOSE: raises the window specified by the ID
a
*
*        INPUT: id - xvgraphics ID
*
*       OUTPUT: raises the window specified
*
*    CALLED BY: application program
*
*   WRITTEN BY: Mark Young & Mike Lang
*
*************************************************************/


X3D_raise_window(id)

int     id;
{
        X3DGraphics     *graphics;
        int             x, y;
        unsigned int    width, height;

        if (!(graphics = _X3D_get_graphics(id)))
        {
           fprintf (stderr,"X3D_raise_window:");
           fprintf (stderr,"\t unknown graphics id %d\n",id);
           return;
        }

	if (graphics->device == X11)
	   XRaiseWindow(graphics->display, graphics->workspace);
}
