 /*
  * Khoros: $Id: impress.c,v 1.3 1991/12/18 09:09:10 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: impress.c,v 1.3 1991/12/18 09:09:10 dkhoros Exp $";
#endif

 /*
  * $Log: impress.c,v $
 * Revision 1.3  1991/12/18  09:09:10  dkhoros
 * HellPatch3
 *
  */ 


/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "X3D.h"

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    	    file name: impress.c                      <<<<
   >>>>                                                       <<<<
   >>>>                 ImPress Utilities		      <<<<
   >>>>                                                       <<<<
   >>>>			X3D_set_impress()		      <<<<
   >>>>                                                       <<<<
   >>>>                 write_char()                          <<<<
   >>>>                 write_short()                         <<<<
   >>>>                                                       <<<<
   >>>>			Impress_DrawLine()		      <<<<
   >>>>			Impress_DrawLines()		      <<<<
   >>>>			Impress_DrawSegments()		      <<<<
   >>>>			Impress_DrawRectangle()		      <<<<
   >>>>			Impress_DrawArc()		      <<<<
   >>>>			Impress_FillPolygon()		      <<<<
   >>>>			Impress_close_device()		      <<<<
   >>>>			Impress_set_line_width()	      <<<<
   >>>>			Impress_set_line_type()		      <<<<
   >>>>			Impress_set_draw()		      <<<<
   >>>>			Impress_set_fill()		      <<<<
   >>>>			Impress_DrawPolygon()		      <<<<
   >>>>			Impress_DrawText()		      <<<<
   >>>>			Impress_FillArc()		      <<<<
   >>>>			Impress_FillRectangle()		      <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


#define DOTS_PER_INCH	300

#define	SET_HV_SYSTEM	205
#define	SET_ABS_H	135
#define	SET_ABS_V	137
#define	SET_REL_H	136
#define	SET_REL_V	138
#define	SET_PUSH_MASK	214

#define	CREATE_PATH	230
#define	CIRC_ARC	150
#define	CIRC_SEGM	160
#define	ELLIPSE_ARC	151
#define DRAW_PATH	234
#define FILL_PATH	233

#define	WHITE		  0
#define	BLACK		 15

#define	PUSH		211
#define	POP		212
#define	SET_PEN		232
#define	PAGE		213
#define	ENDPAGE		219


/************************************************************
*
*  MODULE NAME:  X3D_set_impress
*
*      PURPOSE:  Output graphics to ImPress file
*
*        INPUT:  id - xvgraphics id
*		 file - ImPress file to be sent to ImPress printer 
*		 width - width of output (on paper)
*		 height - height of output (on paper)
*		 xoffset - X offset from upper left hand corner (of paper)
*		 yoffset - Y offset from upper left hand corner (of paper)
*		 overlay - Don't force page output 
*		 landscape - landscape mode (horizontal output)
*
*    CALLED BY:  application program
*
*   WRITTEN BY:  Mike Lang & Mark Young
*
*
*************************************************************/

int X3D_set_impress(id, file, width, height, xoffset, yoffset, overlay, landscape)

int     id, overlay, landscape;
FILE	*file;
float	width, height, xoffset, yoffset;
{
	X3DGraphics     *graphics;
	short		x, y;

	if (!(graphics = _X3D_get_graphics(id)))
	{
	   fprintf (stderr,"X3D_set_impress:");
	   fprintf (stderr,"\t unknown graphics id %d\n",id);
	   return(FALSE);
	}

	x = xoffset * DOTS_PER_INCH;
	y = yoffset * DOTS_PER_INCH;
	width   *= DOTS_PER_INCH;
	height  *= DOTS_PER_INCH;

	graphics->device = IMPRESS;
	graphics->ifile   = file;
	X3D_set_window(id, x, y, (short) width, (short) height);

	if(graphics->ifile != NULL)
        {
	   fprintf(file, "@Document(Language ImPress, Name \"Xprism \
Document\", jobheader on, prerasterization on)");

	   write_char(graphics->ifile, SET_ABS_H);
	   write_short(graphics->ifile, x);
	   write_char(graphics->ifile, SET_ABS_V);
	   write_short(graphics->ifile, y);
	   write_char(graphics->ifile, SET_PEN);
	   write_char(graphics->ifile, 2);
	   write_char(graphics->ifile, PAGE);

	   if ((landscape))
	   {
	      /* please implement me */
	   }
	}
	else
	{
	   fprintf (stderr,"X3D_set_impress:");
	   fprintf (stderr,"\t unknown graphics file \n");
	   return(FALSE);
	}
	return(TRUE);
}



/************************************************************
*
*  MODULE NAME:  write_char
*
*      PURPOSE:
*
*        INPUT:
*
*       OUTPUT:
*
*    CALLED BY:
*
*   WRITTEN BY:  Mark Young
*
*************************************************************/

write_char(file, character)

FILE	 *file;
unsigned char character;
{
	fputc(character, file);
}



/************************************************************
*
*  MODULE NAME:  write_short
*
*      PURPOSE:
*
*        INPUT:
*
*       OUTPUT:
*
*    CALLED BY:
*
*   WRITTEN BY:  Mark Young
*
*************************************************************/

write_short(file, number)

FILE	 *file;
short	 number;
{
	write_char(file, (number >> 8));
	write_char(file, number);
}



/************************************************************
*
*  MODULE NAME:  Impress_DrawLine
*
*      PURPOSE: Draw a single line for an Impress device
*
*        INPUT:  graphics - graphics structure
*
*       OUTPUT: displays a line to an Impress device
*
*    CALLED BY: graphics routines
*
*   WRITTEN BY:  Mark Young
*
*************************************************************/

void Impress_DrawLine (graphics, p1x, p1y, p2x, p2y)

X3DGraphics *graphics;
short  p1x, p1y, p2x, p2y;
{
	write_char(graphics->ifile, CREATE_PATH);
	write_short(graphics->ifile, 2);
	write_short(graphics->ifile, p1x);
	write_short(graphics->ifile, p1y);
	write_short(graphics->ifile, p2x);
	write_short(graphics->ifile, p2y);
	write_char(graphics->ifile, DRAW_PATH);
	write_char(graphics->ifile, BLACK);
}



/************************************************************
*
*  MODULE NAME:  Impress_DrawLines
*
*      PURPOSE:  Draw a series of lines for an Impress device
*
*        INPUT:  graphics - graphics structure
*
*       OUTPUT: displays a a set of lines to an Impress device
*
*    CALLED BY: graphics routines
*
*   WRITTEN BY:  Mark Young
*
*************************************************************/

void Impress_DrawLines (graphics, points, size, coordmode)

X3DGraphics *graphics;
int     coordmode, size;
XPoint  *points;
{
	int		i;
	short		x, y;

	write_char(graphics->ifile, CREATE_PATH);
	write_short(graphics->ifile, (short) size);

	if (coordmode == CoordModeOrigin)
	{
	   for (i = 0; i < size; i++)
	   {
	      write_short(graphics->ifile, points[i].x);
	      write_short(graphics->ifile, points[i].y);
	   }
	}
	else if (coordmode == CoordModePrevious)
	{
	   x = points[0].x; y = points[0].y;
	   write_short(graphics->ifile, x);
	   write_short(graphics->ifile, y);

	   for (i = 1; i < size; i++)
	   {
	      x += points[i].x;
	      y += points[i].y;
	      write_short(graphics->ifile, x);
	      write_short(graphics->ifile, y);
	   }
	}
	write_char(graphics->ifile, DRAW_PATH);
	write_char(graphics->ifile, BLACK);
}



/************************************************************
*
*  MODULE NAME:  Impress_DrawSegments
*
*      PURPOSE:  Draw a series of disjoint segments for an Impress device
*
*        INPUT:  graphics - graphics structure
*
*       OUTPUT: displays a a set of segments to an Impress device
*
*    CALLED BY: graphics routines
*
*   WRITTEN BY:  Mark Young
*
*************************************************************/

void Impress_DrawSegments (graphics, segments, seg_num)

X3DGraphics *graphics;
int	 seg_num;
XSegment *segments;
{
	int		i;


	for (i = 0; i < seg_num; i++)
	{
	   write_char(graphics->ifile, CREATE_PATH);
	   write_short(graphics->ifile, 2);
	   write_short(graphics->ifile, segments[i].x1);
	   write_short(graphics->ifile, segments[i].y1);
	   write_short(graphics->ifile, segments[i].x2);
	   write_short(graphics->ifile, segments[i].y2);
	   write_char(graphics->ifile, DRAW_PATH);
	   write_char(graphics->ifile, BLACK);
	}
}



/************************************************************
*
*  MODULE NAME:  Impress_DrawRectangle
*
*      PURPOSE:  Draw a rectangle to an Impress device
*
*        INPUT:  graphics - graphics structure
*
*       OUTPUT: displays a rectangle to an Impress device
*
*    CALLED BY: graphics routines
*
*   WRITTEN BY:  Mark Young
*
*************************************************************/

void Impress_DrawRectangle (graphics, x, y, w, h)

X3DGraphics *graphics;
int      x, y;
unsigned int w, h;
{
	XPoint		points[5];


	points[0].x = points[3].x = points[4].x = x;
	points[1].x = points[2].x = x + w;
	points[0].y = points[1].y = points[4].y = y;
	points[2].y = points[3].y = y + h;
	Impress_DrawLines(graphics, points, 5, CoordModeOrigin);
}



/************************************************************
*
*  MODULE NAME:  Impress_DrawArc
*
*      PURPOSE:  Draw an arc (circle) for an Impress device
*	         x,y are the upper left corner of the bounding box of
*		 the circle ang1 & ang2 are the start and finish angles
*		 specified in degrees
*
*        INPUT:  graphics - graphics structure
*
*    CALLED BY: graphics routines
*
*   WRITTEN BY:  Mark Young
*
*************************************************************/

void Impress_DrawArc (graphics, x, y, w, h, ang1, ang2) 

X3DGraphics *graphics;
int     x, y, ang1, ang2;
int     w, h;
{
	short		alpha0, alpha1, offset, width, height;


	alpha0 = ang1 * 45.5111;
	alpha1 = ang2 * 45.5111;
	width  = w / 2;
	height = h / 2;
	offset = 0;

	write_char(graphics->ifile, PUSH);
	write_char(graphics->ifile, SET_ABS_H);
	write_short(graphics->ifile, (short) x);
	write_char(graphics->ifile, SET_ABS_V);
	write_short(graphics->ifile, (short) y);

	write_char(graphics->ifile, ELLIPSE_ARC);
	write_short(graphics->ifile, width);
	write_short(graphics->ifile, height);
	write_short(graphics->ifile, offset);
	write_short(graphics->ifile, alpha0);
	write_short(graphics->ifile, alpha1);
	write_char(graphics->ifile, POP);
}



/************************************************************
*
*  MODULE NAME:  Impress_FillPolygon
*
*      PURPOSE: Fill a polygon for an Impress device
*
*        INPUT:  graphics - graphics structure
*
*       OUTPUT: displays a filled polygon to an Impress device
*
*    CALLED BY: graphics routines
*
*   WRITTEN BY:  Mark Young
*
*************************************************************/

void Impress_FillPolygon(graphics, points, size, shape, coordmode)

X3DGraphics *graphics;
int     size, shape, coordmode;
XPoint  *points;
{
	int		i;


	write_char(graphics->ifile, CREATE_PATH);
	write_short(graphics->ifile, (short) size);
	for (i = 0; i < size; i++)
	{
	   write_short(graphics->ifile, points[i].x);
	   write_short(graphics->ifile, points[i].y);
	}
	write_char(graphics->ifile, FILL_PATH);
	write_char(graphics->ifile, WHITE);
}



/************************************************************
*
*  MODULE NAME:  Impress_close_device
*
*      PURPOSE:  
*
*        INPUT:  graphics
*
*    CALLED BY:  application program
*
*   WRITTEN BY:  Mike Lang & Mark Young
*
*
*************************************************************/


void Impress_close_device(graphics)

X3DGraphics *graphics;
{
	write_char(graphics->ifile, ENDPAGE);
}



/************************************************************
*
*  MODULE NAME:  Impress_set_line_width
*
*      PURPOSE:  
*
*        INPUT:  id
*
*    CALLED BY:  application program
*
*   WRITTEN BY:  Mike Lang & Tom Sauer
*
*
*************************************************************/


void Impress_set_line_width(graphics, line_width)

X3DGraphics     *graphics;
int line_width;
{
	float impress_line_width;

/*
	impress_line_width = line_widths[line_width][graphics->device];
 */

}


/************************************************************
*
*  MODULE NAME:  Impress_set_line_type
*
*      PURPOSE:  Sets the line type for a given graphics context
*
*        INPUT:  graphics - pointer to graphics context
*		 line_type - line type as defined in xvgraphics.h
*
*    CALLED BY:  application program
*
*
*   WRITTEN BY:  Tom Sauer
*
*
*************************************************************/


void Impress_set_line_type(graphics, line_type)

X3DGraphics *graphics;
int line_type;
{
	/* nothing yet */
}



/************************************************************
*
*  MODULE NAME:  Impress_set_draw
*
*      PURPOSE:  Set the foreground draw color.
*
*        INPUT:  graphics - graphics context
*	         fg	  - foreground color
*
*    CALLED BY:  application program
*
*   WRITTEN BY:  Mark Young
*
*
*************************************************************/

void Impress_set_draw(graphics, fg)

X3DGraphics     *graphics;
XColor		*fg;
{
}



/************************************************************
*
*  MODULE NAME:  Impress_set_fill
*
*      PURPOSE:  Set the background fill color.
*
*        INPUT:  graphics - graphics context
*	         bg	  - background color
*
*    CALLED BY:  application program
*
*   WRITTEN BY:  Mark Young
*
*
*************************************************************/

void Impress_set_fill(graphics, bg)

X3DGraphics     *graphics;
XColor		*bg;
{
}



/************************************************************
*
*  MODULE NAME:  Impress_DrawPolygon
*
*      PURPOSE:  Draw a filled polygon.
*
*        INPUT:  graphics - graphics structure
*	         points   - points to be drawn
*	         size     - number of points
*
*   WRITTEN BY:
*
*
*************************************************************/

void Impress_DrawPolygon(graphics, points, size)

X3DGraphics     *graphics;
XPoint		*points;
int		size;
{
	/* nothing yet */
}



/************************************************************
*
*  MODULE NAME:  Impress_DrawText
*
*      PURPOSE:  Draw text at the given position.
*
*        INPUT:  graphics - graphics structure
*	         x	  - x position
*	         y	  - y position
*		 font	  - font to be used
*	         text	  - text to be printed
*	         size	  - size of text array
*
*   WRITTEN BY:
*
*
*************************************************************/

void Impress_DrawText(graphics, x, y, font, text, size)

X3DGraphics     *graphics;
char		*font, *text;
int		x, y, size;
{
	/* nothing yet */
}



/************************************************************
*
*  MODULE NAME:  Impress_FillArc
*
*      PURPOSE: Draw a filled arc.
*
*        INPUT:  graphics - graphics structure
*	         x	  - of upper left corner
*	         y	  - of upper left corner
*	         w	  - width of Arc
*	         h	  - height of Arc
*	         arc1	  - start angle
*	         arc2	  - end angle
*
*   WRITTEN BY:
*
*
*************************************************************/

void Impress_FillArc(graphics, x, y, w, h, ang1, ang2)

X3DGraphics	*graphics;
int		x, y, ang1, ang2;
unsigned int	w, h;
{
   /* just return */
}



/************************************************************
*
*  MODULE NAME:  Impress_FillRectangle
*
*      PURPOSE:  Draw a filled rectangle.
*
*        INPUT:  graphics - graphics structure
*	         x	  - of upper left corner
*	         y	  - of upper left corner
*	         w	  - width of rectangle
*	         h	  - height of rectangle
*
*   WRITTEN BY:
*
*
*************************************************************/

void Impress_FillRectangle(graphics, x, y, w, h)

X3DGraphics     *graphics;
int		x, y, w, h;
{
   /* just return */
}
