 /*
  * Khoros: $Id: graphics.h,v 1.1 1991/05/10 15:56:56 khoros Exp $
  */

 /*
  * $Log: graphics.h,v $
 * Revision 1.1  1991/05/10  15:56:56  khoros
 * Initial revision
 *
  */ 


/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.

 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    file name: graphics.h
   >>>>                         
   >>>>   description: All local graphics routines and definition
   >>>>              
   >>>>      routines: 	
   >>>>                
   >>>> modifications:
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


/************************************************************
*
*  MODULE NAME:  Low level Graphics routines.
*
*      PURPOSE:  All local graphics routines and definition
*
*	Many thanks to Tait for his good advice and comments on
*	creating independent graphics routines.
*	
*
*   WRITTEN BY:			Mark Young & Mike Lang
*   TECHNICAL EXPERTISE BY:  	Tait Cyrus
*
***********************************************************/


#ifndef	 _X3DGraphics_h
#define  _X3DGraphics_h

/*
 *  The type of output devices  (what language the output device speaks)
 */
#define X11		0
#define POSTSCR 	1
#define IMPRESS 	2
#define HPGL 		3


void		X11_DrawLine(),
		X11_DrawLines(),
		X11_DrawSegments(),
		X11_DrawRectangle(),
		X11_DrawPolygon(),
		X11_DrawArc(),
		X11_DrawText(),
		X11_FillPolygon(),
		X11_FillArc(),
		X11_FillRectangle(),
                X11_set_line_width(),
                X11_set_line_type(),
                X11_set_draw(),
                X11_set_fill(),
		X11_close_device();

void		Postscript_DrawLine(),
		Postscript_DrawLines(),
		Postscript_DrawSegments(),
		Postscript_DrawRectangle(),
		Postscript_DrawPolygon(),
		Postscript_DrawArc(),
		Postscript_DrawText(),
		Postscript_FillPolygon(),
		Postscript_FillArc(),
		Postscript_FillRectangle(),
                Postscript_set_line_width(),
                Postscript_set_line_type(),
                Postscript_set_draw(),
                Postscript_set_fill(),
		Postscript_close_device();

void		Impress_DrawLine(),
		Impress_DrawLines(),
		Impress_DrawSegments(),
		Impress_DrawRectangle(),
		Impress_DrawPolygon(),
		Impress_DrawArc(),
		Impress_DrawText(),
		Impress_FillPolygon(),
		Impress_FillArc(),
		Impress_FillRectangle(),
                Impress_set_line_width(),
                Impress_set_line_type(),
                Impress_set_draw(),
                Impress_set_fill(),
		Impress_close_device();

void		HPGL_DrawLine(),
		HPGL_DrawLines(),
		HPGL_DrawSegments(),
		HPGL_DrawRectangle(),
		HPGL_DrawPolygon(),
		HPGL_DrawArc(),
		HPGL_DrawText(),
		HPGL_FillPolygon(),
		HPGL_FillArc(),
		HPGL_FillRectangle(),
                HPGL_set_line_width(),
                HPGL_set_line_type(),
                HPGL_set_draw(),
                HPGL_set_fill(),
		HPGL_close_device();

void		LN03_DrawLine(),
		LN03_DrawLines(),
		LN03_DrawSegments(),
		LN03_DrawRectangle(),
		LN03_DrawPolygon(),
		LN03_DrawArc(),
		LN03_DrawText(),
		LN03_FillPolygon(),
		LN03_FillArc(),
		LN03_FillRectangle(),
                LN03_set_line_width(),
                LN03_set_line_type(),
                LN03_set_draw(),
                LN03_set_fill(),
		LN03_close_device();

typedef struct _graphics_routine
{
	void	(*line)();
	void	(*lines)();
	void	(*segments)();
	void	(*rectangle)();
	void	(*polygon)();
	void	(*arc)();
	void	(*text)();
	void	(*fill_polygon)();
	void	(*fill_arc)();
	void	(*fill_rectangle)();
        void    (*line_width)();
        void    (*line_type)();
        void    (*draw_color)();
        void    (*fill_color)();
	void	(*close)();

} GraphicsRoutines;

static GraphicsRoutines X3D_draw[] =
{
	{
		X11_DrawLine,
		X11_DrawLines,
		X11_DrawSegments,
		X11_DrawRectangle,
		X11_DrawPolygon,
		X11_DrawArc,
		X11_DrawText,
		X11_FillPolygon,
		X11_FillArc,
		X11_FillRectangle,
                X11_set_line_width,
                X11_set_line_type,
                X11_set_draw,
                X11_set_fill,
		X11_close_device,
	},

	{
		Postscript_DrawLine,
		Postscript_DrawLines,
		Postscript_DrawSegments,
		Postscript_DrawRectangle,
		Postscript_DrawPolygon,
		Postscript_DrawArc,
		Postscript_DrawText,
		Postscript_FillPolygon,
		Postscript_FillArc,
		Postscript_FillRectangle,
                Postscript_set_line_width,
                Postscript_set_line_type,
                Postscript_set_draw,
                Postscript_set_fill,
		Postscript_close_device,
	},

	{
		Impress_DrawLine,
		Impress_DrawLines,
		Impress_DrawSegments,
		Impress_DrawRectangle,
		Impress_DrawPolygon,
		Impress_DrawArc,
		Impress_DrawText,
		Impress_FillPolygon,
		Impress_FillArc,
		Impress_FillRectangle,
                Impress_set_line_width,
                Impress_set_line_type,
                Impress_set_draw,
                Impress_set_fill,
		Impress_close_device,
	},

	{
		HPGL_DrawLine,
		HPGL_DrawLines,
		HPGL_DrawSegments,
		HPGL_DrawRectangle,
		HPGL_DrawPolygon,
		HPGL_DrawArc,
		HPGL_DrawText,
		HPGL_FillPolygon,
		HPGL_FillArc,
		HPGL_FillRectangle,
                HPGL_set_line_width,
                HPGL_set_line_type,
                HPGL_set_draw,
                HPGL_set_fill,
		HPGL_close_device,
	},

	{
		LN03_DrawLine,
		LN03_DrawLines,
		LN03_DrawSegments,
		LN03_DrawRectangle,
		LN03_DrawPolygon,
		LN03_DrawArc,
		LN03_DrawText,
		LN03_FillPolygon,
		LN03_FillArc,
		LN03_FillRectangle,
                LN03_set_line_width,
                LN03_set_line_type,
                LN03_set_draw,
                LN03_set_fill,
		LN03_close_device,
	},
};


#endif
/*  Don't add after endif  */
