 /*
  * Khoros: $Id: coord_2D.c,v 1.2 1991/07/15 06:00:44 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: coord_2D.c,v 1.2 1991/07/15 06:00:44 khoros Exp $";
#endif

 /*
  * $Log: coord_2D.c,v $
 * Revision 1.2  1991/07/15  06:00:44  khoros
 * HellPatch1
 *
  */ 


/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 *
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "X3D.h"

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    file name: coord_2D.c
   >>>>               
   >>>>   description: Utilities to Manipulate 2D Coordinates 
   >>>>              
   >>>>      routines:
   >>>>            X2D_translate_coords() 		      <<<<
   >>>>            X2D_scale_coords() 		  	      <<<<
   >>>>            X2D_rotate_coords() 		  	      <<<<
   >>>>		
   >>>>              
   >>>> modifications:
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

/************************************************************
*
*  MODULE NAME: X2D_translate_coords
*
*      PURPOSE: used to translate 2D world coordinates to their
*		new world coordinate position.
*
*        INPUT: xtrans, ytrans - the x & y values to translate by
*		coords - array of coordinates to translate
*		size   - number of coordinates in coords array
*
*       OUTPUT: new coordinate values in the coords array
*
*    CALLED BY: application program
*
*   WRITTEN BY:	Mark Young
*
*************************************************************/

X2D_translate_coords (xtrans, ytrans, coords, size)

Real	xtrans, ytrans;
Coord	*coords;
int	size;
{
	int		i;
	Real		w;
	Coord		temp;
	Matrix_2D	matrix;

	X2D_matrix_set_translate(xtrans, ytrans, matrix);

	for (i = 0; i < size; i++)
	{
	    temp = coords[i];
	    _X2D_vector_mult(temp, matrix, coords[i].x, coords[i].y, w);
	}
}



/************************************************************
*
*  MODULE NAME: X2D_scale_coords
*
*      PURPOSE: used to scale 2D world coordinates to their
*		new world coordinate position.
*
*        INPUT: xscale, yscale - the x & y values to scale by
*		coords - array of coordinates to scale
*		size   - number of coordinates in coords array
*
*       OUTPUT: new coordinate values in the coords array
*
*    CALLED BY: application program
*
*   WRITTEN BY:	Mark Young
*
*************************************************************/

X2D_scale_coords (xscale, yscale, coords, size)

Real	xscale, yscale;
Coord	*coords;
int	size;
{
	int		i;
	Real		w;
	Coord		temp;
	Matrix_2D	matrix;

	X2D_matrix_set_scale(xscale, yscale, matrix);

	for (i = 0; i < size; i++)
	{
	    temp = coords[i];
	    _X2D_vector_mult(coords[i], matrix, coords[i].x, coords[i].y, w);
	}
}


/************************************************************
*
*  MODULE NAME: X2D_rotate_coords
*
*      PURPOSE: used to rotate 2D world coordinates to their
*		new world coordinate position.
*
*        INPUT: rotation - the angle (in radians) to be rotated by
*		center - the point to rotate about
*		coords - array of coordinates to rotate
*		size   - number of coordinates in coords array
*
*       OUTPUT: new coordinate values in the coords array
*
*    CALLED BY: application program
*
*   WRITTEN BY:	Mark Young
*
*************************************************************/

X2D_rotate_coords (rotation, center, coords, size)

Real	rotation;
Coord	center, *coords;
int	size;
{
	int		i;
	Real		w;
	Coord		temp;
	Matrix_2D	matrix1, matrix2;

	X2D_matrix_set_translate(-center.x, -center.y, matrix1);
	X2D_matrix_set_rotate(rotation, matrix2);
        _X2D_matrix_mult(matrix1, matrix2, matrix1);
	X2D_matrix_set_translate(center.x, center.y, matrix2);
        _X2D_matrix_mult(matrix1, matrix2, matrix1);

	for (i = 0; i < size; i++)
	{
	    temp = coords[i];
	    _X2D_vector_mult(coords[i], matrix1, coords[i].x, coords[i].y, w);
	}
}
