 /*
  * Khoros: $Id: vfht.h,v 1.1 1991/05/10 15:51:33 khoros Exp $
  */

 /*
  * $Log: vfht.h,v $
 * Revision 1.1  1991/05/10  15:51:33  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vfht.h
 >>>>            Author: Per Lysne
 >>>> Date Last Updated: Tue Mar  5 22:41:24 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vfht_h_
#define _vfht_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    vfht Argument Structure
*
****************************************************************/

typedef struct _vfht  {

/*
 *  input image (xviff file) (Required infile)
 */
char	*i_file;	/* input image (xviff file) FILENAME */
int	 i_flag;	/* input image (xviff file) FLAG */

/*
 *  output image (xviff file) (Required outfile)
 */
char	*o_file;	/* output image (xviff file) FILENAME */
int	 o_flag;	/* output image (xviff file) FLAG */

/*
 *  scale output by 1/N (0 = no scale, 1 = scale) (Optional logical)
 */
int	 s_logic;	/* scale output by 1/N (0 = no scale, 1 = scale) LOGIC */
int	 s_flag;  	/* scale output by 1/N (0 = no scale, 1 = scale) FLAG */

}  vfht_struct;

vfht_struct *vfht;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define CHECKINPUT(program, img) {                                            \
        (void) proper_loc_type (program, img, VFF_LOC_IMPLICIT, TRUE);        \
        (void) proper_map_type (program, img, VFF_MAPTYP_NONE, TRUE);         \
        (void) proper_map_enable (program, img, VFF_MAP_OPTIONAL, TRUE);      \
        (void) proper_map_scheme (program, img, VFF_MS_NONE, TRUE);           \
        (void) proper_num_images (program, img, 1, TRUE);                     \
        (void) proper_num_bands (program, img, 1, TRUE);                      \
        if ((img->data_storage_type != VFF_TYP_1_BYTE) &&                     \
           (img->data_storage_type != VFF_TYP_2_BYTE)  &&                     \
           (img->data_storage_type != VFF_TYP_4_BYTE)  &&                     \
           (img->data_storage_type != VFF_TYP_FLOAT)) {                       \
            fprintf (stderr, "error in dfht: input data type must be ");      \
            fprintf (stderr, "byte, short, int, or float\n");                 \
            exit (1);                                                         \
        }                                                                     \
}
/* -include_macros_end */

#endif
