 /*
  * Khoros: $Id: vthresh.c,v 1.1 1991/05/10 15:51:13 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vthresh.c,v 1.1 1991/05/10 15:51:13 khoros Exp $";
#endif

 /*
  * $Log: vthresh.c,v $
 * Revision 1.1  1991/05/10  15:51:13  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vthresh.c
 >>>>
 >>>>      Program Name: vthresh
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Create a binary image by applying upper and lower thresholds
 >>>>	to an input image.
 >>>>	
 >>>>	
 >>>>            Author: Scott Wilson
 >>>>
 >>>> Date Last Updated: Thu Mar 28 00:11:43 1991
 >>>>
 >>>>          Routines: main- the main program for vthresh
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vthresh.h"


/****************************************************************
 *
 * Routine Name:  main program for vthresh
 *
 *       Input:  
 *         -i  input image 
 *         -o  output image 
 *
 *
 *         [-l] lower threshold value 
 *         [-u] upper threshold value 
 *         [-v] specifies the non-zero pixel output value 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
        struct xvimage *image,*readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
        if (check_args()) exit(1);
        image = readimage(vthresh->i_file);
        CHECKINPUT(program,image);
/* -main_before_lib_call_end */

/* -main_library_call */
        if(!lvthresh(image,vthresh->l_flag,vthresh->l_float,
                           vthresh->u_flag,vthresh->u_float,
                           vthresh->v_float) )
          {
            fprintf(stderr, "lvthresh Failed\n");
            exit(1);
          }
/* -main_library_call_end */

/* -main_after_lib_call */
        writeimage(vthresh->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vthresh 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vthresh :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tCreate a binary image by applying upper and lower thresholds\n");
	fprintf(stderr, "\tto an input image.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image  (infile)\n");
	fprintf(stderr,"\t-o  output image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-l]  lower threshold value (float) [128]\n");
	fprintf(stderr,"\t[-u]  upper threshold value (float) [255]\n");
	fprintf(stderr,"\t[-v]  specifies the non-zero pixel output value (float) [255]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vthresh\n");
	fprintf(stderr, "\t[-U] Gives the usage for vthresh\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vthresh.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vthresh.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vthresh
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) output image \n        {outfile}: "; 
char	*l_pstr = 
	"\nEnter: (l) lower threshold value \n        {float [128.000000] }: "; 
char	*u_pstr = 
	"\nEnter: (u) upper threshold value \n        {float [255.000000] }: "; 
char	*v_pstr = 
	"\nEnter: (v) specifies the non-zero pixel output value \n        {float [255.000000] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vthresh", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vthresh.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vthresh: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vthresh.ans");
		}

	     }

	}

	/*
	 * allocate the vthresh structure
	 */
	vthresh = (vthresh_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vthresh_struct));

	/*
	 * get required arguments for vthresh
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vthresh->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vthresh->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vthresh->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vthresh->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vthresh->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vthresh->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vthresh->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vthresh->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vthresh->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vthresh->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vthresh
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vthresh->l_flag = vget_float(fid, prompt_flag,
	"-l", l_pstr, &(vthresh->l_float),
	128.000000, 0.000000, 0.000000);

	vthresh->u_flag = vget_float(fid, prompt_flag,
	"-u", u_pstr, &(vthresh->u_float),
	255.000000, 0.000000, 0.000000);

	vthresh->v_flag = vget_float(fid, prompt_flag,
	"-v", v_pstr, &(vthresh->v_float),
	255.000000, 0.000000, 0.000000);


}



