 /*
  * Khoros: $Id: vmsquish.c,v 1.1 1991/05/10 15:50:38 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vmsquish.c,v 1.1 1991/05/10 15:50:38 khoros Exp $";
#endif

 /*
  * $Log: vmsquish.c,v $
 * Revision 1.1  1991/05/10  15:50:38  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vmsquish.c
 >>>>
 >>>>      Program Name: vmsquish
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Compress columns  in  map(s)  to  one  column  by  means  of
 >>>>	Average, RMS or MAX
 >>>>	
 >>>>	
 >>>>            Author: Tom sauer
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:38:09 1991
 >>>>
 >>>>          Routines: main- the main program for vmsquish
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vmsquish.h"


/****************************************************************
 *
 * Routine Name:  main program for vmsquish
 *
 *       Input:  
 *          -i  input image filename 
 *          -o  output image filename 
 *
 *
 *          [-m] map data after squishing map
 *          [-t] Specifies operation to use to squish map(s)
 *		1 (Average),
 *		2 (RMS),
 *		or 3 (Maximum)
 *		   [default = 1] 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *image, *readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if (check_args()) exit(1);

     /* read the image */
image = readimage(vmsquish->i_file);
if (image == NULL)
 {
   (void) fprintf(stderr, "vmsquish: Can not read input image\n");
    exit(1);  /* Quit if bad image */
 }

     /* only one image per file is allowed */
(void) proper_num_images(program,image,1,TRUE);
/* -main_before_lib_call_end */

/* -main_library_call */
if(! lvmsquish(image, vmsquish->m_logic, vmsquish->t_toggle))
 {
   (void) fprintf(stderr, "lvmsquish Failed\n");
   exit(1);
 }
/* -main_library_call_end */

/* -main_after_lib_call */
     /* write out the new file */
(void) writeimage(vmsquish->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vmsquish 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vmsquish :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tCompress columns  in  map(s)  to  one  column  by  means  of\n");
	fprintf(stderr, "\tAverage, RMS or MAX\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image filename  (infile)\n");
	fprintf(stderr,"\t-o  output image filename  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-m]  map data after squishing map (boolean) [true]\n");
	fprintf(stderr, "\t[-t]  Specifies operation to use to squish map(s)\n");
	fprintf(stderr, "\t\t1  (Average),\n");
	fprintf(stderr, "\t\t2  (RMS),\n");
	fprintf(stderr, "\t\tor 3  (Maximum)\n");
	fprintf(stderr, "\t\t[default = 1]\n");
	fprintf(stderr, "\n");	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vmsquish\n");
	fprintf(stderr, "\t[-U] Gives the usage for vmsquish\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vmsquish.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vmsquish.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vmsquish
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image filename \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) output image filename \n        {outfile}: "; 
char	*m_pstr = 
	"\nEnter: (m) map data after squishing map \n        {boolean, (y/n)  [yes] }: "; 
char	*t_pstr = "\nEnter: (t) Specifies operation to use to squish map(s) -- \n      \t\t1 (Average)\n\t\t2 (RMS)\n\t\tor 3 (Maximum)\n  [1]:  "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vmsquish", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vmsquish.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vmsquish: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vmsquish.ans");
		}

	     }

	}

	/*
	 * allocate the vmsquish structure
	 */
	vmsquish = (vmsquish_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vmsquish_struct));

	/*
	 * get required arguments for vmsquish
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vmsquish->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vmsquish->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vmsquish->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vmsquish->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vmsquish->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vmsquish->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vmsquish->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vmsquish->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vmsquish->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vmsquish->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vmsquish
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vmsquish->m_flag = vget_logic(fid, prompt_flag,
	"-m", m_pstr, &(vmsquish->m_logic), 1);


	/*
	 * get optional toggles for vmsquish
	 */
	if (prompt_flag == TRUE)
	{
	    ok = FALSE;
	    while(!ok)
	    {
		vmsquish->t_flag = vget_int(fid, prompt_flag,
		"-t", t_pstr, &(vmsquish->t_toggle),
		1, 0, 0);

		if ((vmsquish->t_toggle == 1 ) || 
		    (vmsquish->t_toggle == 2 ) || 
		    (vmsquish->t_toggle == 3 ))
		      ok = TRUE;
		else
		{
		}
	    }
	}
	else
	{
		vmsquish->t_flag = vget_int(fid, prompt_flag,
		"-t", t_pstr, &(vmsquish->t_toggle),
		1, 0, 0);

		if ((vmsquish->t_toggle != 1 ) && 
		    (vmsquish->t_toggle != 2 ) && 
		    (vmsquish->t_toggle != 3 ))
		{
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
	}


}



