 /*
  * Khoros: $Id: vgsin.h,v 1.3 1992/03/20 23:13:43 dkhoros Exp $
  */

 /*
  * $Log: vgsin.h,v $
 * Revision 1.3  1992/03/20  23:13:43  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vgsin.h
 >>>>            Author: Jeremy Worley, Marcelo Teran, Ramiro Jordan
 >>>> Date Last Updated: Thu Mar  5 08:36:26 1992
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vgsin_h_
#define _vgsin_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program;	/* a pointer to the program name argv[0] */
int	ac;

/****************************************************************
*
*                    vgsin Argument Structure
*
****************************************************************/

typedef struct _vgsin  {

/*
 *  resulting image (Required outfile)
 */
char	*o_file;	/* resulting image FILENAME */
int	 o_flag;	/* resulting image FLAG */

/*
 *  trigger input (Optional infile)
 */
char	*trigger_file;	/* trigger input FILENAME */
int	 trigger_flag;	/* trigger input FLAG */

/*
 *  number of rows (Optional integer)
 */
int	 r_int; 	/* number of rows INT */
int	 r_flag;	/* number of rows FLAG */

/*
 *  number of columns (Optional integer)
 */
int	 c_int; 	/* number of columns INT */
int	 c_flag;	/* number of columns FLAG */

/*
 *  number of data bands (Optional integer)
 */
int	 b_int; 	/* number of data bands INT */
int	 b_flag;	/* number of data bands FLAG */

/*
 *  maximum image level (Optional float)
 */
float	 m_float;	/* maximum image level FLOAT */
int	 m_flag;   	/* maximum image level FLAG */

/*
 *  Frequency in X direction (rad/pix) (Optional float)
 */
float	 fx_float;	/* Frequency in X direction (rad/pix) FLOAT */
int	 fx_flag;   	/* Frequency in X direction (rad/pix) FLAG */

/*
 *  Frequency in Y direction (rad/pix) (Optional float)
 */
float	 fy_float;	/* Frequency in Y direction (rad/pix) FLOAT */
int	 fy_flag;   	/* Frequency in Y direction (rad/pix) FLAG */

/*
 *  Phase offset in X direction (radians) (Optional float)
 */
float	 px_float;	/* Phase offset in X direction (radians) FLOAT */
int	 px_flag;   	/* Phase offset in X direction (radians) FLAG */

/*
 *  Phase offset in Y direction (radians) (Optional float)
 */
float	 py_float;	/* Phase offset in Y direction (radians) FLOAT */
int	 py_flag;   	/* Phase offset in Y direction (radians) FLAG */

/*
 *  Relative sampling frequency (Optional float)
 */
float	 fs_float;	/* Relative sampling frequency FLOAT */
int	 fs_flag;   	/* Relative sampling frequency FLAG */

/*
 * Output image data type (Optional string toggle - )
 */
char	*t_toggle;		/* Output image data type STRING TOGGLE */
int	 t_flag;		/* Output image data type FLAG */

}  vgsin_struct;

vgsin_struct *vgsin;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
/* -include_macros_end */

#endif
