 /*
  * Khoros: $Id: vgshot.h,v 1.2 1991/12/18 09:38:30 dkhoros Exp $
  */

 /*
  * $Log: vgshot.h,v $
 * Revision 1.2  1991/12/18  09:38:30  dkhoros
 * HellPatch3
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vgshot.h
 >>>>            Author: Marcelo Teran, Ramiro Jordan
 >>>> Date Last Updated: Tue Dec 10 15:22:25 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vgshot_h_
#define _vgshot_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program;	/* a pointer to the program name argv[0] */
int	ac;

/****************************************************************
*
*                    vgshot Argument Structure
*
****************************************************************/

typedef struct _vgshot  {

/*
 *  input image (Required infile)
 */
char	*i_file;	/* input image FILENAME */
int	 i_flag;	/* input image FLAG */

/*
 *  resulting output image (Required outfile)
 */
char	*o_file;	/* resulting output image FILENAME */
int	 o_flag;	/* resulting output image FLAG */

/*
 *  trigger input (Optional infile)
 */
char	*trigger_file;	/* trigger input FILENAME */
int	 trigger_flag;	/* trigger input FLAG */

/*
 *  spikes percentage (Optional float)
 */
float	 n_float;	/* spikes percentage FLOAT */
int	 n_flag;   	/* spikes percentage FLAG */

}  vgshot_struct;

vgshot_struct *vgshot;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
/*
**  The following define checks for proper values of:
**       num_of_images = 1
**       num_data_bands = 1
**       data_storage_type = VFF_TYP_1_BYTE
**       map_enable = VFF_MAP_OPTIONAL
*/
#define CHECKINPUT(program, img1) \
        (void) proper_num_images(program,img1,1,TRUE); \
        (void) proper_num_bands(program,img1,1,TRUE); \
        (void) propertype(program,img1,VFF_TYP_1_BYTE,TRUE); \
        (void) proper_map_enable(program,img1,VFF_MAP_OPTIONAL,TRUE)
/* -include_macros_end */

#endif
