 /*
  * Khoros: $Id: vgpwl.c,v 1.3 1992/03/20 23:13:58 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vgpwl.c,v 1.3 1992/03/20 23:13:58 dkhoros Exp $";
#endif

 /*
  * $Log: vgpwl.c,v $
 * Revision 1.3  1992/03/20  23:13:58  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vgpwl.c
 >>>>
 >>>>      Program Name: vgpwl
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Creates a set of piecewise linear periodic image.
 >>>>	
 >>>>	

 >>>>            Author: Jeremy Worley
 >>>>
 >>>> Date Last Updated: Thu Mar  5 08:28:30 1992
 >>>>
 >>>>          Routines: main- the main program for vgpwl
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vgpwl.h"


/****************************************************************
 *
 * Routine Name:  main program for vgpwl
 *
 *       Input:  
 *       -o  resulting image 
 *
 *
 *       [-trigger] trigger input
 *       [-r] number of rows  (value > 0)
 *       [-c] number of columns  (value > 0)
 *       [-b] number of bands  (value > 0)
 *       [-s] sampling frequency  (value > 0.0)
 *       [-l] signal minimum 
 *       [-m] signal maximum 
 *       [-xp] signal period in X-direction  (value > 0.0)
 *       [-yp] signal period in Y-direction  (value > 0.0)
 *       [-xr] rise time in X-direction  (value >= 0.0)
 *       [-yr] rise time in Y-direction   (value >= 0.0)
 *       [-xf] fall time in X-direction   (value >= 0.0)
 *       [-yf] fall time in Y-direction   (value >= 0.0)
 *       [-xw] pulse width in X-direction   (value >= 0.0)
 *       [-yw] pulse width in Y-direction   (value >= 0.0)
 *       [-t] lets user choose data type of image
 *		'float' (select data type),
 *		 or 'complex' (choose data type)
 *		   [default = float] 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */

struct xvimage *image, *readimage();
int type;

/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
  if(check_args())exit(1);
  if(!vget_type(&type,vgpwl->t_toggle)){
     fprintf(stderr,"vgpwl:  Invalid data type specified\n");
     exit(1);
  }
/* -main_before_lib_call_end */

/* -main_library_call */
  if(!lvgpwl(&image,vgpwl->r_int,vgpwl->c_int,vgpwl->b_int,vgpwl->s_float,
             vgpwl->l_float,vgpwl->m_float,vgpwl->xp_float,vgpwl->yp_float,
             vgpwl->xr_float,vgpwl->yr_float,vgpwl->xf_float,vgpwl->yf_float,
             vgpwl->xw_float,vgpwl->yw_float,type)){
    (void)fprintf(stderr, "lvgpwl Failed\n");
    exit(1);
  }
/* -main_library_call_end */

/* -main_after_lib_call */
writeimage(vgpwl->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vgpwl 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vgpwl :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tCreates a set of piecewise linear periodic image.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
fprintf(stderr,"\nThe -t option will accept input in either of two forms:\n");
fprintf(stderr,"  an alphabetic representation, i.e. 'float' or 'complex',\n");
fprintf(stderr,"  or a numeric representation, such as 4 for real.\n");
/* -usage_additions_end */

	fprintf(stderr,"\t-o  resulting image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-trigger]  trigger input (infile) [null]\n");
	fprintf(stderr,"\t[-r]  number of rows (integer, > 0) [512]\n");
	fprintf(stderr,"\t[-c]  number of columns (integer, > 0) [512]\n");
	fprintf(stderr,"\t[-b]  number of bands (integer, > 0) [1]\n");
	fprintf(stderr,"\t[-s]  sampling frequency (float, > 0.0) [2]\n");
	fprintf(stderr,"\t[-l]  signal minimum (float) [0]\n");
	fprintf(stderr,"\t[-m]  signal maximum (float) [1]\n");
	fprintf(stderr,"\t[-xp]  signal period in X-direction (float, > 0.0) [1]\n");
	fprintf(stderr,"\t[-yp]  signal period in Y-direction (float, > 0.0) [1]\n");
	fprintf(stderr,"\t[-xr]  rise time in X-direction (float, >= 0.0) [0]\n");
	fprintf(stderr,"\t[-yr]  rise time in Y-direction  (float, >= 0.0) [0]\n");
	fprintf(stderr,"\t[-xf]  fall time in X-direction  (float, >= 0.0) [0]\n");
	fprintf(stderr,"\t[-yf]  fall time in Y-direction  (float, >= 0.0) [0]\n");
	fprintf(stderr,"\t[-xw]  pulse width in X-direction  (float, >= 0.0) [0]\n");
	fprintf(stderr,"\t[-yw]  pulse width in Y-direction  (float, >= 0.0) [0]\n");
	fprintf(stderr, "\t[-t]  lets user choose data type of image\n");
	fprintf(stderr, "\t\t'float'  (select data type),\n");
	fprintf(stderr, "\t\t or 'complex'  (choose data type)\n");
	fprintf(stderr, "\t\t[default = float]\n");
	fprintf(stderr, "\n");	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vgpwl\n");
	fprintf(stderr, "\t[-U] Gives the usage for vgpwl\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vgpwl.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vgpwl.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vgpwl
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*o_pstr = 
	"\nEnter: (o) resulting image \n        {outfile}: "; 
char	*trigger_pstr = 
	"\nEnter: (trigger) trigger input \n        {infile}: "; 
char	*r_pstr = 
	"\nEnter: (r) number of rows \n        {integer, > 0 [512] }: "; 
char	*c_pstr = 
	"\nEnter: (c) number of columns \n        {integer, > 0 [512] }: "; 
char	*b_pstr = 
	"\nEnter: (b) number of bands \n        {integer, > 0 [1] }: "; 
char	*s_pstr = 
	"\nEnter: (s) sampling frequency \n        {float, > 0.0 [2.000000] }: "; 
char	*l_pstr = 
	"\nEnter: (l) signal minimum \n        {float [0.000000] }: "; 
char	*m_pstr = 
	"\nEnter: (m) signal maximum \n        {float [1.000000] }: "; 
char	*xp_pstr = 
	"\nEnter: (xp) signal period in X-direction \n        {float, > 0.0 [1.000000] }: "; 
char	*yp_pstr = 
	"\nEnter: (yp) signal period in Y-direction \n        {float, > 0.0 [1.000000] }: "; 
char	*xr_pstr = 
	"\nEnter: (xr) rise time in X-direction \n        {float, >= 0.0 [0.000000] }: "; 
char	*yr_pstr = 
	"\nEnter: (yr) rise time in Y-direction  \n        {float, >= 0.0 [0.000000] }: "; 
char	*xf_pstr = 
	"\nEnter: (xf) fall time in X-direction  \n        {float, >= 0.0 [0.000000] }: "; 
char	*yf_pstr = 
	"\nEnter: (yf) fall time in Y-direction  \n        {float, >= 0.0 [0.000000] }: "; 
char	*xw_pstr = 
	"\nEnter: (xw) pulse width in X-direction  \n        {float, >= 0.0 [0.000000] }: "; 
char	*yw_pstr = 
	"\nEnter: (yw) pulse width in Y-direction  \n        {float, >= 0.0 [0.000000] }: "; 
char	*t_pstr = "\nEnter: (t) lets user choose data type of image -- \n      \t\t'float' (select data type)\n\t\tor 'complex' (choose data type)\n  [float]:  "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vgpwl", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vgpwl.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vgpwl: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vgpwl.ans");
		}

	     }

	}

	/*
	 * allocate the vgpwl structure
	 */
	vgpwl = (vgpwl_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vgpwl_struct));

	/*
	 * get required arguments for vgpwl
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vgpwl->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vgpwl->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vgpwl->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vgpwl->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vgpwl->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vgpwl
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vgpwl->trigger_flag = vget_infile(fid, prompt_flag,
	"-trigger", trigger_pstr, &(vgpwl->trigger_file))
;

	vgpwl->r_flag = vget_int(fid, prompt_flag,
	"-r", r_pstr, &(vgpwl->r_int),
	512, 2, 2);

	vgpwl->c_flag = vget_int(fid, prompt_flag,
	"-c", c_pstr, &(vgpwl->c_int),
	512, 2, 2);

	vgpwl->b_flag = vget_int(fid, prompt_flag,
	"-b", b_pstr, &(vgpwl->b_int),
	1, 2, 2);

	vgpwl->s_flag = vget_float(fid, prompt_flag,
	"-s", s_pstr, &(vgpwl->s_float),
	2.000000, 2.000000, 2.000000);

	vgpwl->l_flag = vget_float(fid, prompt_flag,
	"-l", l_pstr, &(vgpwl->l_float),
	0.000000, 0.000000, 0.000000);

	vgpwl->m_flag = vget_float(fid, prompt_flag,
	"-m", m_pstr, &(vgpwl->m_float),
	1.000000, 0.000000, 0.000000);

	vgpwl->xp_flag = vget_float(fid, prompt_flag,
	"-xp", xp_pstr, &(vgpwl->xp_float),
	1.000000, 2.000000, 2.000000);

	vgpwl->yp_flag = vget_float(fid, prompt_flag,
	"-yp", yp_pstr, &(vgpwl->yp_float),
	1.000000, 2.000000, 2.000000);

	vgpwl->xr_flag = vget_float(fid, prompt_flag,
	"-xr", xr_pstr, &(vgpwl->xr_float),
	0.000000, 1.000000, 1.000000);

	vgpwl->yr_flag = vget_float(fid, prompt_flag,
	"-yr", yr_pstr, &(vgpwl->yr_float),
	0.000000, 1.000000, 1.000000);

	vgpwl->xf_flag = vget_float(fid, prompt_flag,
	"-xf", xf_pstr, &(vgpwl->xf_float),
	0.000000, 1.000000, 1.000000);

	vgpwl->yf_flag = vget_float(fid, prompt_flag,
	"-yf", yf_pstr, &(vgpwl->yf_float),
	0.000000, 1.000000, 1.000000);

	vgpwl->xw_flag = vget_float(fid, prompt_flag,
	"-xw", xw_pstr, &(vgpwl->xw_float),
	0.000000, 1.000000, 1.000000);

	vgpwl->yw_flag = vget_float(fid, prompt_flag,
	"-yw", yw_pstr, &(vgpwl->yw_float),
	0.000000, 1.000000, 1.000000);


	/*
	 * get optional toggles for vgpwl
	 */
	if (prompt_flag == TRUE)
	{
	    ok = FALSE;
	    while(!ok)
	    {
		vgpwl->t_flag = vget_string(fid, prompt_flag,
		"-t", t_pstr, &(vgpwl->t_toggle),
		"float");

		if (((strcmp(vgpwl->t_toggle, "float") == 0)) || 
		     ((strcmp(vgpwl->t_toggle, "complex") == 0)))
		      ok = TRUE;
		else
		{
		}
	    }
	}
	else
	{
		vgpwl->t_flag = vget_string(fid, prompt_flag,
		"-t", t_pstr, &(vgpwl->t_toggle),
		"float");

		if (((strcmp(vgpwl->t_toggle, "float") != 0)) && 
		     ((strcmp(vgpwl->t_toggle, "complex") != 0)))
		{
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
	}


}



