 /*
  * Khoros: $Id: vspatial.h,v 1.1 1991/05/10 15:47:37 khoros Exp $
  */

 /*
  * $Log: vspatial.h,v $
 * Revision 1.1  1991/05/10  15:47:37  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vspatial.h
 >>>>            Author: Charlie Gage
 >>>> Date Last Updated: Tue Mar  5 22:27:14 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vspatial_h_
#define _vspatial_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    vspatial Argument Structure
*
****************************************************************/

typedef struct _vspatial  {

/*
 *  input image filename (Required infile)
 */
char	*i_file;	/* input image filename FILENAME */
int	 i_flag;	/* input image filename FLAG */

/*
 *  output image filename (Required outfile)
 */
char	*o_file;	/* output image filename FILENAME */
int	 o_flag;	/* output image filename FLAG */

/*
 *  window width argument (Optional integer)
 */
int	 w_int; 	/* window width argument INT */
int	 w_flag;	/* window width argument FLAG */

/*
 *  window height argument (Optional integer)
 */
int	 h_int; 	/* window height argument INT */
int	 h_flag;	/* window height argument FLAG */

/*
 *  choose Mean Spatial Operator  (Optional logical)
 */
int	 m_logic;	/* choose Mean Spatial Operator  LOGIC */
int	 m_flag;  	/* choose Mean Spatial Operator  FLAG */

/*
 *  choose Variance Spatial Operator  (Optional logical)
 */
int	 v_logic;	/* choose Variance Spatial Operator  LOGIC */
int	 v_flag;  	/* choose Variance Spatial Operator  FLAG */

/*
 *  choose Contrast Spatial Operator  (Optional logical)
 */
int	 c_logic;	/* choose Contrast Spatial Operator  LOGIC */
int	 c_flag;  	/* choose Contrast Spatial Operator  FLAG */

/*
 *  choose Ang 2nd Moment Spatial Operator  (Optional logical)
 */
int	 s_logic;	/* choose Ang 2nd Moment Spatial Operator  LOGIC */
int	 s_flag;  	/* choose Ang 2nd Moment Spatial Operator  FLAG */

/*
 *  choose Entropy Spatial Operator  (Optional logical)
 */
int	 e_logic;	/* choose Entropy Spatial Operator  LOGIC */
int	 e_flag;  	/* choose Entropy Spatial Operator  FLAG */

/*
 *  choose Dispersion Spatial Operator  (Optional logical)
 */
int	 d_logic;	/* choose Dispersion Spatial Operator  LOGIC */
int	 d_flag;  	/* choose Dispersion Spatial Operator  FLAG */

}  vspatial_struct;

vspatial_struct *vspatial;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define READINPUT(image) \
    image = readimage(vspatial->i_file); \
    if(image == NULL){ \
        (void) fprintf(stderr,"vspatial: Image could not be read\\n"); \
        exit(1); \
    }

#define CHECKINPUT(program, image) \
        (void) proper_num_images(program,image,1,TRUE); \
        \
        (void) proper_map_enable(program,image,VFF_MAP_OPTIONAL,TRUE); \
        \
        (void) propertype(program, image, VFF_TYP_1_BYTE, TRUE)
/* -include_macros_end */

#endif
