 /*
  * Khoros: $Id: vpolygon.h,v 1.3 1992/03/20 23:12:33 dkhoros Exp $
  */

 /*
  * $Log: vpolygon.h,v $
 * Revision 1.3  1992/03/20  23:12:33  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vpolygon.h
 >>>>            Author: Jean-Pierre COCQUEREZ, Marc VIALA, Pascal ADAM
 >>>> Date Last Updated: Thu Mar 12 09:36:25 1992
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vpolygon_h_
#define _vpolygon_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program;	/* a pointer to the program name argv[0] */
int	ac;

/****************************************************************
*
*                    vpolygon Argument Structure
*
****************************************************************/

typedef struct _vpolygon  {

/*
 *  Edge Image (Required infile)
 */
char	*i_file;	/* Edge Image FILENAME */
int	 i_flag;	/* Edge Image FLAG */

/*
 *  Vector Image Resulting from the Polygonal Approximation (Required outfile)
 */
char	*o1_file;	/* Vector Image Resulting from the Polygonal Approximation FILENAME */
int	 o1_flag;	/* Vector Image Resulting from the Polygonal Approximation FLAG */

/*
 *  Output Image Containing the Polygonal Edge Approximation (Optional outfile)
 */
char	*o2_file;	/* Output Image Containing the Polygonal Edge Approximation FILENAME */
int	 o2_flag;	/* Output Image Containing the Polygonal Edge Approximation FLAG */

/*
 *  Minimal Length For Segment Extraction (Optional integer)
 */
int	 l_int; 	/* Minimal Length For Segment Extraction INT */
int	 l_flag;	/* Minimal Length For Segment Extraction FLAG */

/*
 *  Percentage of Segment Rejected (Optional float)
 */
float	 p_float;	/* Percentage of Segment Rejected FLOAT */
int	 p_flag;   	/* Percentage of Segment Rejected FLAG */

/*
 *  Threshold Value for the Approximation (Optional float)
 */
float	 t_float;	/* Threshold Value for the Approximation FLOAT */
int	 t_flag;   	/* Threshold Value for the Approximation FLAG */

}  vpolygon_struct;

vpolygon_struct *vpolygon;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define READINPUT(image, file_name) \
    image = readimage(file_name); \
    if(image == NULL){ \
        (void) fprintf(stderr,"vploy1: Image could not be read...\n"); \
        exit(1); \
    }

#define SAVEOUTPUT( image,file_name)\
        if (writeimage(file_name, image) == 0 )\
        {\
           (void)fprintf(stderr,"vpolygon: Can't write segment_image...\n");\
           exit(1);\
        }
/* -include_macros_end */

#endif
