 /*
  * Khoros: $Id: band2vect.c,v 1.1 1991/05/10 15:46:47 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: band2vect.c,v 1.1 1991/05/10 15:46:47 khoros Exp $";
#endif

 /*
  * $Log: band2vect.c,v $
 * Revision 1.1  1991/05/10  15:46:47  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: band2vect.c
 >>>>
 >>>>      Program Name: band2vect
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	reformats data stored in image format to a  single-row  file
 >>>>	where each column represents a separate vector in the output
 >>>>	file.
 >>>>	
 >>>>	
 >>>>            Author: Charlie Gage
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:22:36 1991
 >>>>
 >>>>          Routines: main- the main program for band2vect
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "band2vect.h"


/****************************************************************
 *
 * Routine Name:  main program for band2vect
 *
 *       Input:  
 *           -i  input data file 
 *           -o  output (vector) file 
 *
 *
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage  *image,         /* input/output image */
                *readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if (check_args())
{
  fprintf(stderr, "%s: Illegal arguments on command line.\n", program);
  exit(1);
}
READIMAGE(image);
CHECKTYPE(program, image);
CHECKINPUT(program, image);

if ((image->num_data_bands > 1) && (image->map_scheme == VFF_MS_ONEPERBAND) && ((image->map_enable == VFF_MAP_OPTIONAL) || (image->map_enable == VFF_MAP_FORCE) ))
{
  fprintf(stderr,"%s: MUST remove map or map data through the map before using this routine.\n", program);
}

if ((image->map_scheme == VFF_MS_CYCLE) || (image->map_scheme == VFF_MS_GROUP))
{
  fprintf(stderr,"%s: will not work with map_scheme of MS_CYCLE or MS_GROUP\n", program);
}
/* -main_before_lib_call_end */

/* -main_library_call */
 if(! lband2vect (image) )
 {
   (void) fprintf(stderr, "lband2vect Failed\n");
   exit(1);
 }
/* -main_library_call_end */

/* -main_after_lib_call */
    writeimage(band2vect->o_file, image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for band2vect 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "band2vect :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\treformats data stored in image format to a  single-row  file\n");
	fprintf(stderr, "\twhere each column represents a separate vector in the output\n");
	fprintf(stderr, "\tfile.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input data file  (infile)\n");
	fprintf(stderr,"\t-o  output (vector) file  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for band2vect\n");
	fprintf(stderr, "\t[-U] Gives the usage for band2vect\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called band2vect.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses band2vect.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for band2vect
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input data file \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) output (vector) file \n        {outfile}: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "band2vect", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "band2vect.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "band2vect: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "band2vect.ans");
		}

	     }

	}

	/*
	 * allocate the band2vect structure
	 */
	band2vect = (band2vect_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (band2vect_struct));

	/*
	 * get required arguments for band2vect
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(band2vect->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(band2vect->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(band2vect->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    band2vect->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(band2vect->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(band2vect->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(band2vect->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(band2vect->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    band2vect->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(band2vect->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}


}



