 /*
  * Khoros: $Id: vcluv.h,v 1.1 1991/05/10 15:46:29 khoros Exp $
  */

 /*
  * $Log: vcluv.h,v $
 * Revision 1.1  1991/05/10  15:46:29  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vcluv.h
 >>>>            Author: Tom Sauer
 >>>> Date Last Updated: Tue Mar  5 22:21:49 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vcluv_h_
#define _vcluv_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    vcluv Argument Structure
*
****************************************************************/

typedef struct _vcluv  {

/*
 *  input image filename (Required infile)
 */
char	*i_file;	/* input image filename FILENAME */
int	 i_flag;	/* input image filename FLAG */

/*
 *  output image filename (Required outfile)
 */
char	*o_file;	/* output image filename FILENAME */
int	 o_flag;	/* output image filename FLAG */

/*
 *  normalization factor (Optional float)
 */
float	 n_float;	/* normalization factor FLOAT */
int	 n_flag;   	/* normalization factor FLAG */

}  vcluv_struct;

vcluv_struct *vcluv;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define READINPUT(img1) \
img1 = readimage(vcluv->i_file); \
if (img1 == NULL) { \
   (void) fprintf(stderr, "vcluv: Can not read input image 1\\n"); \
   exit(1);  /* Quit if bad image */ \
}
#define CHECKINPUT(program, img1) \
    propertype(program,img1,VFF_TYP_FLOAT,TRUE); \
    proper_num_images(program,img1,1,TRUE); \
    proper_num_bands(program,img1,3,TRUE); \
    proper_map_enable(program,img1,VFF_MAP_OPTIONAL,TRUE);

#define CHECKMODEL(program, img1,vcluv) \
        if (! (proper_color_model(program,img1,VFF_CM_ntscRGB,FALSE)) && \
           (! (proper_color_model(program,img1,VFF_CM_genericRGB,FALSE))) && \
           (! (proper_color_model(program,img1,VFF_CM_ntscYIQ,FALSE))) && \
           (! (proper_color_model(program,img1,VFF_CM_ntscCMY,FALSE))) && \
           (! (proper_color_model(program,img1,VFF_CM_GENERIC,FALSE))) && \
           (! (proper_color_model(program,img1,VFF_CM_cieXYZ,FALSE))) && \
           (! (proper_color_model(program,img1,VFF_CM_cieUVW,FALSE)))) { \
           (void)fprintf(stderr,"vcluv: input image must be "); \
           (void)fprintf(stderr,"either genericRGB, ntscRGB\\n"); \
           (void)fprintf(stderr,"ntscYIQ, ntscCMY"); \
           (void)fprintf(stderr,"cieUVW, or GENERIC\\n"); \
            exit(1); \
         } \
/* -include_macros_end */

#endif
