 /*
  * Khoros: $Id: vdiv.c,v 1.2 1991/12/18 09:34:45 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vdiv.c,v 1.2 1991/12/18 09:34:45 dkhoros Exp $";
#endif

 /*
  * $Log: vdiv.c,v $
 * Revision 1.2  1991/12/18  09:34:45  dkhoros
 * HellPatch3
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vdiv.c
 >>>>
 >>>>      Program Name: vdiv
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Divide two images pixel by pixel.
 >>>>	
 >>>>	

 >>>>            Author: Scott Wilson
 >>>>
 >>>> Date Last Updated: Sat Nov 23 23:50:43 1991
 >>>>
 >>>>          Routines: main- the main program for vdiv
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vdiv.h"


/****************************************************************
 *
 * Routine Name:  main program for vdiv
 *
 *       Input:  
 *      -i1  first input image 
 *      -i2  second input image 
 *      -o  resulting output image 
 *
 *
 *      [-m] division operation masking image
 *      [-j] Complex arithmetic [True] Scalar [False]
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
    struct xvimage *img1, *img2, *img3, *images[3], *readimage();
    int  num_images, up_type;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
    if (check_args()) exit(1);

    num_images = 0;                 /* initialize image counter */

    img1 = readimage(vdiv->i1_file);
    if (img1 == NULL)
        exit(1);                   /* Quit if bad image */
    images[num_images++] = img1;

    img2 = readimage(vdiv->i2_file);
    if (img2 == NULL)
        exit(1);                   /* Quit if bad image */
    images[num_images++] = img2;

    if (vdiv->m_flag)
    {
       img3 = readimage(vdiv->m_file);
       images[num_images++] = img3;
    }

    if (vdiv->m_flag && (img3 == NULL)) exit(1);       /* Quit if bad image */

    CHECKINPUT(program, img1, img2); /* verify input images */

    if(vdiv->m_flag){
        MATCHINPUT(program, img1, img3); /* verify input images */
    }

   up_type = -1;    /* call lvcast with auto upconvert */

                    /*  Call lvcast to upconvert data types */
    if (! lvcast(images, num_images, up_type) )
    {
      (void) fprintf(stderr, "ERROR: images could not be cast to the same type\n");
      exit(1);
    }

/* -main_before_lib_call_end */

/* -main_library_call */
    if(! lvdiv(img1,img2,img3,vdiv->m_flag,vdiv->j_logic) )
    {
        (void) fprintf(stderr, "lvdiv Failed\n");
        exit(1);
    }
/* -main_library_call_end */

/* -main_after_lib_call */
    writeimage(vdiv->o_file,img1);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vdiv 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vdiv :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tDivide two images pixel by pixel.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
        fprintf (stderr, "\ti1 is divided by i2\n\n");
/* -usage_additions_end */

	fprintf(stderr,"\t-i1  first input image  (infile)\n");
	fprintf(stderr,"\t-i2  second input image  (infile)\n");
	fprintf(stderr,"\t-o  resulting output image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-m]  division operation masking image (infile) [null]\n");
	fprintf(stderr,"\t[-j]  Complex arithmetic [True] Scalar [False] (boolean) [true]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vdiv\n");
	fprintf(stderr, "\t[-U] Gives the usage for vdiv\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vdiv.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vdiv.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vdiv
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i1_pstr = 
	"\nEnter: (i1) first input image \n        {infile}: "; 
char	*i2_pstr = 
	"\nEnter: (i2) second input image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output image \n        {outfile}: "; 
char	*m_pstr = 
	"\nEnter: (m) division operation masking image \n        {infile}: "; 
char	*j_pstr = 
	"\nEnter: (j) Complex arithmetic [True] Scalar [False] \n        {boolean, (y/n)  [yes] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vdiv", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vdiv.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vdiv: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vdiv.ans");
		}

	     }

	}

	/*
	 * allocate the vdiv structure
	 */
	vdiv = (vdiv_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vdiv_struct));

	/*
	 * get required arguments for vdiv
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vdiv->i1_flag = vget_infile(fid, prompt_flag,
			"-i1", i1_pstr, &(vdiv->i1_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vdiv->i1_flag))
		{
		    fprintf(stderr, "\t\ti1 is required, please re-enter: \n");
		    vdiv->i1_flag = vget_infile(fid, prompt_flag,
		    "-i1", i1_pstr, &(vdiv->i1_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i1' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vdiv->i2_flag = vget_infile(fid, prompt_flag,
			"-i2", i2_pstr, &(vdiv->i2_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vdiv->i2_flag))
		{
		    fprintf(stderr, "\t\ti2 is required, please re-enter: \n");
		    vdiv->i2_flag = vget_infile(fid, prompt_flag,
		    "-i2", i2_pstr, &(vdiv->i2_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i2' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vdiv->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vdiv->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vdiv->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vdiv->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vdiv->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vdiv
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vdiv->m_flag = vget_infile(fid, prompt_flag,
	"-m", m_pstr, &(vdiv->m_file))
;

	vdiv->j_flag = vget_logic(fid, prompt_flag,
	"-j", j_pstr, &(vdiv->j_logic), 1);


}



