 /*
  * Khoros: $Id: lvxor.c,v 1.1 1991/05/10 15:41:54 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvxor.c,v 1.1 1991/05/10 15:41:54 khoros Exp $";
#endif

 /*
  * $Log: lvxor.c,v $
 * Revision 1.1  1991/05/10  15:41:54  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvxor.c
 >>>>
 >>>>      Program Name: vxor
 >>>>
 >>>> Date Last Updated: Wed Mar 27 23:56:05 1991 
 >>>>
 >>>>          Routines: lvxor - the library call for vxor
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvxor - library call for vxor
*
* Purpose:
*    
*    Exclusive OR two images pixel by pixel.
*    
*    
* Input:
*    
*         1. img1 -- first xvimage structure
*         2. img2 -- second xvimage structure
*    
*         The inputs must be of the same data type and size.
*    
*    
* Output:
*    
*         1. img1 -- output xvimage structure
*    
*         img1 is used for both the input xvimage  structure  and  the
*         output  result  xvimage  structure.   This  is  done to save
*         space, but you must be careful not  to  overwrite  important
*         data.
*    
*         lvxor returns one upon success and zero on failure.
*    
*    
*
* Written By: Scott Wilson
*    
*    Marcelo Teran, John Rasure
*    
*    
****************************************************************/


/* -library_def */
int
lvxor(img1,img2)
struct xvimage *img1, *img2;
/* -library_def_end */

/* -library_code */
{
    int    j, k;
    int    *i1, *i2;
    short  *s1, *s2;
    float  *f1, *f2;
    unsigned char *c1, *c2;

          /* Normal operation count */
    k = img1->row_size*img1->col_size * img1->num_data_bands;
    switch (img1->data_storage_type)
      {
        case VFF_TYP_BIT :
          c1 = (unsigned char *)(img1->imagedata);
          c2 = (unsigned char *)(img2->imagedata);
          k = (img1->row_size+7)/8;
          for (j=0; j<k*img1->col_size; j++)
            {
              *c1 = *c1 ^ *c2;
              c1++; c2++;
            }
          break;
        case VFF_TYP_1_BYTE : 
          c1 = (unsigned char *)(img1->imagedata);
          c2 = (unsigned char *)(img2->imagedata);
          for (j=0; j<k; j++)
            {
              if (*c1 != 0 && *c2 != 0 ) *c1 = 0;
              else if (*c1 == 0 && *c2 != 0 ) *c1 = *c2;
              c1++; c2++;
            }
          break;
        case VFF_TYP_2_BYTE :
          s1 = (short *)(img1->imagedata);
          s2 = (short *)(img2->imagedata);
          for (j=0; j<k; j++)
            {
              if (*s1 != 0 && *s2 != 0 ) *s1 = 0;
               else if (*s1 == 0 && *s2 != 0 ) *s1 = *s2;
              s1++; s2++;
            }
          break;
        case VFF_TYP_4_BYTE :
          i1 = (int *)(img1->imagedata);
          i2 = (int *)(img2->imagedata);
          for (j=0; j<k; j++)
            {
              if (*i1 != 0 && *i2 != 0 ) *i1 = 0;
              else if (*i1 == 0 && *i2 != 0 ) *i1 = *i2;
              i1++; i2++;
            }
          break;
        case VFF_TYP_FLOAT :
          f1 = (float *)(img1->imagedata);
          f2 = (float *)(img2->imagedata);
          for (j=0; j<k; j++)
            {
              if (*f1 != 0 && *f2 != 0 ) *f1 = 0;
              else if (*f1 == 0 && *f2 != 0 ) *f1 = *f2;
              f1++; f2++;
            }
          break;
        case VFF_TYP_COMPLEX :
          f1 = (float *)(img1->imagedata);
          f2 = (float *)(img2->imagedata);
          for (j=0; j<k; j++)
            {
              if (*f1 != 0 && *f2 != 0 ) 
                {
                  *f1 = 0.0; *(f1+1) = 0.0;
                }
              else if (*f1 == 0 && *f2 != 0 )
                {
                  *f1 = *f2; *(f1+1) = *(f2+1);
                }
              f1 += 2; f2 += 2;
            }
          break;
        default:
          fprintf(stderr,"lvxor: Unknown data storage type, %d\n",img1->data_storage_type);
          return(0);
          break;
      }
      return(1);
}
/* -library_code_end */
