 /*
  * Khoros: $Id: lvprdata.c,v 1.1 1991/05/10 15:41:54 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvprdata.c,v 1.1 1991/05/10 15:41:54 khoros Exp $";
#endif

 /*
  * $Log: lvprdata.c,v $
 * Revision 1.1  1991/05/10  15:41:54  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvprdata.c
 >>>>
 >>>>      Program Name: vprdata
 >>>>
 >>>> Date Last Updated: Mon May  6 08:44:57 1991 
 >>>>
 >>>>          Routines: lvprdata - the library call for vprdata
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvprdata - library call for vprdata
*
* Purpose:
*    
*    vprdata prints image data to a file or the screen  in  ascii
*    format.
*    
*    
* Input:
*    
*         img - input xvimage structure
*    
*         matflg - print image as a matrix (if set to one) else  print
*         image as a single column.
*    
*         input_file - name of file getting data on.
*    
*    
* Output:
*    
*    printdev - data is printed in ascii format to the screen  or
*    a file according to printdev.
*    
*    
*
* Written By: Mark Young, Tom Sauer, John Rasure
*    
*    Scott Wilson  27-Jan-91 - Removed FFT data type processing.
*    
*    Jeremy Worley 11-Jan-91 - Added support  for  double  and  double
*    complex.
*    
*    
****************************************************************/


/* -library_def */
int
lvprdata(img,matflg,input_file,printdev)
struct  xvimage *img;
int     matflg;
char    *input_file;
FILE    *printdev;
/* -library_def_end */

/* -library_code */
{
void printbyte(), 
     printshort(), 
     printint(), 
     printfloat(),
     printcomplex(),
     printdouble(),
     printdcomplex(),
     printlocation();


/*  Print out the row and column size information */

        (void) fprintf(printdev,"\nXVIFF File name: %s.\n",input_file);
        (void) fprintf(printdev,"\nImage data size, type and values.\n");
        (void) fprintf(printdev,"\n---------------------------------\n");
        (void) fprintf(printdev,"Number of Columns(row_size) = %d\n",img->row_size);
        (void) fprintf(printdev,"Number of Rows(col_size) = %d\n",img->col_size);
        (void) fprintf(printdev,"Number of Bands(num_data_bands) = %d\n",img->num_data_bands);

/* print out a message describing the storage type and call the
   appropriate routine to print the kernel elements */

        switch(img->data_storage_type) {
        case VFF_TYP_BIT:
                (void) fprintf(printdev,"\nlvprdata: Unable to print data values for BIT images\n");
                break;
        case VFF_TYP_1_BYTE:       /* pixels are byte (unsigned char) */
                (void) fprintf(printdev,"Image type is BYTE (unsigned char)\n");
                printbyte(img,matflg,printdev);
                break;
        case VFF_TYP_2_BYTE:       /* pixels are two byte (short int) */
                (void) fprintf(printdev,"Image type is 2_BYTE (short integer)\n");
                printshort(img,matflg,printdev);
                break;
        case VFF_TYP_4_BYTE:       /* pixels are four byte (integer) */
                (void) fprintf(printdev,"Image type is 4_BYTE (integer)\n");
                printint(img,matflg,printdev);
                break;
        case VFF_TYP_FLOAT:        /* pixels are float (DEC single)  */
                (void) fprintf(printdev,"Image type is FLOAT (float)\n");
                printfloat(img,matflg,printdev);
                break;
        case VFF_TYP_COMPLEX:      /* pixels are complex float       */
                (void) fprintf(printdev,"Image type is COMPLEX (float pairs)\n");
                printcomplex(img,matflg,printdev);
                break;
        case VFF_TYP_DOUBLE:        /* pixels are double */
                (void) fprintf(printdev,"Image type is DOUBLE (float)\n");
                printdouble(img,matflg,printdev);
                break;
        case VFF_TYP_DCOMPLEX:        /* pixels are double complex   */
                (void) fprintf(printdev,"Image type is DOUBLE COMPLEX.\n");
                printdcomplex(img,matflg,printdev);
                break;
        default:
                (void) fprintf(printdev,"Unknown storage type for this image\n");
                return(0);
                break;
        } /* end switch */

        /*
         *  Check to see if the image contains any location data.  We know
         *  there is location data if the image is of type explicit, otherwise
         *  the image an implicit.
         */
        if (img->location_type == VFF_LOC_EXPLICIT)
           printlocation(img,matflg,printdev);

        (void) fprintf(printdev,"\n");
        return(1);  /* success */

}

/**************************************************************
*
* MODULE NAME: printbyte
*
*     PURPOSE: print out byte information
*
*       INPUT:
*             img - input xvimage structure
*             matflg - print image as a matrix (if set to one)
*                     else print image as a single column.
*
*      OUTPUT: 
*             data is printed in ascii format to the screen.
*             The stdout can be redirected into a file.
*
* CALLED FROM: lvprdata
*
* ROUTINES CALLED: 
*
**************************************************************/

void printbyte(img, matflg, printdev)
struct xvimage *img;
int matflg;
FILE *printdev;
{
        unsigned char *data;
        int i,row, col;

        data = (unsigned char *) img->imagedata;

        if (matflg)     /* if matflg = 1 then format as a matrix */
        {
          for (i = 0; i < img->num_data_bands; i++)
          {
             (void) fprintf(printdev,"\n\nDATA BAND #%d\n",i);
             for (row = 0; row < img->col_size; row++) 
             {
                 (void) fprintf(printdev,"\n");
                 for (col = 0; col < img->row_size; col++)
                     (void) fprintf(printdev,"[%d][%d] = %d     ", row, col, *data++);
              }
          }
        }
        else        /* if matflg = 0 then format as a single column */
        {
          for (i = 0; i < img->num_data_bands; i++)
          {
            (void) fprintf(printdev,"\n\nDATA BAND #%d\n",i);
            for (row = 0; row < img->col_size; row++)
                for (col = 0; col < img->row_size; col++)
                    (void) fprintf(printdev,"image[%d][%d] = %d\n", row, col, *data++);
          }
        } 

}

/**************************************************************
*
* MODULE NAME: printshort
*
*     PURPOSE: print out short integer information
*
*       INPUT:
*             img - input xvimage structure
*             matflg - print image as a matrix (if set to one)
*                     else print image as a single column.
*
*      OUTPUT: 
*             data is printed in ascii format to the screen.
*             The stdout can be redirected into a file.
*
* CALLED FROM: lvprdata
*
* ROUTINES CALLED: 
*
**************************************************************/

void printshort(img, matflg, printdev)
struct xvimage *img;
int matflg;
FILE *printdev;
{
        short *data;
        int i,row, col;

        data = (short *) img->imagedata;

        if (matflg)     /* if matflg = 1 then format as a matrix */
        {
          for (i = 0; i < img->num_data_bands; i++)
          {
             (void) fprintf(printdev,"\n\nDATA BAND #%d\n",i);
             for (row = 0; row < img->col_size; row++) {
                 (void) fprintf(printdev,"\n");
                 for (col = 0; col < img->row_size; col++)
                     (void) fprintf(printdev,"[%d][%d] = %d     ", row, col, *data++);
             }
          }
        }
        else            /* if matflg = 0 then format as a single column */
        {
          for (i = 0; i < img->num_data_bands; i++)
          {
             (void) fprintf(printdev,"\n\nDATA BAND #%d\n",i);
               for (row = 0; row < img->col_size; row++)
                for (col = 0; col < img->row_size; col++)
                     (void) fprintf(printdev,"image[%d][%d] = %d\n", row, col, *data++);
          }
        }

}

/**************************************************************
*
* MODULE NAME: printint
*
*     PURPOSE: print out integer information
*
*       INPUT:
*             img - input xvimage structure
*             matflg - print image as a matrix (if set to one)
*                     else print image as a single column.
*
*      OUTPUT: 
*             data is printed in ascii format to the screen.
*             The stdout can be redirected into a file.
*
* CALLED FROM: lvprdata
*
* ROUTINES CALLED: 
*
**************************************************************/


void printint(img, matflg, printdev)
struct xvimage *img;
int matflg;
FILE *printdev;
{
        int *data;
        int i,row, col;

        data = (int *) img->imagedata;

        if (matflg)     /* if matflg = 1 then format as a matrix */
        {
          for (i = 0; i < img->num_data_bands; i++)
          {
             (void) fprintf(printdev,"\n\nDATA BAND #%d\n",i);
             for (row = 0; row < img->col_size; row++) {
                 (void) fprintf(printdev,"\n");
                 for (col = 0; col < img->row_size; col++)
                     (void) fprintf(printdev,"[%d][%d] = %d     ", row, col, *data++);
             }
          }
        }
        else            /* if matflg = 0 then format as a single column */
        {
          for (i = 0; i < img->num_data_bands; i++)
          {
             (void) fprintf(printdev,"\n\nDATA BAND #%d\n",i);
               for (row = 0; row < img->col_size; row++)
                for (col = 0; col < img->row_size; col++)
                     (void) fprintf(printdev,"image[%d][%d] = %d\n", row, col, *data++);
           }
        }

}

/**************************************************************
*
* MODULE NAME: fprintfloat
*
*     PURPOSE: print out float information
*
*       INPUT:
*             img - input xvimage structure
*             matflg - print image as a matrix (if set to one)
*                     else print image as a single column.
*
*      OUTPUT: 
*             data is printed in ascii format to the screen.
*             The stdout can be redirected into a file.
*
* CALLED FROM: lvprdata
*
* ROUTINES CALLED: 
*
**************************************************************/

void printfloat(img, matflg, printdev)
struct xvimage *img;
int matflg;
FILE *printdev;
{
        float *data;
        int i,row, col;

        data = (float *) img->imagedata;

        if (matflg)     /* if matflg = 1 then format as a matrix */
        {
          for (i = 0; i < img->num_data_bands; i++)
          {
             (void) fprintf(printdev,"\n\nDATA BAND #%d\n",i);
             for (row = 0; row < img->col_size; row++) 
             {
                 (void) fprintf(printdev,"\n");
                 for (col = 0; col < img->row_size; col++)
                     (void) fprintf(printdev,"[%d][%d] = %g     ", row, col, *data++);
             }
           }
        }
        else      /* if matflg = 0 then format as a single column */
        {
          for (i = 0; i < img->num_data_bands; i++)
          {
             (void) fprintf(printdev,"\n\nDATA BAND #%d\n",i);
              for (row = 0; row < img->col_size; row++)
                  for (col = 0; col < img->row_size; col++)
                      (void) fprintf(printdev,"image[%d][%d] = %g\n", row, col, *data++);
          }
        }

}

/**************************************************************
*
* MODULE NAME: printcomplex
*
*     PURPOSE: print out complex information
*
*       INPUT:
*             img - input xvimage structure
*             matflg - print image as a matrix (if set to one)
*                     else print image as a single column.
*
*      OUTPUT: 
*             data is printed in ascii format to the screen.
*             The stdout can be redirected into a file.
*
* CALLED FROM: lvprdata
*
* ROUTINES CALLED: 
*
**************************************************************/

void printcomplex(img, matflg, printdev)
struct xvimage *img;
int matflg;
FILE *printdev;
{
        float *data;
        int i,row, col;

        data = (float *) img->imagedata;

        if (matflg) (void) fprintf(stderr,
                      "Can not print complex data in matrix format\n");

            else {
              for (i = 0; i < img->num_data_bands; i++)
              {
                 (void) fprintf(printdev,"\n\nDATA BAND #%d\n",i);
                 for (row = 0; row < img->col_size; row++)
                    for (col = 0; col < img->row_size; col++) {
                        (void) fprintf(printdev,"real[%d][%d] = %g\n", row, col, *data++);
                        (void) fprintf(printdev,"imag[%d][%d] = %g\n", row, col, *data++);
                    }
                }
            }
}

/**************************************************************
*
* MODULE NAME: fprintfloat
*
*     PURPOSE: print out float information
*
*       INPUT:
*             img - input xvimage structure
*             matflg - print image as a matrix (if set to one)
*                     else print image as a single column.
*
*      OUTPUT: 
*             data is printed in ascii format to the screen.
*             The stdout can be redirected into a file.
*
* CALLED FROM: lvprdata
*
* ROUTINES CALLED: 
*
**************************************************************/

void printdouble(img, matflg, printdev)
struct xvimage *img;
int matflg;
FILE *printdev;
{
        double *data;
        int i,row, col;

        data = (double *) img->imagedata;

        if (matflg)     /* if matflg = 1 then format as a matrix */
        {
          for (i = 0; i < img->num_data_bands; i++)
          {
             (void) fprintf(printdev,"\n\nDATA BAND #%d\n",i);
             for (row = 0; row < img->col_size; row++) 
             {
                 (void) fprintf(printdev,"\n");
                 for (col = 0; col < img->row_size; col++)
                     (void) fprintf(printdev,"[%d][%d] = %g     ", row, col, *data++);
             }
           }
        }
        else      /* if matflg = 0 then format as a single column */
        {
          for (i = 0; i < img->num_data_bands; i++)
          {
             (void) fprintf(printdev,"\n\nDATA BAND #%d\n",i);
              for (row = 0; row < img->col_size; row++)
                  for (col = 0; col < img->row_size; col++)
                      (void) fprintf(printdev,"image[%d][%d] = %g\n", row, col, *data++);
          }
        }

}

/**************************************************************
*
* MODULE NAME: printcomplex
*
*     PURPOSE: print out complex information
*
*       INPUT:
*             img - input xvimage structure
*             matflg - print image as a matrix (if set to one)
*                     else print image as a single column.
*
*      OUTPUT: 
*             data is printed in ascii format to the screen.
*             The stdout can be redirected into a file.
*
* CALLED FROM: lvprdata
*
* ROUTINES CALLED: 
*
**************************************************************/

void printdcomplex(img, matflg, printdev)
struct xvimage *img;
int matflg;
FILE *printdev;
{
        double *data;
        int i,row, col;

        data = (double *) img->imagedata;

        if (matflg) (void) fprintf(stderr,
                      "Can not print complex data in matrix format\n");

            else {
              for (i = 0; i < img->num_data_bands; i++)
              {
                 (void) fprintf(printdev,"\n\nDATA BAND #%d\n",i);
                 for (row = 0; row < img->col_size; row++)
                    for (col = 0; col < img->row_size; col++) {
                        (void) fprintf(printdev,"real[%d][%d] = %g\n", row, col, *data++);
                        (void) fprintf(printdev,"imag[%d][%d] = %g\n", row, col, *data++);
                    }
                }
            }
}

/**************************************************************
*
* MODULE NAME: printlocation
*
*     PURPOSE: print out location data bands which are stored
*              as float information
*
*       INPUT:
*             img - input xvimage structure
*             matflg - print image as a matrix (if set to one)
*                     else print image as a single column.
*
*      OUTPUT: 
*             data is printed in ascii format to the screen.
*             The stdout can be redirected into a file.
*
* CALLED FROM: lvprdata
*
* ROUTINES CALLED: 
*
**************************************************************/

void printlocation(img, matflg, printdev)

struct  xvimage *img;
int     matflg;
FILE *printdev;
{
        float *data;
        int i,row, col;

        data = (float *) img->location;

        if (matflg)     /* if matflg = 1 then format as a matrix */
        {
          for (i = 0; i < img->location_dim; i++)
          {
             (void) fprintf(printdev,"\n\nLOCATION BAND #%d\n",i+1);
             for (row = 0; row < img->col_size; row++) 
             {
                 (void) fprintf(printdev,"\n");
                 for (col = 0; col < img->row_size; col++)
                     (void) fprintf(printdev,"[%d][%d] = %g     ", row, col, *data++);
             }
           }
        }
        else      /* if matflg = 0 then format as a single column */
        {
          for (i = 0; i < img->num_data_bands; i++)
          {
             (void) fprintf(printdev,"\n\nLOCATION BAND #%d\n",i+1);
              for (row = 0; row < img->col_size; row++)
                  for (col = 0; col < img->row_size; col++)
                      (void) fprintf(printdev,"location[%d][%d] = %g\n", row, col, *data++);
          }
        }

}
/* -library_code_end */
