 /*
  * Khoros: $Id: lvmpp.c,v 1.2 1992/03/20 23:06:57 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lvmpp.c,v 1.2 1992/03/20 23:06:57 dkhoros Exp $";
#endif

 /*
  * $Log: lvmpp.c,v $
 * Revision 1.2  1992/03/20  23:06:57  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvmpp.c
 >>>>
 >>>>      Program Name: vmpp
 >>>>
 >>>> Date Last Updated: Mon Mar  9 18:45:48 1992 
 >>>>
 >>>>          Routines: lvmpp - the library call for vmpp
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvmpp - library call for vmpp
*
* Purpose:
*    
*    Compute 2-dimensional information from COMPLEX images
*    
*    

* Input:
*    
*    image          is a pointer to the xvimage structure used as  the
*                   input image
*    
*    k              selects the information type:
*    
*                             1 - Magnitude
*                             2 - Log(magnitude+1.0)
*                             3 - Power
*                             4 - Log(power+1.0)
*                             5 - Phase
*    
*    

* Output:
*    
*    Return Value:  1 on success, 0 on failure
*    
*    

*
* Written By: Scott Wilson
*    
*    Tue Aug 28 10:51:38 MDT 1990 Shirley Lee
*                                  Changed vspectra and  lvspectra  to
*                                  vmpp and lvmpp.
*    
*    Scott Wilson 27-Jan-91 - Removed FFT data type processing.
*    
*    

****************************************************************/


/* -library_def */
int
lvmpp(image,k)
struct xvimage *image;
int k;
/* -library_def_end */

/* -library_code */
{
    int i,j,nr,nc,l,m;
    char *malloc();
    float *f,f1,f2;

    nr = image->col_size;
    nc = image->row_size;

    f = (float *)malloc(nr*nc*sizeof(float));
    if (f == NULL)
      {
        fprintf(stderr,"lvmpp: Unable to allocate data array\n");
        return(0);
      }
 
    if (image->data_storage_type != VFF_TYP_COMPLEX)
      {
         fprintf(stderr,"lvmpp: Image must be COMPLEX!\n");
         return(0);
      }

    l = 0;
    for (i=0; i<nr; i++)             /* Rows */
      {
        for (j=0; j<nc; j++)          /* Cols */
          {
            m = i*nc+j;
            f1 = ((float *)(image->imagedata))[l++];
            f2 = ((float *)(image->imagedata))[l++];
            switch (k)
              {
                case 1 :      /* Magnitude */
                  {
                    f[m] = vcabs(f1,f2);
                    break;
                  }
                case 2 :      /* Log.(Mag.+1) transform */
                  {
                    f[m] = log10(vcabs(f1,f2)+1.0);
                    break;
                  }
                case 3 :      /* Power */
                  {
                    f[m] = vcabs(f1,f2);
                    f[m] = f[m]*f[m];
                    break;
                  }
                case 4 :      /* Log.(Pwr.+1) transform */
                  {
                    f[m] = vcabs(f1,f2);
                    f[m] = f[m]*f[m];
                    f[m] = log10((double)f[m]+1.0);
                    break;
                  }
                case 5 :       /* Phase */
                  {
                    f[m] = cang(f1,f2);
                    break;
                  }
                default:
                  {
                    break;
                  }
              }
          }
      }

    free(image->imagedata);

    /* Set new pointers and image data */
    image->imagedata = (char *)f;
    image->data_storage_type = VFF_TYP_FLOAT;
    image->row_size = nc;
    image->col_size = nr;

    return(1);
 }
/* -library_code_end */
