 /*
  * Khoros: $Id: kdinstall.c,v 1.2 1991/10/02 00:01:33 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: kdinstall.c,v 1.2 1991/10/02 00:01:33 khoros Exp $";
#endif

 /*
  * $Log: kdinstall.c,v $
 * Revision 1.2  1991/10/02  00:01:33  khoros
 * HellPatch2
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: kdinstall.c
 >>>>
 >>>>      Program Name: kdinstall
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	A utility for de-installing existing routines from khoros.
 >>>>	
 >>>>	

 >>>>            Author: Tom Sauer and Charlie Gage
 >>>>
 >>>> Date Last Updated: Wed Sep 25 22:11:03 1991
 >>>>
 >>>>          Routines: main- the main program for kdinstall
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "kdinstall.h"


/****************************************************************
 *
 * Routine Name:  main program for kdinstall
 *
 *       Input:  
 *           -name  program name 
 *           -dest  Destination path 
 *
 *
 *           [-toolbox] input toolbox name
 *           [-force] Force option
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
char machpath[MAXPATHLEN], *force_flg, *filename, *destpath;
char *cpath, *hpath, *lpath, *man1path, *man3path, *lhpath;
char *helppath, *subhelppath, *progpath, *panepath, *topsrc;
char buffer[BUFSIZE];
char *script_file, *vexpandpath(), *vbasename();
char ans[2], temp[LENGTH];
char *config_keys[ConfigKeyNum], *config_paths[ConfigKeyNum];
char *config_file;
char *toolbox, *toolboxpath;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if (check_args()) exit(1);

/*----------------------------------------------------------------------
 *  Get the filename of the program to kdinstall
 *----------------------------------------------------------------------*/
filename = VStrcpy(kdinstall->name_string);

strcpy(temp, filename);

config_file = strcat(temp,".conf");

if ( (destpath = vfullpath(kdinstall->dest_string, NULL, NULL)) == NULL)
{
    (void)fprintf(stderr,"kdinstall: Invalid path specified for the \n");
    (void)fprintf(stderr,"destination location.\n");
    exit(0);
}

/* initialize the strings for config keys, like "cpath" */
gw_init_config_keys(config_keys);

/* read the config file into the config_paths array of strings */
if (!(gr_read_configfile(config_file, config_keys, ConfigKeyNum, config_paths)))
{
   (void) fprintf(stderr,"%s: Unable to read the config file.\n", program);
   (void) fprintf(stderr,"A valid config file MUST exist \n");
   (void) fprintf(stderr,"in the current directory.\n");
   exit(0);
}

/* Cycle through the config file and check all entries for valid paths */
if ( (config_paths[PANEPATH] == NULL) || (strcmp(config_paths[PANEPATH],"./")==0))
 {
  (void) fprintf(stderr,"Error: Invalid or missing path for \n");
  (void) fprintf(stderr,"the .pane file in the config file!\n");
  exit(0);
 }
else
 {
  if ((panepath = vexpandpath(config_paths[PANEPATH], NULL, NULL)) == NULL)
  {
    (void)fprintf(stderr,"Invalid path specified for the .pane file.\n");
    exit(0);
  }
 }

if ( (config_paths[PROGPATH] == NULL) || (strcmp(config_paths[PROGPATH],"./")==0))
{
 (void) fprintf(stderr,"Error: Invalid or missing path for \n");
 (void) fprintf(stderr,"the .prog file in the config file!\n");
 exit(0);
}
else
 {
  if ((progpath = vexpandpath(config_paths[PROGPATH], NULL, NULL)) == NULL)
  {
    (void)fprintf(stderr,"Invalid path specified for the .prog file.\n");
    exit(0);
  }
 }

if ( (config_paths[CPATH] == NULL) || (strcmp(config_paths[CPATH],"./")==0) )
{
 (void) fprintf(stderr,"Error: Invalid or missing path for \n");
 (void) fprintf(stderr,"the .c file in the config file!\n");
 exit(0);
}
else
 {
  if ((cpath = vexpandpath(config_paths[CPATH], NULL, NULL)) == NULL)
  {
    (void)fprintf(stderr,"Invalid path specified for the *.c file.\n");
    exit(0);
  }
 }

if ( (config_paths[HPATH] == NULL) || (strcmp(config_paths[HPATH],"./")==0) )
{
 (void) fprintf(stderr,"Error: Invalid or missing path for \n");
 (void) fprintf(stderr,"the .h file in the config file!\n");
 exit(0);
}
else
 {
  if ((hpath = vexpandpath(config_paths[HPATH], NULL, NULL)) == NULL)
  {
    (void)fprintf(stderr,"Invalid path specified for the *.h file.\n");
    exit(0);
  }
 }

if ( (config_paths[MAN1PATH] == NULL) || (strcmp(config_paths[MAN1PATH],"./")==0))
{
 (void) fprintf(stderr,"Error: Invalid or missing path for \n");
 (void) fprintf(stderr,"the .1 file in the config file!\n");
 exit(0);
}
else
 {
  if ((man1path = vexpandpath(config_paths[MAN1PATH], NULL, NULL)) == NULL)
  {
    (void)fprintf(stderr,"Invalid path specified for the *.man1 file.\n");
    exit(0);
  }
 }

if ( (config_paths[MAN3PATH] == NULL) || (strcmp(config_paths[MAN3PATH],"./")==0) )
{
  man3path = VStrcpy("_NULL_");
}
else
 {
  if ((man3path = vexpandpath(config_paths[MAN3PATH], NULL, NULL)) == NULL)
  {
    (void)fprintf(stderr,"Invalid path specified for the *.man3 file.\n");
    exit(0);
  }
 }

if ( (config_paths[LPATH] == NULL) || (strcmp(config_paths[LPATH],"./") == 0) )
{
  lpath = VStrcpy("_NULL_");
}
else
 {
  if ((lpath = vexpandpath(config_paths[LPATH], NULL, NULL)) == NULL)
  {
    (void)fprintf(stderr,"Invalid path specified for the l*.c file.\n");
    exit(0);
  }
 }

if ( (config_paths[HELPPATH] == NULL) || (strcmp(config_paths[HELPPATH],"./") ==0) )
{
  helppath = VStrcpy("_NULL_");
}
else
 {
  if ((helppath = vexpandpath(config_paths[HELPPATH], NULL, NULL)) == NULL)
  {
    (void)fprintf(stderr,"Invalid path specified for the help file.\n");
    exit(0);
  }
 }

if ( (config_paths[SUBHELPPATH] == NULL) || (strcmp(config_paths[SUBHELPPATH],"./") == 0) )
{
  subhelppath = VStrcpy("_NULL_");
}
else
 {
  if ((subhelppath = vexpandpath(config_paths[SUBHELPPATH], NULL, NULL)) == NULL)
  {
    (void)fprintf(stderr,"Invalid path specified for the subhelp file.\n");
    exit(0);
  }
 }

if ( (config_paths[TOPSRC] == NULL) || (strcmp(config_paths[TOPSRC],"./") == 0) )
{
  topsrc = VStrcpy("_NULL_");
}
else
 {
  if ((topsrc = vexpandpath(config_paths[TOPSRC], NULL, NULL)) == NULL)
  {
    (void)fprintf(stderr,"kdinstall: Invalid path specified for the \n");
    (void)fprintf(stderr,"topsrc parameter in the config file.\n");
    exit(0);
  }
 }

/*----------------------------------------------------------------------
 *  Get the path for the mach file, otherwise use the default_mach file 
 *----------------------------------------------------------------------*/
if (kdinstall->toolbox_flag)
{
  toolboxpath = vtoolbox_path(kdinstall->toolbox_string);
  if (toolboxpath == NULL)
  {
     fprintf(stderr, "%s:  The toolbox name '%s' is not a valid toolbox.\n",
             program, kdinstall->toolbox_string);
     exit(0);
  }
  toolbox = vlower_string(kdinstall->toolbox_string, NULL);

  sprintf(machpath, "%s/%s/%s_mf", toolboxpath, MACH_FILE_PATH, toolbox);
}
else
{
  sprintf(machpath, "_NULL_");
}

/*---------------------------------------------------------------------
 * Get the force override flag
 *--------------------------------------------------------------------*/
if ((kdinstall->force_logic) == 1)
   force_flg = "1";
else
   force_flg = "0";

/*---------------------------------------------------------------------
 *  Prompt for additional library include file
 *--------------------------------------------------------------------*/
printf("\nIf the routine to de-install has an additional library include file,");
printf("\nyou may want to enter a path to this file.");
printf("\nDo you wish to enter a path to a library include file? (y/n) ");
scanf("%s", ans);
if ( (strcmp(ans,"y") == 0) || (strcmp(ans,"Y") == 0) )
{
  printf("\nEnter the path for the library include file:");
  printf("\nPath: ");
  scanf("%s", temp);
  if ((lhpath = vexpandpath(temp, NULL, NULL)) == NULL)
  {
    (void)fprintf(stderr,"Invalid path specified for the library include file.\n");
    exit(0);
  }
}
else
{
  lhpath = VStrcpy("_NULL_");
}

/* Assign a filename to the shell script file */
script_file = "kdinstall_csh";

/* Build the buffer for the system call */
(void) sprintf(buffer,"%s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s", 
          script_file, filename, destpath, progpath, cpath, hpath, lpath, 
          lhpath, man1path, man3path, panepath, helppath, subhelppath, 
          machpath, topsrc, force_flg);

/* System off the kdinstall_csh script */
system(buffer);

/* -main_before_lib_call_end */

/* -main_library_call */
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for kdinstall 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "kdinstall :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tA utility for de-installing existing routines from khoros.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-name  program name  (string)\n");
	fprintf(stderr,"\t-dest  Destination path  (string)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-toolbox]  input toolbox name (string) [  ]\n");
	fprintf(stderr,"\t[-force]  Force option (boolean) [false]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for kdinstall\n");
	fprintf(stderr, "\t[-U] Gives the usage for kdinstall\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called kdinstall.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses kdinstall.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for kdinstall
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*name_pstr = 
	"\nEnter: (name) program name \n        {string}: "; 
char	*name_def = NULL;
char	*dest_pstr = 
	"\nEnter: (dest) Destination path \n        {string}: "; 
char	*dest_def = NULL;
char	*toolbox_pstr = 
	"\nEnter: (toolbox) input toolbox name \n        {string ['  '] }: "; 
char	*toolbox_def = "  ";
char	*force_pstr = 
	"\nEnter: (force) Force option \n        {boolean, (y/n)  [no] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "kdinstall", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "kdinstall.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "kdinstall: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "kdinstall.ans");
		}

	     }

	}

	/*
	 * allocate the kdinstall structure
	 */
	kdinstall = (kdinstall_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (kdinstall_struct));

	/*
	 * get required arguments for kdinstall
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(kdinstall->name_flag = vget_string(fid, prompt_flag,
			"-name", name_pstr, &(kdinstall->name_string),
			name_def)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(kdinstall->name_flag))
		{
		    fprintf(stderr, "\t\tname is required, please re-enter: \n");
		    kdinstall->name_flag = vget_string(fid, prompt_flag,
		    "-name", name_pstr, &(kdinstall->name_string),
		    name_def);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-name' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(kdinstall->dest_flag = vget_string(fid, prompt_flag,
			"-dest", dest_pstr, &(kdinstall->dest_string),
			dest_def)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(kdinstall->dest_flag))
		{
		    fprintf(stderr, "\t\tdest is required, please re-enter: \n");
		    kdinstall->dest_flag = vget_string(fid, prompt_flag,
		    "-dest", dest_pstr, &(kdinstall->dest_string),
		    dest_def);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-dest' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for kdinstall
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	kdinstall->toolbox_flag = vget_string(fid, prompt_flag,
	"-toolbox", toolbox_pstr, &(kdinstall->toolbox_string),
	toolbox_def);

	if (prompt_flag == FALSE)
	{
	    if ((kdinstall->toolbox_flag == 1)&&(kdinstall->toolbox_string == NULL))
    	{
		fprintf(stderr, "kdinstall:\n");
		fprintf(stderr, "you must specify a name following '-toolbox'\n");
		gw_usage();
		exit(1);
		}
	}
	kdinstall->force_flag = vget_logic(fid, prompt_flag,
	"-force", force_pstr, &(kdinstall->force_logic), 0);


}



