 /*
  * Khoros: $Id: minvert.c,v 1.2 1992/03/20 23:43:26 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: minvert.c,v 1.2 1992/03/20 23:43:26 dkhoros Exp $";
#endif

 /*
  * $Log: minvert.c,v $
 * Revision 1.2  1992/03/20  23:43:26  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: minvert.c
 >>>>
 >>>>      Program Name: minvert
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	compute the inverse of a real or complex matrix
 >>>>	
 >>>>	

 >>>>            Author: Jeremy Worley
 >>>>
 >>>> Date Last Updated: Tue Feb 25 00:54:26 1992
 >>>>
 >>>>          Routines: main- the main program for minvert
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "minvert.h"


/****************************************************************
 *
 * Routine Name:  main program for minvert
 *
 *       Input:  
 *         -i  input matrix 
 *         -o  resulting output matrix 
 *
 *
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *image,*readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
  if (check_args()) exit(1);

  if((image = readimage(minvert->i_file))==NULL){
     (void)fprintf(stderr,"%s:  failed call to readimage()\n",
             program);
     exit(1);
  }

  (void)proper_num_images(program,image,1,TRUE);

  if(image->row_size!=image->col_size){
     (void)fprintf(stderr,"%s:  matrix must be square.\n",program);
     exit(1);
  }

  if(image->row_size<=0 || image->col_size<=0){
     (void)fprintf(stderr,"%s:  matrix dimensions cannot be zero.\n",program);
     exit(1);
  }

/* -main_before_lib_call_end */

/* -main_library_call */
  if(!lminvert(image)) {
     (void)fprintf(stderr, "%s: lminvert failed\n",program);
     exit(1);
  }
/* -main_library_call_end */

/* -main_after_lib_call */
     if(!(writeimage(minvert->o_file,image))){
        (void)fprintf(stderr,"%s:  failed call to writeimage()\n",
              program);
        exit(1);
     }
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for minvert 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "minvert :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tcompute the inverse of a real or complex matrix\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input matrix  (infile)\n");
	fprintf(stderr,"\t-o  resulting output matrix  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for minvert\n");
	fprintf(stderr, "\t[-U] Gives the usage for minvert\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called minvert.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses minvert.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for minvert
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input matrix \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output matrix \n        {outfile}: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "minvert", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "minvert.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "minvert: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "minvert.ans");
		}

	     }

	}

	/*
	 * allocate the minvert structure
	 */
	minvert = (minvert_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (minvert_struct));

	/*
	 * get required arguments for minvert
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(minvert->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(minvert->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(minvert->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    minvert->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(minvert->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(minvert->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(minvert->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(minvert->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    minvert->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(minvert->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}


}



