 /*
  * Khoros: $Id: dshift.c,v 1.2 1992/03/20 23:32:48 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: dshift.c,v 1.2 1992/03/20 23:32:48 dkhoros Exp $";
#endif

 /*
  * $Log: dshift.c,v $
 * Revision 1.2  1992/03/20  23:32:48  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: dshift.c
 >>>>
 >>>>      Program Name: dshift
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Shifts or rotates 1-D signal(s)
 >>>>	
 >>>>	

 >>>>            Author: Donna Koechner
 >>>>
 >>>> Date Last Updated: Sat Feb 15 16:36:23 1992
 >>>>
 >>>>          Routines: main- the main program for dshift
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "dshift.h"


/****************************************************************
 *
 * Routine Name:  main program for dshift
 *
 *       Input:  
 *        -i  input data file 
 *        -o  resulting output file 
 *
 *
 *        [-j] Real Padding Value 
 *        [-k] Imaginary Padding Value 
 *        [-d] data processing direction (0 = down vectors, 1 = across bands)
 *        [-w] Shift or Rotate (wrap). Rotate: w=1, Shift: w=0 (default=0)
 *		0 (shift signal (w=0)),
 *		or 1 (rotate signal (w=1))
 *		   [default = 0] 
 *
 *        [-x  Positive or Negative Shifting value    -OR-
 *         -i2  Input Shifting Value File   ]
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage  *image, *s_img, *readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if (check_args())
{
  fprintf(stderr, "%s: Illegal arguments on command line.\n", program);
  exit(1);
}

READINPUT(image) ;
CHECKTYPE(program, image) ;
CHECKINPUT(program, image) ;

 /*
  * Read in the shift file image.
  */
  if (dshift->i2_flag)
  {
    s_img = readimage(dshift->i2_file);
    if(s_img == NULL)
    {
      (void)fprintf(stderr,"dshift:  Shift value file could not be read!\n");
      exit(1);
    }
    if( ! propertype(program,s_img,VFF_TYP_4_BYTE,FALSE)) { 
      (void)fprintf(stderr,"dshift: Shift value file must be VFF_TYP_4_BYTE!\n");
      exit(1);
    }
  }
  else s_img = NULL;

/* -main_before_lib_call_end */

/* -main_library_call */
  if (!(ldshift(image,            
                   s_img,               /* shift file */
                   dshift->i2_flag,     /* set if shift file given */
                   dshift->x_int,       /* constant shift value */
                   dshift->w_toggle,    /* rotate (wrap) if w = TRUE */
                   dshift->j_float,     /* real padding value */
                   dshift->k_float,     /* imaginary padding value */
                   dshift->d_logic) )) /* process direction */
  {
    (void) fprintf(stderr, "ldshift Failed\\n");
     exit(1);
  }
/* -main_library_call_end */

/* -main_after_lib_call */
(void) writeimage(dshift->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for dshift 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "dshift :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tShifts or rotates 1-D signal(s)\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input data file  (infile)\n");
	fprintf(stderr,"\t-o  resulting output file  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-j]  Real Padding Value (float) [0]\n");
	fprintf(stderr,"\t[-k]  Imaginary Padding Value (float) [0]\n");
	fprintf(stderr,"\t[-d]  data processing direction (0 = down vectors, 1 = across bands) (boolean) [true]\n");
	fprintf(stderr, "\t[-w]  Shift or Rotate (wrap). Rotate: w=1, Shift: w=0 (default=0)\n");
	fprintf(stderr, "\t\t0  (shift signal (w=0)),\n");
	fprintf(stderr, "\t\tor 1  (rotate signal (w=1))\n");
	fprintf(stderr, "\t\t[default = 0]\n");
	fprintf(stderr, "\n");	fprintf(stderr, " \n");
	fprintf(stderr, "\t[ ");
	fprintf(stderr,"-x  Positive or Negative Shifting value  (integer) -OR- \n");
	fprintf(stderr,"\t  -i2  Input Shifting Value File  (infile) ]\n\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for dshift\n");
	fprintf(stderr, "\t[-U] Gives the usage for dshift\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called dshift.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses dshift.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for dshift
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input data file \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output file \n        {outfile}: "; 
char	*j_pstr = 
	"\nEnter: (j) Real Padding Value \n        {float [0.000000] }: "; 
char	*k_pstr = 
	"\nEnter: (k) Imaginary Padding Value \n        {float [0.000000] }: "; 
char	*d_pstr = 
	"\nEnter: (d) data processing direction (0 = down vectors, 1 = across bands) \n        {boolean, (y/n)  [yes] }: "; 
char	*w_pstr = "\nEnter: (w) Shift or Rotate (wrap). Rotate: w=1, Shift: w=0 (default=0) -- \n      \t\t0 (shift signal (w=0))\n\t\tor 1 (rotate signal (w=1))\n  [0]:  "; 
char	*x_pstr = 
	"\nEnter: (x) Positive or Negative Shifting value \n        {integer [0] }: "; 
char	*i2_pstr = 
	"\nEnter: (i2) Input Shifting Value File \n        {infile}: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "dshift", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "dshift.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "dshift: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "dshift.ans");
		}

	     }

	}

	/*
	 * allocate the dshift structure
	 */
	dshift = (dshift_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (dshift_struct));

	/*
	 * get required arguments for dshift
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(dshift->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(dshift->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(dshift->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    dshift->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(dshift->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(dshift->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(dshift->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(dshift->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    dshift->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(dshift->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for dshift
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	dshift->j_flag = vget_float(fid, prompt_flag,
	"-j", j_pstr, &(dshift->j_float),
	0.000000, 0.000000, 0.000000);

	dshift->k_flag = vget_float(fid, prompt_flag,
	"-k", k_pstr, &(dshift->k_float),
	0.000000, 0.000000, 0.000000);

	dshift->d_flag = vget_logic(fid, prompt_flag,
	"-d", d_pstr, &(dshift->d_logic), 1);


	/*
	 * get optional toggles for dshift
	 */
	if (prompt_flag == TRUE)
	{
	    ok = FALSE;
	    while(!ok)
	    {
		dshift->w_flag = vget_int(fid, prompt_flag,
		"-w", w_pstr, &(dshift->w_toggle),
		0, 0, 0);

		if ((dshift->w_toggle == 0 ) || 
		    (dshift->w_toggle == 1 ))
		      ok = TRUE;
		else
		{
		}
	    }
	}
	else
	{
		dshift->w_flag = vget_int(fid, prompt_flag,
		"-w", w_pstr, &(dshift->w_toggle),
		0, 0, 0);

		if ((dshift->w_toggle != 0 ) && 
		    (dshift->w_toggle != 1 ))
		{
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
	}

	/*
	 * get optional mutually exclusive groups for dshift
	 */
	if (prompt_flag == TRUE)
	{
		   fprintf(stderr, "\nThe following prompts are mutually exclusive.\n");
		   fprintf(stderr, "\nHit <cr> until the desired prompt appears.\n");
		dshift->x_flag = vget_int(fid, prompt_flag,
		    "-x", x_pstr, &(dshift->x_int),
		    0, 0, 0);

    		if(!( (dshift->x_flag)))
		    dshift->i2_flag = vget_infile(fid, prompt_flag,
		    "-i2", i2_pstr, &(dshift->i2_file))
;

		   fprintf(stderr, "\n ------\n");
	}
	else
	{
		count = 0;
		if(dshift->x_flag = vget_int(fid, prompt_flag,
		    "-x", x_pstr, &(dshift->x_int),
		    0, 0, 0))
		    count++;

		if(dshift->i2_flag = vget_infile(fid, prompt_flag,
		    "-i2", i2_pstr, &(dshift->i2_file))
)
		    count++;

		if (count > 1)
		{
		    fprintf(stderr, "Error: You may specify ONLY ONE of :\n");
		    fprintf(stderr, " -x  -i2 \n");
		    gw_usage();
		    exit(1);
		}

	}


}



