 /*
  * Khoros: $Id: dinsert.c,v 1.2 1992/03/20 23:34:09 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: dinsert.c,v 1.2 1992/03/20 23:34:09 dkhoros Exp $";
#endif

 /*
  * $Log: dinsert.c,v $
 * Revision 1.2  1992/03/20  23:34:09  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: dinsert.c
 >>>>
 >>>>      Program Name: dinsert
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Inserts 1-D format file into another 1-D file.
 >>>>	
 >>>>	

 >>>>            Author: Donna Koechner
 >>>>
 >>>> Date Last Updated: Sat Feb 15 16:34:52 1992
 >>>>
 >>>>          Routines: main- the main program for dinsert
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "dinsert.h"


/****************************************************************
 *
 * Routine Name:  main program for dinsert
 *
 *       Input:  
 *         -i1  input image 
 *         -i2  input image 
 *         -o  resulting output image 
 *
 *
 *         [-d] data processing direction (0 = down vectors, 1 = across bands)
 *
 *         [-e  Append i2 to the end of i1   -OR-
 *          -x  Starting point where i2 is inserted into i1   (value >= 0) -OR-
 *          -i3  File which contains insert point for each vector   ]
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage  *img1, *img2, *s_img, *readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if (check_args())
{
  fprintf(stderr, "%s: Illegal arguments on command line.\n", program);
  exit(1);
}

READINPUT1(img1);
READINPUT2(img2);
CHECKTYPE(program, img1);
CHECKINPUT(program, img1, img2);

 /*
  * Read in the starting point file image.
  */
  if (dinsert->i3_flag)
  {
    s_img = readimage(dinsert->i3_file);
    if(s_img == NULL)
    {
      (void)fprintf(stderr,"dinsert: Starting point file could not be read!\n");
      exit(1);
    }
    if( ! propertype(program,s_img,VFF_TYP_4_BYTE,FALSE)) {
      (void)fprintf(stderr,"dinsert: Starting point file must be type int\n");
      exit(1);
    }
  }
  else s_img = NULL;

 /*
  * If any form of start value is specified, set append flag to zero.
  */
  if ( (dinsert->i3_flag || dinsert->x_flag)  && (!dinsert->e_flag) )
  {
    dinsert->e_logic = FALSE;
  }
/* -main_before_lib_call_end */

/* -main_library_call */
  if ( ! (ldinsert(img1,                   /* input/output image */
                   img2,                   /* image to be inserted */
                   s_img,                  /* starting point file */
                   dinsert->i3_flag,       /* flag for starting point file */
                   dinsert->x_int,         /* insert point */
                   dinsert->e_logic,       /* append to end of sequence flag */
                   dinsert->d_logic) ))   /* process direction */
  {
    (void) fprintf(stderr, "ldinsert Failed\\n");
     exit(1);
  }

/* -main_library_call_end */

/* -main_after_lib_call */
(void) writeimage(dinsert->o_file,img1);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for dinsert 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "dinsert :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tInserts 1-D format file into another 1-D file.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i1  input image  (infile)\n");
	fprintf(stderr,"\t-i2  input image  (infile)\n");
	fprintf(stderr,"\t-o  resulting output image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-d]  data processing direction (0 = down vectors, 1 = across bands) (boolean) [true]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\t[ ");
	fprintf(stderr,"-e  Append i2 to the end of i1  (boolean) -OR- \n");
	fprintf(stderr,"\t  -x  Starting point where i2 is inserted into i1  (integer, >= 0) -OR- \n");
	fprintf(stderr,"\t  -i3  File which contains insert point for each vector  (infile) ]\n\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for dinsert\n");
	fprintf(stderr, "\t[-U] Gives the usage for dinsert\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called dinsert.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses dinsert.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for dinsert
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i1_pstr = 
	"\nEnter: (i1) input image \n        {infile}: "; 
char	*i2_pstr = 
	"\nEnter: (i2) input image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output image \n        {outfile}: "; 
char	*d_pstr = 
	"\nEnter: (d) data processing direction (0 = down vectors, 1 = across bands) \n        {boolean, (y/n)  [yes] }: "; 
char	*e_pstr = 
	"\nEnter: (e) Append i2 to the end of i1 \n        {boolean, (y/n)  [yes] }: "; 
char	*x_pstr = 
	"\nEnter: (x) Starting point where i2 is inserted into i1 \n        {integer, >= 0 [0] }: "; 
char	*i3_pstr = 
	"\nEnter: (i3) File which contains insert point for each vector \n        {infile}: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "dinsert", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "dinsert.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "dinsert: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "dinsert.ans");
		}

	     }

	}

	/*
	 * allocate the dinsert structure
	 */
	dinsert = (dinsert_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (dinsert_struct));

	/*
	 * get required arguments for dinsert
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(dinsert->i1_flag = vget_infile(fid, prompt_flag,
			"-i1", i1_pstr, &(dinsert->i1_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(dinsert->i1_flag))
		{
		    fprintf(stderr, "\t\ti1 is required, please re-enter: \n");
		    dinsert->i1_flag = vget_infile(fid, prompt_flag,
		    "-i1", i1_pstr, &(dinsert->i1_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i1' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(dinsert->i2_flag = vget_infile(fid, prompt_flag,
			"-i2", i2_pstr, &(dinsert->i2_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(dinsert->i2_flag))
		{
		    fprintf(stderr, "\t\ti2 is required, please re-enter: \n");
		    dinsert->i2_flag = vget_infile(fid, prompt_flag,
		    "-i2", i2_pstr, &(dinsert->i2_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i2' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(dinsert->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(dinsert->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(dinsert->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    dinsert->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(dinsert->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for dinsert
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	dinsert->d_flag = vget_logic(fid, prompt_flag,
	"-d", d_pstr, &(dinsert->d_logic), 1);

	/*
	 * get optional mutually exclusive groups for dinsert
	 */
	if (prompt_flag == TRUE)
	{
		   fprintf(stderr, "\nThe following prompts are mutually exclusive.\n");
		   fprintf(stderr, "\nHit <cr> until the desired prompt appears.\n");
		dinsert->e_flag = vget_logic(fid, prompt_flag,
		    "-e", e_pstr, &(dinsert->e_logic), 1);

    		if(!( (dinsert->e_flag)))
		    dinsert->x_flag = vget_int(fid, prompt_flag,
		    "-x", x_pstr, &(dinsert->x_int),
		    0, 1, 1);

    		if(!( (dinsert->e_flag)|| 
		     (dinsert->x_flag)))
		    dinsert->i3_flag = vget_infile(fid, prompt_flag,
		    "-i3", i3_pstr, &(dinsert->i3_file))
;

		   fprintf(stderr, "\n ------\n");
	}
	else
	{
		count = 0;
		if(dinsert->e_flag = vget_logic(fid, prompt_flag,
		    "-e", e_pstr, &(dinsert->e_logic), 1))
		    count++;

		if(dinsert->x_flag = vget_int(fid, prompt_flag,
		    "-x", x_pstr, &(dinsert->x_int),
		    0, 1, 1))
		    count++;

		if(dinsert->i3_flag = vget_infile(fid, prompt_flag,
		    "-i3", i3_pstr, &(dinsert->i3_file))
)
		    count++;

		if (count > 1)
		{
		    fprintf(stderr, "Error: You may specify ONLY ONE of :\n");
		    fprintf(stderr, " -e  -x  -i3 \n");
		    gw_usage();
		    exit(1);
		}

	}


}



