 /*
  * Khoros: $Id: dconvo.c,v 1.2 1992/03/20 23:20:00 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: dconvo.c,v 1.2 1992/03/20 23:20:00 dkhoros Exp $";
#endif

 /*
  * $Log: dconvo.c,v $
 * Revision 1.2  1992/03/20  23:20:00  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: dconvo.c
 >>>>
 >>>>      Program Name: dconvo
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Convolution sequence of 1-D signal(s)
 >>>>	
 >>>>	

 >>>>            Author: Jeremy Worley, Ramiro Jordan
 >>>>
 >>>> Date Last Updated: Tue Feb 25 00:43:35 1992
 >>>>
 >>>>          Routines: main- the main program for dconvo
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "dconvo.h"


/****************************************************************
 *
 * Routine Name:  main program for dconvo
 *
 *       Input:  
 *        -i1  input first file (xviff file) 
 *        -i2  input second file (xviff file) 
 *        -o  resulting output file (xviff file) 
 *
 *
 *        [-j] define arithmetic on data
 *        [-d] data processing direction (0 = down vectors, 1 = across bands)
 *        [-g] type of convolution file to be created( 0 = time tomain, 1 = FFT based)
 *		0 (choose time domain convolution estimate),
 *		or 1 (choose FFT based circular convolution estimate)
 *		   [default = 0] 
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage *image1, *image2, *readimage();
int     proc_option, arith_type, process_dir;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if (check_args()) exit(1);

image1 = readimage(dconvo->i1_file);  
if (image1 == NULL) {  
   (void) fprintf(stderr, "%s: Can not read input image 1 \n",program); 
   exit(1);  /* Quit if bad image */ 
}

image2 = readimage(dconvo->i2_file);  
if (image2 == NULL) {  
   (void) fprintf(stderr, "%s: Can not read input image 2\n",program);  
   exit(1);  /* Quit if bad image */ 
}
    
if(!(propertype(program,image1,VFF_TYP_FLOAT,FALSE)) && 
   !(propertype(program,image1,VFF_TYP_COMPLEX,FALSE)) ) { 
     fprintf(stderr,"%s: [1]data storage type must be float or complex.",
             program); 
     exit(1); 
}

if(!(propertype(program,image2,VFF_TYP_FLOAT,FALSE)) && 
   !(propertype(program,image2,VFF_TYP_COMPLEX,FALSE)) ) { 
     fprintf(stderr,"%s: [2]data storage type must be float or complex.",
             program); 
     exit(1); 
}
    
proper_num_images(program,image1,1,TRUE);  
proper_map_enable(program,image1,VFF_MAP_OPTIONAL,TRUE);

proper_num_images(program,image2,1,TRUE);  
proper_map_enable(program,image2,VFF_MAP_OPTIONAL,TRUE);

arith_type = dconvo->j_logic;
proc_option = dconvo->g_toggle;
process_dir = dconvo->d_logic;
/* -main_before_lib_call_end */

/* -main_library_call */
if(! ldconvo ( image1, image2, arith_type, proc_option, process_dir ) )
        {
            (void) fprintf(stderr, "ldconvo Failed\n");
            exit(1);
        }
/* -main_library_call_end */

/* -main_after_lib_call */
    writeimage(dconvo->o_file,image1);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for dconvo 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "dconvo :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tConvolution sequence of 1-D signal(s)\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i1  input first file (xviff file)  (infile)\n");
	fprintf(stderr,"\t-i2  input second file (xviff file)  (infile)\n");
	fprintf(stderr,"\t-o  resulting output file (xviff file)  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-j]  define arithmetic on data (boolean) [true]\n");
	fprintf(stderr,"\t[-d]  data processing direction (0 = down vectors, 1 = across bands) (boolean) [true]\n");
	fprintf(stderr, "\t[-g]  type of convolution file to be created( 0 = time tomain, 1 = FFT based)\n");
	fprintf(stderr, "\t\t0  (choose time domain convolution estimate),\n");
	fprintf(stderr, "\t\tor 1  (choose FFT based circular convolution estimate)\n");
	fprintf(stderr, "\t\t[default = 0]\n");
	fprintf(stderr, "\n");	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for dconvo\n");
	fprintf(stderr, "\t[-U] Gives the usage for dconvo\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called dconvo.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses dconvo.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for dconvo
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i1_pstr = 
	"\nEnter: (i1) input first file (xviff file) \n        {infile}: "; 
char	*i2_pstr = 
	"\nEnter: (i2) input second file (xviff file) \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output file (xviff file) \n        {outfile}: "; 
char	*j_pstr = 
	"\nEnter: (j) define arithmetic on data \n        {boolean, (y/n)  [yes] }: "; 
char	*d_pstr = 
	"\nEnter: (d) data processing direction (0 = down vectors, 1 = across bands) \n        {boolean, (y/n)  [yes] }: "; 
char	*g_pstr = "\nEnter: (g) type of convolution file to be created( 0 = time tomain, 1 = FFT based) -- \n      \t\t0 (choose time domain convolution estimate)\n\t\tor 1 (choose FFT based circular convolution estimate)\n  [0]:  "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "dconvo", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "dconvo.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "dconvo: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "dconvo.ans");
		}

	     }

	}

	/*
	 * allocate the dconvo structure
	 */
	dconvo = (dconvo_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (dconvo_struct));

	/*
	 * get required arguments for dconvo
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(dconvo->i1_flag = vget_infile(fid, prompt_flag,
			"-i1", i1_pstr, &(dconvo->i1_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(dconvo->i1_flag))
		{
		    fprintf(stderr, "\t\ti1 is required, please re-enter: \n");
		    dconvo->i1_flag = vget_infile(fid, prompt_flag,
		    "-i1", i1_pstr, &(dconvo->i1_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i1' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(dconvo->i2_flag = vget_infile(fid, prompt_flag,
			"-i2", i2_pstr, &(dconvo->i2_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(dconvo->i2_flag))
		{
		    fprintf(stderr, "\t\ti2 is required, please re-enter: \n");
		    dconvo->i2_flag = vget_infile(fid, prompt_flag,
		    "-i2", i2_pstr, &(dconvo->i2_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i2' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(dconvo->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(dconvo->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(dconvo->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    dconvo->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(dconvo->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for dconvo
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	dconvo->j_flag = vget_logic(fid, prompt_flag,
	"-j", j_pstr, &(dconvo->j_logic), 1);

	dconvo->d_flag = vget_logic(fid, prompt_flag,
	"-d", d_pstr, &(dconvo->d_logic), 1);


	/*
	 * get optional toggles for dconvo
	 */
	if (prompt_flag == TRUE)
	{
	    ok = FALSE;
	    while(!ok)
	    {
		dconvo->g_flag = vget_int(fid, prompt_flag,
		"-g", g_pstr, &(dconvo->g_toggle),
		0, 0, 0);

		if ((dconvo->g_toggle == 0 ) || 
		    (dconvo->g_toggle == 1 ))
		      ok = TRUE;
		else
		{
		}
	    }
	}
	else
	{
		dconvo->g_flag = vget_int(fid, prompt_flag,
		"-g", g_pstr, &(dconvo->g_toggle),
		0, 0, 0);

		if ((dconvo->g_toggle != 0 ) && 
		    (dconvo->g_toggle != 1 ))
		{
		    fprintf(stderr, "\n");
		    gw_usage();
		    exit(0);
		}
	}


}



