 /*
  * Khoros: $Id: dlsynth.h,v 1.2 1992/03/20 23:32:09 dkhoros Exp $
  */

 /*
  * $Log: dlsynth.h,v $
 * Revision 1.2  1992/03/20  23:32:09  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: dlsynth.h
 >>>>            Author: Ramiro Jordan
 >>>> Date Last Updated: Mon Feb 17 11:20:36 1992
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _dlsynth_h_
#define _dlsynth_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program;	/* a pointer to the program name argv[0] */
int	ac;

/****************************************************************
*
*                    dlsynth Argument Structure
*
****************************************************************/

typedef struct _dlsynth  {

/*
 *  input parameter file (xviff file) (Required infile)
 */
char	*i1_file;	/* input parameter file (xviff file) FILENAME */
int	 i1_flag;	/* input parameter file (xviff file) FLAG */

/*
 *  input driving file (xviff file) (Required infile)
 */
char	*i2_file;	/* input driving file (xviff file) FILENAME */
int	 i2_flag;	/* input driving file (xviff file) FLAG */

/*
 *  resulting synthesized output file (xviff file) (Required outfile)
 */
char	*o_file;	/* resulting synthesized output file (xviff file) FILENAME */
int	 o_flag;	/* resulting synthesized output file (xviff file) FLAG */

/*
 *  scalar processing (0) or vector processing (1) (default) (Optional logical)
 */
int	 j_logic;	/* scalar processing (0) or vector processing (1) (default) LOGIC */
int	 j_flag;  	/* scalar processing (0) or vector processing (1) (default) FLAG */

/*
 *  down vectors(0) or across bands(1) (default) (Optional logical)
 */
int	 d_logic;	/* down vectors(0) or across bands(1) (default) LOGIC */
int	 d_flag;  	/* down vectors(0) or across bands(1) (default) FLAG */

}  dlsynth_struct;

dlsynth_struct *dlsynth;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define READIMAGE(lattice,driver) \
lattice = readimage(dlsynth->i1_file);  \
if (lattice == NULL) {  \
   (void) fprintf(stderr, "dlsynth: Can not read input lattice parameters\n"); \
   exit(1);  /* Quit if bad image */ \
} \
driver =  readimage(dlsynth->i2_file);  \
if (driver == NULL) {  \
   (void) fprintf(stderr, "dlsynth: Can not read input driving sequence\n");  \
   exit(1);  /* Quit if bad image */ \
}
#define CHECKTYPE(program, lattice, driver) \
    if( ! (propertype(program,lattice,VFF_TYP_FLOAT,FALSE)) && \
        ! (propertype(program,lattice,VFF_TYP_COMPLEX,FALSE)) && \
        ! (propertype(program,lattice,VFF_TYP_4_BYTE, FALSE)) ) { \
        (void)  fprintf(stderr,"%s: data storage type must be integer, float or complex.\n\n",program); \
          exit(1); \
    } \
    if( ! (propertype(program,driver,VFF_TYP_FLOAT,FALSE)) && \
        ! (propertype(program,driver,VFF_TYP_COMPLEX,FALSE)) && \
        ! (propertype(program,driver,VFF_TYP_4_BYTE, FALSE)) ) { \
          (void) fprintf(stderr,"%s: data storage type must be integer, float or complex.\n\n",program); \
          exit(1); \
    } \
    if( propertype(program,driver,VFF_TYP_4_BYTE,FALSE) != \
        propertype(program,lattice,VFF_TYP_4_BYTE,FALSE) ) { \
          (void) fprintf(stderr,"%s: both input files must be of same data type.  \n\n",program); \
          exit(1); \
    } \
    if( propertype(program,driver,VFF_TYP_FLOAT,FALSE) != \
        propertype(program,lattice,VFF_TYP_FLOAT,FALSE) ) { \
          (void) fprintf(stderr,"%s: both input files must be of same data type.  \n\n",program); \
          exit(1); \
    } \
    if( propertype(program,driver,VFF_TYP_COMPLEX,FALSE) != \
        propertype(program,lattice,VFF_TYP_COMPLEX,FALSE) ) { \
          (void) fprintf(stderr,"%s: both input files must be of same data type.  \n\n",program); \
          exit(1); \
    } \

#define CHECKINPUT(program, lattice, driver) \
    proper_num_images(program,lattice,1,TRUE);  \
    proper_map_enable(program,lattice,VFF_MAP_OPTIONAL,TRUE); \
    proper_num_images(program,driver,1,TRUE);  \
    proper_map_enable(program,driver,VFF_MAP_OPTIONAL,TRUE);
/* -include_macros_end */

#endif
