 /*
  * Khoros: $Id: dfiltbp.h,v 1.3 1992/03/20 23:24:10 dkhoros Exp $
  */

 /*
  * $Log: dfiltbp.h,v $
 * Revision 1.3  1992/03/20  23:24:10  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: dfiltbp.h
 >>>>            Author: Jeremy Worley
 >>>> Date Last Updated: Mon Mar  9 20:16:21 1992
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _dfiltbp_h_
#define _dfiltbp_h_

#include "vinclude.h"


/* -include_includes */
#include "vpoly.h"
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program;	/* a pointer to the program name argv[0] */
int	ac;

/****************************************************************
*
*                    dfiltbp Argument Structure
*
****************************************************************/

typedef struct _dfiltbp  {

/*
 *  resulting output file (polynomial file) (Required outfile)
 */
char	*o_file;	/* resulting output file (polynomial file) FILENAME */
int	 o_flag;	/* resulting output file (polynomial file) FLAG */

/*
 *  sampling frequency in hertz (Optional float)
 */
float	 h_float;	/* sampling frequency in hertz FLOAT */
int	 h_flag;   	/* sampling frequency in hertz FLAG */

/*
 *  lower rejection frequency (Optional float)
 */
float	 f1_float;	/* lower rejection frequency FLOAT */
int	 f1_flag;   	/* lower rejection frequency FLAG */

/*
 *  lower cutoff frequency (Optional float)
 */
float	 f2_float;	/* lower cutoff frequency FLOAT */
int	 f2_flag;   	/* lower cutoff frequency FLAG */

/*
 *  upper cutoff frequency (Optional float)
 */
float	 f3_float;	/* upper cutoff frequency FLOAT */
int	 f3_flag;   	/* upper cutoff frequency FLAG */

/*
 *  upper rejection frequency (Optional float)
 */
float	 f4_float;	/* upper rejection frequency FLOAT */
int	 f4_flag;   	/* upper rejection frequency FLAG */

/*
 *  gain at passband edges  (Optional float)
 */
float	 tc_float;	/* gain at passband edges  FLOAT */
int	 tc_flag;   	/* gain at passband edges  FLAG */

/*
 *  gain at stopband edges  (Optional float)
 */
float	 tr_float;	/* gain at stopband edges  FLOAT */
int	 tr_flag;   	/* gain at stopband edges  FLAG */

/*
 * filter class (0 = butterworth; 1 = chebychev i; 2 = chebychev ii) (Optional integer toggle - )
 */
int	 c_toggle;		/* filter class (0 = butterworth; 1 = chebychev i; 2 = chebychev ii) INT TOGGLE */
int	 c_flag;		/* filter class (0 = butterworth; 1 = chebychev i; 2 = chebychev ii) FLAG */

}  dfiltbp_struct;

dfiltbp_struct *dfiltbp;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
#define COEFS_PER_STAGE 6
#define ORDERS_PER_STAGE 2
#define MAXPOLYS 1
#define MAXTERMS 600
#define MAXSTAGES 100
#define STRMAX 100
#define FUNC_NAME "H"
#define INDEP_VAR "z"
/* -include_macros_end */

#endif
