 /*
  * Khoros: $Id: phantomd.c,v 1.3 1992/03/25 17:32:18 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: phantomd.c,v 1.3 1992/03/25 17:32:18 dkhoros Exp $";
#endif

 /*
  * $Log: phantomd.c,v $
 * Revision 1.3  1992/03/25  17:32:18  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: phantomd.c
 >>>>
 >>>>      Program Name: phantomd
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	starts the phantomd daemon on a host which is used for  dis-
 >>>>	tributed processing
 >>>>	
 >>>>	


 >>>> 
 >>>> Date Last Updated: Sat Mar 21 09:59:39 1992
 >>>>
 >>>>          Routines: main- the main program for phantomd
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "phantomd.h"


/****************************************************************
 *
 * Routine Name:  main program for phantomd
 *
 *       Input:  
 *
 *
 *          [-connections] Maximum number of connections allowed  (1 < value < 50)
 *          [-transport] type of transport to start the daemon for
 *          [-timeout] number of minutes idle time before quitting 
 *          [-daemon] spawn process in background and disassociate tty
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
/* -main_before_lib_call_end */

/* -main_library_call */
        if (!lphantomd(argc, argv, phantomd->transport_string,
                phantomd->connections_int, phantomd->timeout_int,
                phantomd->daemon_logic))
        {
           (void) fprintf(stderr,"lphantomd failed!\n");
           exit(1);
        }
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for phantomd 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "phantomd :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tstarts the phantomd daemon on a host which is used for  dis-\n");
	fprintf(stderr, "\ttributed processing\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-connections]  Maximum number of connections allowed (integer, 1 to 50) [1]\n");
	fprintf(stderr,"\t[-transport]  type of transport to start the daemon for (string) [null]\n");
	fprintf(stderr,"\t[-timeout]  number of minutes idle time before quitting (integer) [30]\n");
	fprintf(stderr,"\t[-daemon]  spawn process in background and disassociate tty (boolean) [false]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for phantomd\n");
	fprintf(stderr, "\t[-U] Gives the usage for phantomd\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called phantomd.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses phantomd.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for phantomd
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*connections_pstr = 
	"\nEnter: (connections) Maximum number of connections allowed \n        {integer, 1 to 50 [1] }: "; 
char	*transport_pstr = 
	"\nEnter: (transport) type of transport to start the daemon for \n        {string}: "; 
char	*transport_def = NULL;
char	*timeout_pstr = 
	"\nEnter: (timeout) number of minutes idle time before quitting \n        {integer [30] }: "; 
char	*daemon_pstr = 
	"\nEnter: (daemon) spawn process in background and disassociate tty \n        {boolean, (y/n)  [no] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "phantomd", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "phantomd.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "phantomd: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "phantomd.ans");
		}

	     }

	}

	/*
	 * allocate the phantomd structure
	 */
	phantomd = (phantomd_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (phantomd_struct));

	/*
	 * get optional arguments for phantomd
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	phantomd->connections_flag = vget_int(fid, prompt_flag,
	"-connections", connections_pstr, &(phantomd->connections_int),
	1, 1, 50);

	phantomd->transport_flag = vget_string(fid, prompt_flag,
	"-transport", transport_pstr, &(phantomd->transport_string),
	transport_def);

	if (prompt_flag == FALSE)
	{
	    if ((phantomd->transport_flag == 1)&&(phantomd->transport_string == NULL))
    	{
		fprintf(stderr, "phantomd:\n");
		fprintf(stderr, "you must specify a name following '-transport'\n");
		gw_usage();
		exit(1);
		}
	}
	phantomd->timeout_flag = vget_int(fid, prompt_flag,
	"-timeout", timeout_pstr, &(phantomd->timeout_int),
	30, 0, 0);

	phantomd->daemon_flag = vget_logic(fid, prompt_flag,
	"-daemon", daemon_pstr, &(phantomd->daemon_logic), 0);


}



