 /*
  * Khoros: $Id: lphantomd.c,v 1.4 1992/03/25 17:32:22 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: lphantomd.c,v 1.4 1992/03/25 17:32:22 dkhoros Exp $";
#endif

 /*
  * $Log: lphantomd.c,v $
 * Revision 1.4  1992/03/25  17:32:22  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lphantomd.c
 >>>>
 >>>>      Program Name: phantomd
 >>>>
 >>>> Date Last Updated: Sun Dec 15 19:52:44 1991 
 >>>>
 >>>>          Routines: lphantomd - the library call for phantomd
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
#include "phantomd.h"
#include "vsignal.h"
#include <sys/ioctl.h>
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lphantomd - library call for phantomd
*
* Purpose:
*
* Input:
* Output:
* Written By:
*
****************************************************************/


/* -library_def */
int lphantomd(argc, argv, identifier, max_daemons, timeout, daemon)

int     argc;
char    *argv[];
char    *identifier;
int     max_daemons;
int     timeout;
int     daemon;
/* -library_def_end */

/* -library_code */
{
        int     i, pid, temp, fid;


        /*
         *  Fork off the process then wait for 5 seconds and see if it started.
         *  if the daemon didn't start then our child should be done.
         */
        if (daemon == TRUE)
        {
           pid = fork();
           if (pid == -1)
              return(FALSE);
           else if (pid != 0)
           {
              (void) printf("\n\nphantom: starting phantom daemon.... ");
              sleep(5);
              while ((temp = vwait3(NULL, WNOHANG, NULL)) > 0)
              {
                 if (temp == pid)
                 {
                    (void) fprintf(stderr,"failed.\n\n");
                    (void) fprintf(stderr, "\nphantomd:  Error occurred while \
either starting or running of the phantom\ndaemon(s).  Please either fix the \
problem or start the 'phantomd' daemon on a\ndifferent machine.\n\n");
                    return(FALSE);
                 }
              }
              (void) printf("done.\n\n");
              exit(0);
           }
           else
           {
              /*
               *  Rewrite the name so that our children come out as (phantomd)
               *  instead of our command line
               */
              (void) sprintf(argv[0], "(phantomd)");

              /*
               *  close any open file descriptors
               */
              if (khoros_verbose == FALSE)
              {
                 (void) fclose(stdin);
                 (void) fclose(stdout);
                 (void) fclose(stderr);
              }
              errno = 0;
           }
        }
        else
        {
           (void) printf("\n\nphantomd:  starting phantom daemon in ");
           (void) printf("foreground.  No process will be\nspawned in ");
	   (void) printf("background.\n\n");
        }

        if (kstart_daemon(identifier, max_daemons, timeout*60) == 0)
           return(TRUE);
        else
           return(FALSE);
}

/* -library_code_end */
