 /*
  * Khoros: $Id: getarg_user.c,v 1.3 1991/12/18 09:54:36 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: getarg_user.c,v 1.3 1991/12/18 09:54:36 dkhoros Exp $";
#endif

 /*
  * $Log: getarg_user.c,v $
 * Revision 1.3  1991/12/18  09:54:36  dkhoros
 * HellPatch3
 *
  */ 

/******************************************************************

	Get Argument from the user interactively 

	source filename:			get_arg_user.c		

	revision	  date			programmer
	--------	  ----			----------
	   0.0		Jan-05-85		don hush

******************************************************************

	usage
	-----

	get_arg_user(prompt,arg,type)

	char *prompt,type;
	char *arg;

	#include "uio_defs"

	description
	-----------

	  This routine gets an argument from the user interactively.
	The user is prompted with 'prompt'. If prompt == "noprompt"
	a -1 is returned. Once an string response is received it
	is converted to the proper type according to 'type'
	('i','f','l','s').

******************************************************************/

#include "vgparm.h"

int first_time = TRUE, make;
char make_name[80];

get_arg_user(prompt,arg,type)

char *prompt,type;
char *arg;

{
	int len,i,fd,flags=O_RDWR, loop;
	char c, sarg[MAX_ARG_LEN], leftover[MAX_ARG_LEN];

	if (strcmp(prompt,"noprompt") == 0) {
		return(-1);
	}

	fd = open("/dev/tty",flags,0666);
	if (fd<1) {
		fprintf(stderr,"ERROR-cannot open channel to terminal\n");
		exit(1);
	}

	len = strlen(prompt);
	write(fd,prompt,len);

	
	i = -1;
	do {
		i++;
		if (read(fd,&sarg[i],1) < 1) break;
		if (sarg[i]=='\\') {
			read(fd,&c,1);
			if (c == 'n')
				sarg[i] = '\n';
			else
				i--;
		}
		else if (sarg[i]=='\n')
		   break;

	} while ((i-1) < MAX_ARG_LEN);
	sarg[i] = '\0';
	close(fd);

	switch (type) {

	    case 'i' :
		if (VStrlen(sarg) == 0)
		    return(-2);
		if (!(isdigit(sarg[0]) || sarg[0] == '-' ||
		      sarg[0] == '+'))
		    return(-2);
		for (loop = 1; loop < VStrlen(sarg); loop++)
		    if (! isdigit(sarg[loop]))
		        return(-2);
		*(int *) arg = atoi(sarg);
		break;

	    case 'f':
		if (VStrlen(sarg) == 0)
		    return(-2);
		if (sscanf(sarg, "%f%s", (float *) arg, leftover) == 1)
		    break;
		else
		    return(-2);
		break;

	    case 'l':
		if (VStrlen(sarg) == 0)
		    return(-2);

		*(int *) arg = FALSE;
		switch (sarg[0]) {
		    case 'y':
		    case 'Y':
		    case 't':
		    case 'T':
		    case '1':
			*(int *) arg = TRUE;
		}
		break;

	    case 's':
		strcpy(arg,sarg);
		break;
	}

	return(0);
}
