 /*
  * Khoros: $Id: dirname.c,v 1.1 1991/05/10 15:41:06 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: dirname.c,v 1.1 1991/05/10 15:41:06 khoros Exp $";
#endif

 /*
  * $Log: dirname.c,v $
 * Revision 1.1  1991/05/10  15:41:06  khoros
 * Initial revision
 *
  */ 


/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "vgparm.h"	


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    file name: dirname.c                              <<<<
   >>>>                                                       <<<<
   >>>>   description: Strip the path off a filename          <<<<
   >>>>                                                       <<<<
   >>>>      routines: vdirname 			      <<<<
   >>>>                                                       <<<<
   >>>> modifications:					      <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


/**************************************************************
*
* MODULE NAME: vdirname
*
*     PURPOSE: 	This function is used to strip the path off a
*		filename.
*
*       INPUT: 	filename - a valid file or path
*
*      OUTPUT:  returns a pointer to the directory in which the
*		file would exist.
*		
*
* CALLED FROM:  application program
*
* WRITTEN BY:   Mark Young
*
**************************************************************/

char *vdirname(filename)

char	*filename;
{
	int   num;
	char  *file, temp[LENGTH], dirname[LENGTH];


	/*
	 *  If the filename is null then error and return NULL
	 */
	if (filename == NULL)
	{
	   (void) fprintf(stderr,"\nvdirname:\n");
	   (void) fprintf(stderr,"   Error!  NULL input file encountered.\n");
	   return(NULL);
	}

	/*
	 *  If the filename is  empty then error and return NULL
	 */
	strcpy(temp, filename);
	filename = _cleanup_string(temp);
	if (VStrlen(filename) == 0)
	{
	   (void) fprintf(stderr,"\nvdirname:\n");
	   (void) fprintf(stderr,"   Error!  Empty input file encountered.\n");
	   return(NULL);
	}


	/*
	 *  basically want to get the component or the prefix to the filename.
	 *  This should be the last occurence of a '/'.  If no '/' is found
	 *  then we check to see if the string begins with a ~username.  If
	 *  neither of these cases occur then it must be a filename in which
	 *  case we will return "." for the current directory.
	 */
	if ((file = strrchr(filename,'/')) != NULL)
	{
	   /*
	    *  Now that we have found the last occurence of '/' we
	    *  need to make sure that it is not the root of the file
	    *  system ie) /usr, or that the string is not ~/.  Otherwise
	    *  we copy everything in front of the "file" part of the string.
	    */
	   if (file == filename)
	      strcpy(dirname, "/");
	   else if (file[-1] == '~')
	   {
	      num = file-filename+1;
	      strncpy(dirname, filename, num);
	      dirname[num] = '\0';
	   }
	   else
	   {
	      num = file-filename;
	      strncpy(dirname, filename, num);
	      dirname[num] = '\0';
	   }
	}
	else if (filename[0] == '~')
	   strcpy(dirname,filename);
	else if (strcmp(filename,"..") == 0)
	   strcpy(dirname,"..");
	else
	   strcpy(dirname,".");

        return(VStrcpy(dirname));
}
