/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lexample1.c
 >>>>
 >>>>      Program Name: example1
 >>>>
 >>>> Date Last Updated: Wed Apr 24 09:33:22 1991 
 >>>>
 >>>>          Routines: lexample1 - the library call for example1
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "xvinclude.h"


/* -library_includes */
#include "example1.h"

/* -library_includes_end */


/****************************************************************
*
* Routine Name: lexample1 - library call for example1
*
* Purpose:
*
* Input:
* Output:
* Written By:
*
****************************************************************/


/* -library_def */
run_example1(argc, argv, program)
int     argc;
char    *argv[];
char    *program;
/* -library_def_end */

/* -library_code */
{
        xvf_form  *form;
        example1 example1_info;
        char *form_filestring;
        char *form_pathname;
        Window workspace_window;
        Coord wc_min, wc_max;
        Widget workspace;
        Arg args[MaxArgs];
        int i;
        unsigned long bg;

        static char *colornames[]=
        {
          "White",        "MediumSpringGreen",  "Yellow",    "Cyan",
          "MediumOrchid", "Magenta",            "Orange",    "Wheat",
          "LimeGreen",    "Turquoise",          "Pink",      "LightGrey",
          "PeachPuff",    "Lavender",           "MintCream", "SlateBlue",
          "Aquamarine",   "SeaGreen",           "YellowGreen", "RosyBrown",
        };
        

        id = 1;

        /*
         * initialize the display & the forms - 
         * NOTE: assuming a global 'Display *display'
         */
        display = xvf_initialize(ac, av, program);
        if (display == NULL)
        {
             fprintf(stderr, "Could not open connection to server");
             exit(0);
        }

        /*
         * Substitute below the correct filename and directory path
         * of the User Interface Description file to be used
         */
        form_filestring = xvf_strcpy("example1.form");
        form_pathname   = xvf_strcpy("$KHOROS_CONTRIB/repos/xvroutines");
        form_filestring = vfullpath(form_filestring, form_pathname, NULL);

        /*
         * Create the forms 
         */
        if (!(form = xvf_create_form(form_filestring, av, ac, SIMPLE, NULL,
                                     -1, -1)))
           exit(0);

        /*
         * Initialize the auto-generated information structure
         */
        _xvf_init_example1(form,  &example1_info);

        /*
         *  initialize workspace - want black background 
         */
        workspace = example1_info.sub->one->workspace;
        XtAddEventHandler(workspace, ExposureMask, False,
                          refresh_workspace, NULL);
        workspace_window = XtWindow(workspace);

        bg = BlackPixel(display, DefaultScreen(display));
        i = 0;
        XtSetArg(args[i], XtNbackground, bg);                     i++;
        XtSetValues(workspace, args, i);


        /*
         *  initialize graphics library 
         */
        X3D_init_graphics(id, X2D);
        X3D_set_X11(id, display, workspace_window, workspace);
        X2D_set_window(id, 0, 0, 511, 139);
        X2D_set_viewport(id, 0.05, 0.95, 0.05, 0.95);
        wc_min.x = 0;
        wc_min.y = 0;
        wc_max.x = 511;
        wc_max.y = 139;
        X2D_set_wc_min_max(id, wc_min, wc_max);
        
        /*
         *  initially allocate colors & initialize other globals 
         */
        X3D_allocate_named_colors(display, colornames, Colors, COLORNUM,
                                  false, X3D_WHITE);
        colornum = 0;
        linecount = 1;

        /*
         * Map the forms
         */
        xvf_change_active(form, true);

        do
        {
             /*
              * run the forms
              */
             form = xvf_run_form();
             if (form == NULL) break;

             /*
              * get information from the master
              */
             _xvf_get_example1(form, &example1_info);

             /*
              * action came from the 'sub' subform
              */
             if (example1_info.sub_selected)
             {
                  run_sub(form, example1_info.sub);
             }


        xvf_clear_selections(form->db, form->line_num);
        } while (!example1_info.sub->one->quit);    /* end user interface loop */
   return(TRUE);
}


/********************************************************
*
*  Routine Name:  refresh_workspace
*
*       Purpose:  event handler to update workspace on exposure
*
*         Input:  widget - the widget that the event handler was
*                          installed on (workspace)
*                 event  - event that initiated the event handler (Exposure)
*                 clientData - 
*                          used to pass a data structure if needed; we don't 
*                          need one here.  if we had, we would have passed its 
*                          pointer to XtAddEventHandler as the last argument, 
*                          instead of NULL.
*
*        Output:  refreshes colored lines on the workspace
*
*     Called By:  X Toolkit on Exposure Events
*
*    Written By:  Danielle Argiro 
*
********************************************************/

void refresh_workspace(widget, event, clientData)
Widget widget;
XEvent *event;
caddr_t clientData;
{
        Coord coord1, coord2;
        int i;
        int colorindex;

        /* the first line was this */
        coord1.x = 5;
        coord1.y = 5;
        coord2.x = 5;
        coord2.y = 135;

        colorindex = 0;

        /* the next lines were these */
        for(i = 0; i < linecount; i++)
        {
           X2D_draw_line(id, coord1, coord2, &Colors[colorindex]);
           colorindex++; if (colorindex > COLORNUM) colorindex = 0;
           coord1.x+=5;
           coord2.x+=5;
        }
        XFlush(display);
}


/* -library_code_end */
