/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lFimg2viff.c
 >>>>
 >>>>      Program Name: Fimg2viff
 >>>>
 >>>> Date Last Updated: Sun Mar 10 11:30:02 1991 
 >>>>
 >>>>          Routines: lFimg2viff - the library call for Fimg2viff
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lFimg2viff - library call for Fimg2viff
*
* Purpose:
*    
*    Conversion from Fremont (4.7 Tesla  Magnet)  Image  to  VIFF
*    Format
*    
*    
* Input:
*    
*    file           (int) file descriptor of the file in which the raw
*                   data is located.
*    
*    nrows          (int) number of rows.
*    
*    ncols          (int) number of columns.
*    
*    header_offset  (int) offset, in bytes, of data from beginning  of
*                   raw file.
*    
*    type           (long unsigned) refers to data type of input file.
*    
*    
* Output:
*    
*    image          (struct xvimage) the resulting VIFF image.
*    
*    
*
* Written By: Donna Koechner
*    
*    Thu Jun  7 12:30:04 MDT 1990 Donna  Koechner  -  updated  to
*    ghostwriter
*    Changed name from nicimg2viff to Fimg2viff
*    Audit Done  05-OCT-90  Donna Koechner
*    
*    
****************************************************************/


/* -library_def */
int 
lFimg2viff(file, image, nrows, ncols, header_offset, type)
struct xvimage  **image;
int             nrows, ncols, header_offset;
int             file;
long unsigned   type;
/* -library_def_end */

/* -library_code */
{
  int                   img_size, num_pts, conv_to_float;
  int                   i,j;
  struct xvimage        *img, *createimage();
  char                  *data, *out_data, *read_raw_mag();

 /*
  * Calculate image data size (multiply by two because of zero padding).
  */
  img_size = nrows * ncols * 2;
  
 /*
  * Read in the raw signa image.
  */
  
  conv_to_float = 0;    /* do not convert output type to VFF_TYP_FLOAT */

  if (!(data = read_raw_mag(file, header_offset, &num_pts, type, conv_to_float)))
  {
    return(0);
  }

  if ( num_pts < img_size )
  {
    (void)fprintf(stderr,"\nOut of bounds! Number of requested rows and \
columns is greater than \nthe number of points found in the data file.\n\
Number of points is %d. (Number of rows = %d Number of columns = %d.)\n\n", 
num_pts, nrows, ncols);
    return(0);
  }
 
 /*
  * Allocate for output data array
  */

  out_data=(char *)(malloc((unsigned int)(nrows*ncols*sizeof(char))));
  if (out_data == NULL)
  {
    (void) fprintf(stderr,"lFimg2viff: memory allocation failed.\n");
    return(0);
  }

 /* 
  * Remove zero padding --> drop 2 bytes, assign 2 bytes to output array ...
  */
  j = 0;
  for (i = 0; i < img_size; i+=4)
  {
    out_data[j]   = data[i+2];
    out_data[j+1] = data[i+3];
    j+=2;
  }

 /*
  * Create the VIFF image.
  */
  img = createimage( (unsigned long) nrows,             /* number of rows */
                     (unsigned long) ncols,             /* number of columns */
                     (unsigned long) type,              /* data_storage_type */
                     (unsigned long) 1,                 /* number_of_images */
                     (unsigned long) 1,                 /* num_data_bands */
                     "created by Fimg2viff",            /* comment */
                     (unsigned long) 0,                 /* map_row_size */
                     (unsigned long) 0,                 /* map_col_size */
                     (unsigned long) VFF_MS_NONE,       /* map_scheme */
                     (unsigned long) VFF_MAPTYP_NONE,   /* map_storage_type */
                     (unsigned long) VFF_LOC_IMPLICIT,  /* location_type */
                     (unsigned long) 0);        /* dimension */
 
  img->imagedata = out_data;
  *image = img;
  if ( img == NULL )
  { 
    (void)fprintf(stderr,"lFimg2viff: Unable to allocate new image!\n");
    return(0);
   }
  return (1);
}
/* -library_code_end */
