/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvspcomp.c
 >>>>
 >>>>      Program Name: vspcomp
 >>>>
 >>>> Date Last Updated: Mon Apr 15 22:20:09 1991 
 >>>>
 >>>>          Routines: lvspcomp - the library call for vspcomp
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvspcomp - library call for vspcomp
*
* Purpose:
*    
*    Compensate sputter yield for angular dependence
*    
*    
* Input:
*    
*    img1           Pointer to input sputter yield image -  usually  a
*                   constant.
*    
*    img2           Pointer to angle image - must be same size as img1
*                   and  contains  the  surface  normal  angle at each
*                   point. Angles should be in degrees.
*    
*    
* Output:
*    
*    img3           Pointer to image pointer to  receive  the  compen-
*                   sated  sputter  yield  image.  The image itself is
*                   allocated inside lvspcom().
*    
*    
*
* Written By: Scott Wilson
*    
*    2-Feb-90 Scott Wilson - Modified yield equation to reflect exper-
*    imental data.
*    
*    6-Feb-90 Scott Wilson - Modified yield equation AGAIN  this  time
*    hopefully correctly!
*    
*    
****************************************************************/


/* -library_def */
int
lvspcomp(img1,img2,img3)
struct xvimage *img1, *img2, **img3;
/* -library_def_end */

/* -library_code */
  {
    float *yield,*angle,*comp,sp_yield();
    struct xvimage *c,*copyimage();
    int i,j,k;
    int rows,cols;

    cols = img1->row_size;
    /*
    rows = img1->col_size;
    */

    yield = (float *)(img1->imagedata);
    angle = (float *)(img2->imagedata);

    c = copyimage(img1);
    comp = (float *)(c->imagedata);

    for (i=0; i<cols; i++)
      for (j=0; j<cols; j++)
        {
          k = PIXEL(j,i,rows,cols);
          comp[k]=yield[k]*sp_yield(angle[k]);
        }

    *img3 = c;
    return(1);
  }

static float sp_yield(angle)
float angle;
  {
    /* Compute sputter yield as a function of angle. The yield is given
       as a multiplier relative to the yield at normal incidence. This curve
       was obtained by fitting to data taken on the IBF machine. */

    float f;
    double exp();
    
    f = 1 + 2.4*exp((double)(-(angle-60)*(angle-60)/300))
          + 0.01*angle
          - 2.0*exp((double)(-(angle-90)*(angle-90)/400));
    return(f);
  }
/* -library_code_end */
