/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvcontract.c
 >>>>
 >>>>      Program Name: vcontract
 >>>>
 >>>> Date Last Updated: Mon Apr 15 22:19:11 1991 
 >>>>
 >>>>          Routines: lvcontract - the library call for vcontract
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvcontract - library call for vcontract
*
* Purpose:
*    
*    Contract an image by summing pixels
*    
*    
* Input:
*    
*    image          pointer to image structure to be contracted
*    
*    scale          scale  factor  by  which  to  contract  the  image
*                   (integer), must be postitive and non-zero
*    
*    
* Output:
*    
*    image          points to the image structure that has  been  pro-
*                   cessed.  The  output  data type is the same as the
*                   input data type.
*    
*    Return Value:  1 on success, 0 on failure
*    
*    
*
* Written By: Scott Wilson
****************************************************************/


/* -library_def */
int
lvcontract(image,scale)
struct xvimage *image;
int  scale;
/* -library_def_end */

/* -library_code */
{
    int j,k;
    char *malloc();
    unsigned char *c1,*c2;
    short *s1,*s2;
    int *i1,*i2;
    float *f1,*f2;
    int size;
    int rows,cols,orows,ocols;
    int b,nb;

    if (scale < 1)
      {
        fprintf(stderr,"lvcontract: Contraction factor must be >= 1\n");
        return(0);
      }

    rows = image->col_size;
    cols = image->row_size;
    orows = rows/scale;
    ocols = cols/scale;
    nb = image->num_data_bands;
    image->pixsizx *= scale;
    image->pixsizy *= scale;

    switch (image->data_storage_type)
      {
        case VFF_TYP_BIT :
          fprintf(stderr,"lvcontract: Don't know how to contract a BIT image!\n");
          return(0);
          break;
        case VFF_TYP_1_BYTE : 
          size = sizeof(unsigned char)*orows*ocols*nb;
          c1 = (unsigned char *)(image->imagedata);
          c2 = (unsigned char *)malloc(size);
          bzero(c2,size);
          if (c2 == NULL)
            {
              fprintf(stderr,"lvcontract: unable to allocate new image\n");
              return(0);
            }
          for (j=0; j<rows; j++)
            for (k=0; k<cols; k++)
              for (b=0; b<nb; b++)
                c2[BPIXEL(b,(k/scale),(j/scale),orows,ocols)] +=
                  c1[BPIXEL(b,k,j,rows,cols)];
          image->row_size = ocols;
          image->col_size = orows;
          image->imagedata = (char *)c2;
          break;
        case VFF_TYP_2_BYTE :
          size = sizeof(short)*orows*ocols*nb;
          s1 = (short *)(image->imagedata);
          s2 = (short *)malloc(size);
          bzero(s2,size);
          if (s2 == NULL)
            {
              fprintf(stderr,"lvcontract: unable to allocate new image\n");
              return(0);
            }
          for (j=0; j<rows; j++)
            for (k=0; k<cols; k++)
              for (b=0; b<nb; b++)
                s2[BPIXEL(b,(k/scale),(j/scale),orows,ocols)] +=
                  s1[BPIXEL(b,k,j,rows,cols)];
          image->row_size = ocols;
          image->col_size = orows;
          image->imagedata = (char *)s2;
          break;
        case VFF_TYP_4_BYTE :
          size = sizeof(int)*orows*ocols*nb;
          i1 = (int *)(image->imagedata);
          i2 = (int *)malloc(size);
          bzero(i2,size);
          if (i2 == NULL)
            {
              fprintf(stderr,"lvcontract: unable to allocate new image\n");
              return(0);
            }
          for (j=0; j<rows; j++)
            for (k=0; k<cols; k++)
              for (b=0; b<nb; b++)
                i2[BPIXEL(b,(k/scale),(j/scale),orows,ocols)] +=
                  i1[BPIXEL(b,k,j,rows,cols)];
          image->row_size = ocols;
          image->col_size = orows;
          image->imagedata = (char *)i2;
          break;
        case VFF_TYP_FLOAT :
          size = sizeof(float)*orows*cols*nb;
          f1 = (float *)(image->imagedata);
          f2 = (float *)malloc(size);
          bzero(f2,size);
          if (f2 == NULL)
            {
              fprintf(stderr,"lvcontract: unable to allocate new image\n");
              return(0);
            }
          for (j=0; j<rows; j++)
            for (k=0; k<cols; k++)
              for (b=0; b<nb; b++)
                f2[BPIXEL(b,(k/scale),(j/scale),orows,ocols)] +=
                  f1[BPIXEL(b,k,j,rows,cols)];
          image->row_size = ocols;
          image->col_size = orows;
          image->imagedata = (char *)f2;
          break;
        case VFF_TYP_COMPLEX :
          fprintf(stderr,"lvcontract: COMPLEX not supported (yet)\n");
          return(0);
          break;
        default:
          fprintf(stderr,"lvcontract: Unknown data storage type, %d\n",image->data_storage_type);
          return(0);
          break;
      }
      return(1);
}
/* -library_code_end */
