/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vgeneric.c
 >>>>
 >>>>      Program Name: vgeneric
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Generic routine interface
 >>>>	
 >>>>	
 >>>>            Author: Scott Wilson
 >>>>
 >>>> Date Last Updated: Mon Apr 15 22:18:50 1991
 >>>>
 >>>>          Routines: main- the main program for vgeneric
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vgeneric.h"


/****************************************************************
 *
 * Routine Name:  main program for vgeneric
 *
 *       Input:  
 *          -di1  selects minus sign (TRUE) or blank (FALSE) for input name #1 
 *          -di2  selects minus sign (TRUE) or blank (FALSE) for input name #2 
 *          -di3  selects minus sign (TRUE) or blank (FALSE) for input name #3 
 *          -do1  selects minus sign (TRUE) or blank (FALSE) for output name #1 
 *          -do2  selects minus sign (TRUE) or blank (FALSE) for output name #2 
 *          -do3  selects minus sign (TRUE) or blank (FALSE) for output name #3 
 *          -dn1  selects minus sign (TRUE) or blank (FALSE) for arg name #1 
 *          -dn2  selects minus sign (TRUE) or blank (FALSE) for arg name #2 
 *          -dn3  selects minus sign (TRUE) or blank (FALSE) for arg name #3 
 *          -dn4  selects minus sign (TRUE) or blank (FALSE) for arg name #4 
 *          -dn5  selects minus sign (TRUE) or blank (FALSE) for arg name #5 
 *          -dn6  selects minus sign (TRUE) or blank (FALSE) for arg name #6 
 *          -dn7  selects minus sign (TRUE) or blank (FALSE) for arg name #7 
 *          -dn8  selects minus sign (TRUE) or blank (FALSE) for arg name #8 
 *
 *
 *          [-prefix] prefix string
 *          [-i] input image
 *          [-o] output image or file
 *          [-iname1] name of input argument #1
 *          [-i1] input filename #1
 *          [-iname2] name of input argument #2
 *          [-i2] input filename #2
 *          [-iname3] name of input argument #3
 *          [-i3] input filename #3
 *          [-oname1] name of output argument #1
 *          [-o1] output filename #1
 *          [-oname2] name of output argument #2
 *          [-o2] output filename #2
 *          [-oname3] name of output argument #3
 *          [-o3] output filename #3
 *          [-name1] Name of argument #1
 *          [-val1] argument #1 value
 *          [-name2] Name of argument #2
 *          [-val2] argument #2 value
 *          [-name3] Name of argument #3
 *          [-val3] argument #3 value
 *          [-name4] Name of argument #4
 *          [-val4] argument #4 value
 *          [-name5] Name of argument #5
 *          [-val5] argument #5 value
 *          [-name6] Name of argument #6
 *          [-val6] argument #6 value
 *          [-name7] Name of argument #7
 *          [-val7] argument #7 value
 *          [-name8] Name of argument #8
 *          [-val8] argument #8 value
 *          [-trailer] trailer string
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
char s[8192];
char t[1024];
struct xvimage *image;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
        if (check_args()) exit(1);

        /* Read the input image if it is selected */
        if (vgeneric->i_flag)
          {
            image = readimage(vgeneric->i_file);
            if (image == NULL)
              {
                fprintf(stderr,"vgeneric: Unable to read input file\n");
                exit(1);
              }
          }

        /* Start with the prefix if it is declared */
        if (vgeneric->prefix_flag)
          {
            sprintf(t,"%s ",vgeneric->prefix_string);
            strcat(s,t);
          }

        /* Next do the input file items */
        if (vgeneric->di1_logic) strcat(s,"-");
        if (vgeneric->iname1_flag)
          {
            sprintf(t,"%s ",vgeneric->iname1_string);
            strcat(s,t);
          }
        if (vgeneric->i1_flag)
          {
            sprintf(t,"%s ",vgeneric->i1_file);
            strcat(s,t);
          }
        if (vgeneric->di2_logic) strcat(s,"-");
        if (vgeneric->iname2_flag)
          {
            sprintf(t,"%s ",vgeneric->iname2_string);
            strcat(s,t);
          }
        if (vgeneric->i2_flag)
          {
            sprintf(t,"%s ",vgeneric->i2_file);
            strcat(s,t);
          }
        if (vgeneric->di3_logic) strcat(s,"-");
        if (vgeneric->iname3_flag)
          {
            sprintf(t,"%s ",vgeneric->iname3_string);
            strcat(s,t);
          }
        if (vgeneric->i3_flag)
          {
            sprintf(t,"%s ",vgeneric->i3_file);
            strcat(s,t);
          }

        /* Now do the output file items */
        if (vgeneric->do1_logic) strcat(s,"-");
        if (vgeneric->oname1_flag)
          {
            sprintf(t,"%s ",vgeneric->oname1_string);
            strcat(s,t);
          }
        if (vgeneric->o1_flag)
          {
            sprintf(t,"%s ",vgeneric->o1_file);
            strcat(s,t);
          }
        if (vgeneric->do2_logic) strcat(s,"-");
        if (vgeneric->oname2_flag)
          {
            sprintf(t,"%s ",vgeneric->oname2_string);
            strcat(s,t);
          }
        if (vgeneric->o2_flag)
          {
            sprintf(t,"%s ",vgeneric->o2_file);
            strcat(s,t);
          }
        if (vgeneric->do3_logic) strcat(s,"-");
        if (vgeneric->oname3_flag)
          {
            sprintf(t,"%s ",vgeneric->oname3_string);
            strcat(s,t);
          }
        if (vgeneric->o3_flag)
          {
            sprintf(t,"%s ",vgeneric->o3_file);
            strcat(s,t);
          }

        /* Now do the general argument items */
        if (vgeneric->dn1_logic) strcat(s,"-");
        if (vgeneric->name1_flag)
          {
            sprintf(t,"%s ",vgeneric->name1_string);
            strcat(s,t);
          }
        if (vgeneric->val1_flag)
          {
            sprintf(t,"%s ",vgeneric->val1_string);
            strcat(s,t);
          }
        if (vgeneric->dn2_logic) strcat(s,"-");
        if (vgeneric->name2_flag)
          {
            sprintf(t,"%s ",vgeneric->name2_string);
            strcat(s,t);
          }
        if (vgeneric->val2_flag)
          {
            sprintf(t,"%s ",vgeneric->val2_string);
            strcat(s,t);
          }
        if (vgeneric->dn3_logic) strcat(s,"-");
        if (vgeneric->name3_flag)
          {
            sprintf(t,"%s ",vgeneric->name3_string);
            strcat(s,t);
          }
        if (vgeneric->val3_flag)
          {
            sprintf(t,"%s ",vgeneric->val3_string);
            strcat(s,t);
          }
        if (vgeneric->dn4_logic) strcat(s,"-");
        if (vgeneric->name4_flag)
          {
            sprintf(t,"%s ",vgeneric->name4_string);
            strcat(s,t);
          }
        if (vgeneric->val4_flag)
          {
            sprintf(t,"%s ",vgeneric->val4_string);
            strcat(s,t);
          }
        if (vgeneric->dn5_logic) strcat(s,"-");
        if (vgeneric->name5_flag)
          {
            sprintf(t,"%s ",vgeneric->name5_string);
            strcat(s,t);
          }
        if (vgeneric->val5_flag)
          {
            sprintf(t,"%s ",vgeneric->val5_string);
            strcat(s,t);
          }
        if (vgeneric->dn6_logic) strcat(s,"-");
        if (vgeneric->name6_flag)
          {
            sprintf(t,"%s ",vgeneric->name6_string);
            strcat(s,t);
          }
        if (vgeneric->val6_flag)
          {
            sprintf(t,"%s ",vgeneric->val6_string);
            strcat(s,t);
          }
        if (vgeneric->dn7_logic) strcat(s,"-");
        if (vgeneric->name7_flag)
          {
            sprintf(t,"%s ",vgeneric->name7_string);
            strcat(s,t);
          }
        if (vgeneric->val7_flag)
          {
            sprintf(t,"%s ",vgeneric->val7_string);
            strcat(s,t);
          }
        if (vgeneric->dn8_logic) strcat(s,"-");
        if (vgeneric->name8_flag)
          {
            sprintf(t,"%s ",vgeneric->name8_string);
            strcat(s,t);
          }
        if (vgeneric->val8_flag)
          {
            sprintf(t,"%s ",vgeneric->val8_string);
            strcat(s,t);
          }

        /* Put on the trailer */
        if (vgeneric->trailer_flag)
          {
            sprintf(t,"%s ",vgeneric->trailer_string);
            strcat(s,t);
          }
/* -main_before_lib_call_end */

/* -main_library_call */
        system(s);
/* -main_library_call_end */

/* -main_after_lib_call */
        if (vgeneric->o_flag) writeimage(vgeneric->o_file,image);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vgeneric 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vgeneric :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tGeneric routine interface\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-di1  selects minus sign (TRUE) or blank (FALSE) for input name #1  (boolean)\n");
	fprintf(stderr,"\t-di2  selects minus sign (TRUE) or blank (FALSE) for input name #2  (boolean)\n");
	fprintf(stderr,"\t-di3  selects minus sign (TRUE) or blank (FALSE) for input name #3  (boolean)\n");
	fprintf(stderr,"\t-do1  selects minus sign (TRUE) or blank (FALSE) for output name #1  (boolean)\n");
	fprintf(stderr,"\t-do2  selects minus sign (TRUE) or blank (FALSE) for output name #2  (boolean)\n");
	fprintf(stderr,"\t-do3  selects minus sign (TRUE) or blank (FALSE) for output name #3  (boolean)\n");
	fprintf(stderr,"\t-dn1  selects minus sign (TRUE) or blank (FALSE) for arg name #1  (boolean)\n");
	fprintf(stderr,"\t-dn2  selects minus sign (TRUE) or blank (FALSE) for arg name #2  (boolean)\n");
	fprintf(stderr,"\t-dn3  selects minus sign (TRUE) or blank (FALSE) for arg name #3  (boolean)\n");
	fprintf(stderr,"\t-dn4  selects minus sign (TRUE) or blank (FALSE) for arg name #4  (boolean)\n");
	fprintf(stderr,"\t-dn5  selects minus sign (TRUE) or blank (FALSE) for arg name #5  (boolean)\n");
	fprintf(stderr,"\t-dn6  selects minus sign (TRUE) or blank (FALSE) for arg name #6  (boolean)\n");
	fprintf(stderr,"\t-dn7  selects minus sign (TRUE) or blank (FALSE) for arg name #7  (boolean)\n");
	fprintf(stderr,"\t-dn8  selects minus sign (TRUE) or blank (FALSE) for arg name #8  (boolean)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-prefix]  prefix string (string) [null]\n");
	fprintf(stderr,"\t[-i]  input image (infile) [null]\n");
	fprintf(stderr,"\t[-o]  output image or file (outfile) [null]\n");
	fprintf(stderr,"\t[-iname1]  name of input argument #1 (string) [null]\n");
	fprintf(stderr,"\t[-i1]  input filename #1 (infile) [null]\n");
	fprintf(stderr,"\t[-iname2]  name of input argument #2 (string) [null]\n");
	fprintf(stderr,"\t[-i2]  input filename #2 (infile) [null]\n");
	fprintf(stderr,"\t[-iname3]  name of input argument #3 (string) [null]\n");
	fprintf(stderr,"\t[-i3]  input filename #3 (infile) [null]\n");
	fprintf(stderr,"\t[-oname1]  name of output argument #1 (string) [null]\n");
	fprintf(stderr,"\t[-o1]  output filename #1 (outfile) [null]\n");
	fprintf(stderr,"\t[-oname2]  name of output argument #2 (string) [null]\n");
	fprintf(stderr,"\t[-o2]  output filename #2 (outfile) [null]\n");
	fprintf(stderr,"\t[-oname3]  name of output argument #3 (string) [null]\n");
	fprintf(stderr,"\t[-o3]  output filename #3 (outfile) [null]\n");
	fprintf(stderr,"\t[-name1]  Name of argument #1 (string) [null]\n");
	fprintf(stderr,"\t[-val1]  argument #1 value (string) [null]\n");
	fprintf(stderr,"\t[-name2]  Name of argument #2 (string) [null]\n");
	fprintf(stderr,"\t[-val2]  argument #2 value (string) [null]\n");
	fprintf(stderr,"\t[-name3]  Name of argument #3 (string) [null]\n");
	fprintf(stderr,"\t[-val3]  argument #3 value (string) [null]\n");
	fprintf(stderr,"\t[-name4]  Name of argument #4 (string) [null]\n");
	fprintf(stderr,"\t[-val4]  argument #4 value (string) [null]\n");
	fprintf(stderr,"\t[-name5]  Name of argument #5 (string) [null]\n");
	fprintf(stderr,"\t[-val5]  argument #5 value (string) [null]\n");
	fprintf(stderr,"\t[-name6]  Name of argument #6 (string) [null]\n");
	fprintf(stderr,"\t[-val6]  argument #6 value (string) [null]\n");
	fprintf(stderr,"\t[-name7]  Name of argument #7 (string) [null]\n");
	fprintf(stderr,"\t[-val7]  argument #7 value (string) [null]\n");
	fprintf(stderr,"\t[-name8]  Name of argument #8 (string) [null]\n");
	fprintf(stderr,"\t[-val8]  argument #8 value (string) [null]\n");
	fprintf(stderr,"\t[-trailer]  trailer string (string) [null]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vgeneric\n");
	fprintf(stderr, "\t[-U] Gives the usage for vgeneric\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vgeneric.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vgeneric.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vgeneric
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*di1_pstr = 
	"\nEnter: (di1) selects minus sign (TRUE) or blank (FALSE) for input name #1 \n        {boolean, (y/n) }: "; 
char	*di2_pstr = 
	"\nEnter: (di2) selects minus sign (TRUE) or blank (FALSE) for input name #2 \n        {boolean, (y/n) }: "; 
char	*di3_pstr = 
	"\nEnter: (di3) selects minus sign (TRUE) or blank (FALSE) for input name #3 \n        {boolean, (y/n) }: "; 
char	*do1_pstr = 
	"\nEnter: (do1) selects minus sign (TRUE) or blank (FALSE) for output name #1 \n        {boolean, (y/n) }: "; 
char	*do2_pstr = 
	"\nEnter: (do2) selects minus sign (TRUE) or blank (FALSE) for output name #2 \n        {boolean, (y/n) }: "; 
char	*do3_pstr = 
	"\nEnter: (do3) selects minus sign (TRUE) or blank (FALSE) for output name #3 \n        {boolean, (y/n) }: "; 
char	*dn1_pstr = 
	"\nEnter: (dn1) selects minus sign (TRUE) or blank (FALSE) for arg name #1 \n        {boolean, (y/n) }: "; 
char	*dn2_pstr = 
	"\nEnter: (dn2) selects minus sign (TRUE) or blank (FALSE) for arg name #2 \n        {boolean, (y/n) }: "; 
char	*dn3_pstr = 
	"\nEnter: (dn3) selects minus sign (TRUE) or blank (FALSE) for arg name #3 \n        {boolean, (y/n) }: "; 
char	*dn4_pstr = 
	"\nEnter: (dn4) selects minus sign (TRUE) or blank (FALSE) for arg name #4 \n        {boolean, (y/n) }: "; 
char	*dn5_pstr = 
	"\nEnter: (dn5) selects minus sign (TRUE) or blank (FALSE) for arg name #5 \n        {boolean, (y/n) }: "; 
char	*dn6_pstr = 
	"\nEnter: (dn6) selects minus sign (TRUE) or blank (FALSE) for arg name #6 \n        {boolean, (y/n) }: "; 
char	*dn7_pstr = 
	"\nEnter: (dn7) selects minus sign (TRUE) or blank (FALSE) for arg name #7 \n        {boolean, (y/n) }: "; 
char	*dn8_pstr = 
	"\nEnter: (dn8) selects minus sign (TRUE) or blank (FALSE) for arg name #8 \n        {boolean, (y/n) }: "; 
char	*prefix_pstr = 
	"\nEnter: (prefix) prefix string \n        {string}: "; 
char	*prefix_def = NULL;
char	*i_pstr = 
	"\nEnter: (i) input image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) output image or file \n        {outfile}: "; 
char	*iname1_pstr = 
	"\nEnter: (iname1) name of input argument #1 \n        {string}: "; 
char	*iname1_def = NULL;
char	*i1_pstr = 
	"\nEnter: (i1) input filename #1 \n        {infile}: "; 
char	*iname2_pstr = 
	"\nEnter: (iname2) name of input argument #2 \n        {string}: "; 
char	*iname2_def = NULL;
char	*i2_pstr = 
	"\nEnter: (i2) input filename #2 \n        {infile}: "; 
char	*iname3_pstr = 
	"\nEnter: (iname3) name of input argument #3 \n        {string}: "; 
char	*iname3_def = NULL;
char	*i3_pstr = 
	"\nEnter: (i3) input filename #3 \n        {infile}: "; 
char	*oname1_pstr = 
	"\nEnter: (oname1) name of output argument #1 \n        {string}: "; 
char	*oname1_def = NULL;
char	*o1_pstr = 
	"\nEnter: (o1) output filename #1 \n        {outfile}: "; 
char	*oname2_pstr = 
	"\nEnter: (oname2) name of output argument #2 \n        {string}: "; 
char	*oname2_def = NULL;
char	*o2_pstr = 
	"\nEnter: (o2) output filename #2 \n        {outfile}: "; 
char	*oname3_pstr = 
	"\nEnter: (oname3) name of output argument #3 \n        {string}: "; 
char	*oname3_def = NULL;
char	*o3_pstr = 
	"\nEnter: (o3) output filename #3 \n        {outfile}: "; 
char	*name1_pstr = 
	"\nEnter: (name1) Name of argument #1 \n        {string}: "; 
char	*name1_def = NULL;
char	*val1_pstr = 
	"\nEnter: (val1) argument #1 value \n        {string}: "; 
char	*val1_def = NULL;
char	*name2_pstr = 
	"\nEnter: (name2) Name of argument #2 \n        {string}: "; 
char	*name2_def = NULL;
char	*val2_pstr = 
	"\nEnter: (val2) argument #2 value \n        {string}: "; 
char	*val2_def = NULL;
char	*name3_pstr = 
	"\nEnter: (name3) Name of argument #3 \n        {string}: "; 
char	*name3_def = NULL;
char	*val3_pstr = 
	"\nEnter: (val3) argument #3 value \n        {string}: "; 
char	*val3_def = NULL;
char	*name4_pstr = 
	"\nEnter: (name4) Name of argument #4 \n        {string}: "; 
char	*name4_def = NULL;
char	*val4_pstr = 
	"\nEnter: (val4) argument #4 value \n        {string}: "; 
char	*val4_def = NULL;
char	*name5_pstr = 
	"\nEnter: (name5) Name of argument #5 \n        {string}: "; 
char	*name5_def = NULL;
char	*val5_pstr = 
	"\nEnter: (val5) argument #5 value \n        {string}: "; 
char	*val5_def = NULL;
char	*name6_pstr = 
	"\nEnter: (name6) Name of argument #6 \n        {string}: "; 
char	*name6_def = NULL;
char	*val6_pstr = 
	"\nEnter: (val6) argument #6 value \n        {string}: "; 
char	*val6_def = NULL;
char	*name7_pstr = 
	"\nEnter: (name7) Name of argument #7 \n        {string}: "; 
char	*name7_def = NULL;
char	*val7_pstr = 
	"\nEnter: (val7) argument #7 value \n        {string}: "; 
char	*val7_def = NULL;
char	*name8_pstr = 
	"\nEnter: (name8) Name of argument #8 \n        {string}: "; 
char	*name8_def = NULL;
char	*val8_pstr = 
	"\nEnter: (val8) argument #8 value \n        {string}: "; 
char	*val8_def = NULL;
char	*trailer_pstr = 
	"\nEnter: (trailer) trailer string \n        {string}: "; 
char	*trailer_def = NULL;
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vgeneric", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vgeneric.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vgeneric: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vgeneric.ans");
		}

	     }

	}

	/*
	 * allocate the vgeneric structure
	 */
	vgeneric = (vgeneric_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vgeneric_struct));

	/*
	 * get required arguments for vgeneric
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vgeneric->di1_flag = vget_logic(fid, prompt_flag,
			"-di1", di1_pstr, &(vgeneric->di1_logic), 0)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vgeneric->di1_flag))
		{
		    fprintf(stderr, "\t\tdi1 is required, please re-enter: \n");
		    vgeneric->di1_flag = vget_logic(fid, prompt_flag,
		    "-di1", di1_pstr, &(vgeneric->di1_logic), 0);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-di1' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vgeneric->di2_flag = vget_logic(fid, prompt_flag,
			"-di2", di2_pstr, &(vgeneric->di2_logic), 0)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vgeneric->di2_flag))
		{
		    fprintf(stderr, "\t\tdi2 is required, please re-enter: \n");
		    vgeneric->di2_flag = vget_logic(fid, prompt_flag,
		    "-di2", di2_pstr, &(vgeneric->di2_logic), 0);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-di2' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vgeneric->di3_flag = vget_logic(fid, prompt_flag,
			"-di3", di3_pstr, &(vgeneric->di3_logic), 0)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vgeneric->di3_flag))
		{
		    fprintf(stderr, "\t\tdi3 is required, please re-enter: \n");
		    vgeneric->di3_flag = vget_logic(fid, prompt_flag,
		    "-di3", di3_pstr, &(vgeneric->di3_logic), 0);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-di3' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vgeneric->do1_flag = vget_logic(fid, prompt_flag,
			"-do1", do1_pstr, &(vgeneric->do1_logic), 0)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vgeneric->do1_flag))
		{
		    fprintf(stderr, "\t\tdo1 is required, please re-enter: \n");
		    vgeneric->do1_flag = vget_logic(fid, prompt_flag,
		    "-do1", do1_pstr, &(vgeneric->do1_logic), 0);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-do1' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vgeneric->do2_flag = vget_logic(fid, prompt_flag,
			"-do2", do2_pstr, &(vgeneric->do2_logic), 0)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vgeneric->do2_flag))
		{
		    fprintf(stderr, "\t\tdo2 is required, please re-enter: \n");
		    vgeneric->do2_flag = vget_logic(fid, prompt_flag,
		    "-do2", do2_pstr, &(vgeneric->do2_logic), 0);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-do2' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vgeneric->do3_flag = vget_logic(fid, prompt_flag,
			"-do3", do3_pstr, &(vgeneric->do3_logic), 0)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vgeneric->do3_flag))
		{
		    fprintf(stderr, "\t\tdo3 is required, please re-enter: \n");
		    vgeneric->do3_flag = vget_logic(fid, prompt_flag,
		    "-do3", do3_pstr, &(vgeneric->do3_logic), 0);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-do3' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vgeneric->dn1_flag = vget_logic(fid, prompt_flag,
			"-dn1", dn1_pstr, &(vgeneric->dn1_logic), 0)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vgeneric->dn1_flag))
		{
		    fprintf(stderr, "\t\tdn1 is required, please re-enter: \n");
		    vgeneric->dn1_flag = vget_logic(fid, prompt_flag,
		    "-dn1", dn1_pstr, &(vgeneric->dn1_logic), 0);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-dn1' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vgeneric->dn2_flag = vget_logic(fid, prompt_flag,
			"-dn2", dn2_pstr, &(vgeneric->dn2_logic), 0)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vgeneric->dn2_flag))
		{
		    fprintf(stderr, "\t\tdn2 is required, please re-enter: \n");
		    vgeneric->dn2_flag = vget_logic(fid, prompt_flag,
		    "-dn2", dn2_pstr, &(vgeneric->dn2_logic), 0);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-dn2' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vgeneric->dn3_flag = vget_logic(fid, prompt_flag,
			"-dn3", dn3_pstr, &(vgeneric->dn3_logic), 0)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vgeneric->dn3_flag))
		{
		    fprintf(stderr, "\t\tdn3 is required, please re-enter: \n");
		    vgeneric->dn3_flag = vget_logic(fid, prompt_flag,
		    "-dn3", dn3_pstr, &(vgeneric->dn3_logic), 0);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-dn3' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vgeneric->dn4_flag = vget_logic(fid, prompt_flag,
			"-dn4", dn4_pstr, &(vgeneric->dn4_logic), 0)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vgeneric->dn4_flag))
		{
		    fprintf(stderr, "\t\tdn4 is required, please re-enter: \n");
		    vgeneric->dn4_flag = vget_logic(fid, prompt_flag,
		    "-dn4", dn4_pstr, &(vgeneric->dn4_logic), 0);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-dn4' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vgeneric->dn5_flag = vget_logic(fid, prompt_flag,
			"-dn5", dn5_pstr, &(vgeneric->dn5_logic), 0)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vgeneric->dn5_flag))
		{
		    fprintf(stderr, "\t\tdn5 is required, please re-enter: \n");
		    vgeneric->dn5_flag = vget_logic(fid, prompt_flag,
		    "-dn5", dn5_pstr, &(vgeneric->dn5_logic), 0);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-dn5' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vgeneric->dn6_flag = vget_logic(fid, prompt_flag,
			"-dn6", dn6_pstr, &(vgeneric->dn6_logic), 0)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vgeneric->dn6_flag))
		{
		    fprintf(stderr, "\t\tdn6 is required, please re-enter: \n");
		    vgeneric->dn6_flag = vget_logic(fid, prompt_flag,
		    "-dn6", dn6_pstr, &(vgeneric->dn6_logic), 0);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-dn6' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vgeneric->dn7_flag = vget_logic(fid, prompt_flag,
			"-dn7", dn7_pstr, &(vgeneric->dn7_logic), 0)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vgeneric->dn7_flag))
		{
		    fprintf(stderr, "\t\tdn7 is required, please re-enter: \n");
		    vgeneric->dn7_flag = vget_logic(fid, prompt_flag,
		    "-dn7", dn7_pstr, &(vgeneric->dn7_logic), 0);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-dn7' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vgeneric->dn8_flag = vget_logic(fid, prompt_flag,
			"-dn8", dn8_pstr, &(vgeneric->dn8_logic), 0)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vgeneric->dn8_flag))
		{
		    fprintf(stderr, "\t\tdn8 is required, please re-enter: \n");
		    vgeneric->dn8_flag = vget_logic(fid, prompt_flag,
		    "-dn8", dn8_pstr, &(vgeneric->dn8_logic), 0);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-dn8' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vgeneric
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vgeneric->prefix_flag = vget_string(fid, prompt_flag,
	"-prefix", prefix_pstr, &(vgeneric->prefix_string),
	prefix_def);

	if (prompt_flag == FALSE)
	{
	    if ((vgeneric->prefix_flag == 1)&&(vgeneric->prefix_string == NULL))
    	{
		fprintf(stderr, "vgeneric:\n");
		fprintf(stderr, "you must specify a name following '-prefix'\n");
		gw_usage();
		exit(1);
		}
	}
	vgeneric->i_flag = vget_infile(fid, prompt_flag,
	"-i", i_pstr, &(vgeneric->i_file))
;

	vgeneric->o_flag = vget_outfile(fid, prompt_flag,
	"-o", o_pstr, &(vgeneric->o_file))
;

	vgeneric->iname1_flag = vget_string(fid, prompt_flag,
	"-iname1", iname1_pstr, &(vgeneric->iname1_string),
	iname1_def);

	if (prompt_flag == FALSE)
	{
	    if ((vgeneric->iname1_flag == 1)&&(vgeneric->iname1_string == NULL))
    	{
		fprintf(stderr, "vgeneric:\n");
		fprintf(stderr, "you must specify a name following '-iname1'\n");
		gw_usage();
		exit(1);
		}
	}
	vgeneric->i1_flag = vget_infile(fid, prompt_flag,
	"-i1", i1_pstr, &(vgeneric->i1_file))
;

	vgeneric->iname2_flag = vget_string(fid, prompt_flag,
	"-iname2", iname2_pstr, &(vgeneric->iname2_string),
	iname2_def);

	if (prompt_flag == FALSE)
	{
	    if ((vgeneric->iname2_flag == 1)&&(vgeneric->iname2_string == NULL))
    	{
		fprintf(stderr, "vgeneric:\n");
		fprintf(stderr, "you must specify a name following '-iname2'\n");
		gw_usage();
		exit(1);
		}
	}
	vgeneric->i2_flag = vget_infile(fid, prompt_flag,
	"-i2", i2_pstr, &(vgeneric->i2_file))
;

	vgeneric->iname3_flag = vget_string(fid, prompt_flag,
	"-iname3", iname3_pstr, &(vgeneric->iname3_string),
	iname3_def);

	if (prompt_flag == FALSE)
	{
	    if ((vgeneric->iname3_flag == 1)&&(vgeneric->iname3_string == NULL))
    	{
		fprintf(stderr, "vgeneric:\n");
		fprintf(stderr, "you must specify a name following '-iname3'\n");
		gw_usage();
		exit(1);
		}
	}
	vgeneric->i3_flag = vget_infile(fid, prompt_flag,
	"-i3", i3_pstr, &(vgeneric->i3_file))
;

	vgeneric->oname1_flag = vget_string(fid, prompt_flag,
	"-oname1", oname1_pstr, &(vgeneric->oname1_string),
	oname1_def);

	if (prompt_flag == FALSE)
	{
	    if ((vgeneric->oname1_flag == 1)&&(vgeneric->oname1_string == NULL))
    	{
		fprintf(stderr, "vgeneric:\n");
		fprintf(stderr, "you must specify a name following '-oname1'\n");
		gw_usage();
		exit(1);
		}
	}
	vgeneric->o1_flag = vget_outfile(fid, prompt_flag,
	"-o1", o1_pstr, &(vgeneric->o1_file))
;

	vgeneric->oname2_flag = vget_string(fid, prompt_flag,
	"-oname2", oname2_pstr, &(vgeneric->oname2_string),
	oname2_def);

	if (prompt_flag == FALSE)
	{
	    if ((vgeneric->oname2_flag == 1)&&(vgeneric->oname2_string == NULL))
    	{
		fprintf(stderr, "vgeneric:\n");
		fprintf(stderr, "you must specify a name following '-oname2'\n");
		gw_usage();
		exit(1);
		}
	}
	vgeneric->o2_flag = vget_outfile(fid, prompt_flag,
	"-o2", o2_pstr, &(vgeneric->o2_file))
;

	vgeneric->oname3_flag = vget_string(fid, prompt_flag,
	"-oname3", oname3_pstr, &(vgeneric->oname3_string),
	oname3_def);

	if (prompt_flag == FALSE)
	{
	    if ((vgeneric->oname3_flag == 1)&&(vgeneric->oname3_string == NULL))
    	{
		fprintf(stderr, "vgeneric:\n");
		fprintf(stderr, "you must specify a name following '-oname3'\n");
		gw_usage();
		exit(1);
		}
	}
	vgeneric->o3_flag = vget_outfile(fid, prompt_flag,
	"-o3", o3_pstr, &(vgeneric->o3_file))
;

	vgeneric->name1_flag = vget_string(fid, prompt_flag,
	"-name1", name1_pstr, &(vgeneric->name1_string),
	name1_def);

	if (prompt_flag == FALSE)
	{
	    if ((vgeneric->name1_flag == 1)&&(vgeneric->name1_string == NULL))
    	{
		fprintf(stderr, "vgeneric:\n");
		fprintf(stderr, "you must specify a name following '-name1'\n");
		gw_usage();
		exit(1);
		}
	}
	vgeneric->val1_flag = vget_string(fid, prompt_flag,
	"-val1", val1_pstr, &(vgeneric->val1_string),
	val1_def);

	if (prompt_flag == FALSE)
	{
	    if ((vgeneric->val1_flag == 1)&&(vgeneric->val1_string == NULL))
    	{
		fprintf(stderr, "vgeneric:\n");
		fprintf(stderr, "you must specify a name following '-val1'\n");
		gw_usage();
		exit(1);
		}
	}
	vgeneric->name2_flag = vget_string(fid, prompt_flag,
	"-name2", name2_pstr, &(vgeneric->name2_string),
	name2_def);

	if (prompt_flag == FALSE)
	{
	    if ((vgeneric->name2_flag == 1)&&(vgeneric->name2_string == NULL))
    	{
		fprintf(stderr, "vgeneric:\n");
		fprintf(stderr, "you must specify a name following '-name2'\n");
		gw_usage();
		exit(1);
		}
	}
	vgeneric->val2_flag = vget_string(fid, prompt_flag,
	"-val2", val2_pstr, &(vgeneric->val2_string),
	val2_def);

	if (prompt_flag == FALSE)
	{
	    if ((vgeneric->val2_flag == 1)&&(vgeneric->val2_string == NULL))
    	{
		fprintf(stderr, "vgeneric:\n");
		fprintf(stderr, "you must specify a name following '-val2'\n");
		gw_usage();
		exit(1);
		}
	}
	vgeneric->name3_flag = vget_string(fid, prompt_flag,
	"-name3", name3_pstr, &(vgeneric->name3_string),
	name3_def);

	if (prompt_flag == FALSE)
	{
	    if ((vgeneric->name3_flag == 1)&&(vgeneric->name3_string == NULL))
    	{
		fprintf(stderr, "vgeneric:\n");
		fprintf(stderr, "you must specify a name following '-name3'\n");
		gw_usage();
		exit(1);
		}
	}
	vgeneric->val3_flag = vget_string(fid, prompt_flag,
	"-val3", val3_pstr, &(vgeneric->val3_string),
	val3_def);

	if (prompt_flag == FALSE)
	{
	    if ((vgeneric->val3_flag == 1)&&(vgeneric->val3_string == NULL))
    	{
		fprintf(stderr, "vgeneric:\n");
		fprintf(stderr, "you must specify a name following '-val3'\n");
		gw_usage();
		exit(1);
		}
	}
	vgeneric->name4_flag = vget_string(fid, prompt_flag,
	"-name4", name4_pstr, &(vgeneric->name4_string),
	name4_def);

	if (prompt_flag == FALSE)
	{
	    if ((vgeneric->name4_flag == 1)&&(vgeneric->name4_string == NULL))
    	{
		fprintf(stderr, "vgeneric:\n");
		fprintf(stderr, "you must specify a name following '-name4'\n");
		gw_usage();
		exit(1);
		}
	}
	vgeneric->val4_flag = vget_string(fid, prompt_flag,
	"-val4", val4_pstr, &(vgeneric->val4_string),
	val4_def);

	if (prompt_flag == FALSE)
	{
	    if ((vgeneric->val4_flag == 1)&&(vgeneric->val4_string == NULL))
    	{
		fprintf(stderr, "vgeneric:\n");
		fprintf(stderr, "you must specify a name following '-val4'\n");
		gw_usage();
		exit(1);
		}
	}
	vgeneric->name5_flag = vget_string(fid, prompt_flag,
	"-name5", name5_pstr, &(vgeneric->name5_string),
	name5_def);

	if (prompt_flag == FALSE)
	{
	    if ((vgeneric->name5_flag == 1)&&(vgeneric->name5_string == NULL))
    	{
		fprintf(stderr, "vgeneric:\n");
		fprintf(stderr, "you must specify a name following '-name5'\n");
		gw_usage();
		exit(1);
		}
	}
	vgeneric->val5_flag = vget_string(fid, prompt_flag,
	"-val5", val5_pstr, &(vgeneric->val5_string),
	val5_def);

	if (prompt_flag == FALSE)
	{
	    if ((vgeneric->val5_flag == 1)&&(vgeneric->val5_string == NULL))
    	{
		fprintf(stderr, "vgeneric:\n");
		fprintf(stderr, "you must specify a name following '-val5'\n");
		gw_usage();
		exit(1);
		}
	}
	vgeneric->name6_flag = vget_string(fid, prompt_flag,
	"-name6", name6_pstr, &(vgeneric->name6_string),
	name6_def);

	if (prompt_flag == FALSE)
	{
	    if ((vgeneric->name6_flag == 1)&&(vgeneric->name6_string == NULL))
    	{
		fprintf(stderr, "vgeneric:\n");
		fprintf(stderr, "you must specify a name following '-name6'\n");
		gw_usage();
		exit(1);
		}
	}
	vgeneric->val6_flag = vget_string(fid, prompt_flag,
	"-val6", val6_pstr, &(vgeneric->val6_string),
	val6_def);

	if (prompt_flag == FALSE)
	{
	    if ((vgeneric->val6_flag == 1)&&(vgeneric->val6_string == NULL))
    	{
		fprintf(stderr, "vgeneric:\n");
		fprintf(stderr, "you must specify a name following '-val6'\n");
		gw_usage();
		exit(1);
		}
	}
	vgeneric->name7_flag = vget_string(fid, prompt_flag,
	"-name7", name7_pstr, &(vgeneric->name7_string),
	name7_def);

	if (prompt_flag == FALSE)
	{
	    if ((vgeneric->name7_flag == 1)&&(vgeneric->name7_string == NULL))
    	{
		fprintf(stderr, "vgeneric:\n");
		fprintf(stderr, "you must specify a name following '-name7'\n");
		gw_usage();
		exit(1);
		}
	}
	vgeneric->val7_flag = vget_string(fid, prompt_flag,
	"-val7", val7_pstr, &(vgeneric->val7_string),
	val7_def);

	if (prompt_flag == FALSE)
	{
	    if ((vgeneric->val7_flag == 1)&&(vgeneric->val7_string == NULL))
    	{
		fprintf(stderr, "vgeneric:\n");
		fprintf(stderr, "you must specify a name following '-val7'\n");
		gw_usage();
		exit(1);
		}
	}
	vgeneric->name8_flag = vget_string(fid, prompt_flag,
	"-name8", name8_pstr, &(vgeneric->name8_string),
	name8_def);

	if (prompt_flag == FALSE)
	{
	    if ((vgeneric->name8_flag == 1)&&(vgeneric->name8_string == NULL))
    	{
		fprintf(stderr, "vgeneric:\n");
		fprintf(stderr, "you must specify a name following '-name8'\n");
		gw_usage();
		exit(1);
		}
	}
	vgeneric->val8_flag = vget_string(fid, prompt_flag,
	"-val8", val8_pstr, &(vgeneric->val8_string),
	val8_def);

	if (prompt_flag == FALSE)
	{
	    if ((vgeneric->val8_flag == 1)&&(vgeneric->val8_string == NULL))
    	{
		fprintf(stderr, "vgeneric:\n");
		fprintf(stderr, "you must specify a name following '-val8'\n");
		gw_usage();
		exit(1);
		}
	}
	vgeneric->trailer_flag = vget_string(fid, prompt_flag,
	"-trailer", trailer_pstr, &(vgeneric->trailer_string),
	trailer_def);

	if (prompt_flag == FALSE)
	{
	    if ((vgeneric->trailer_flag == 1)&&(vgeneric->trailer_string == NULL))
    	{
		fprintf(stderr, "vgeneric:\n");
		fprintf(stderr, "you must specify a name following '-trailer'\n");
		gw_usage();
		exit(1);
		}
	}

}



