/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvblurlace.c
 >>>>
 >>>>      Program Name: vblurlace
 >>>>
 >>>> Date Last Updated: Mon Apr 15 22:13:20 1991 
 >>>>
 >>>>          Routines: lvblurlace - the library call for vblurlace
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvblurlace - library call for vblurlace
*
* Purpose:
*    
*    Corrects motion blur in images acquired in video  interlaced
*    mode.
*    
*    
* Input:
*    
*    image          (struct xvimage) - input/output image structure
*    
*    offset         (int) - positive (right) or negative (left)  pixel
*                   shift value
*    
*    
* Output:
*    
*    image          (struct xvimage) - input/output image structure
*    
*    
*
* Written By: Donna Koechner, John Rasure
*    
*    Mon Jun 11 15:30:43 MDT 1990 Donna  Koechner  -  updated  to
*    ghostwriter
*    
*    
****************************************************************/


/* -library_def */
int
lvblurlace(image,offset)
struct xvimage  *image;
int             offset;
/* -library_def_end */

/* -library_code */
{
        unsigned char *data;
        int row, col;

        data = (unsigned char *) image->imagedata;

        if (offset == 0) return(1);

        if (offset > image->row_size)
          (void) fprintf(stderr,"offset is larger than row_size");

        if( offset < 0)
        {
        for (row=1; row < image->col_size-1; row+=2)
                for (col=0; col < image->row_size; col++)
                    data[row*image->row_size + col] = 
                    data[row*image->row_size + col - offset];
        }
        if( offset > 0)
        {
        for (row=1; row < image->col_size-1; row+=2)
                for (col= image->row_size-1 ; col > -1; col--)
                    data[row*image->row_size + col] = 
                    data[row*image->row_size + col - offset];
        }
        return(1);  /* success */
}

/* -library_code_end */
