'\"t
.if t .TH IMVIFF 3IM "August 24, 1992" "San Diego Supercomputer Center" "SDSC IMAGE LIBRARY"
.if n .TH IMVIFF 3IM "August 24, 1992" "SDSC" "SDSC IMAGE LIBRARY"
.SH NAME
imviff \- Khoros VIFF file translation
.SH SYNOPSIS
.nf
\fB
#include <stdio.h>
#include "sdsc.h"
#include "im.h"
.sp 1
int ImFileRead( fd, "viff", flagsTable, dataTable )
	int         fd;
	TagTable   *flagsTable;
	TagTable   *dataTable;
.sp 1
int ImFileFRead( fp, "viff", flagsTable, dataTable )
	FILE         *fp;
	TagTable   *flagsTable;
	TagTable   *dataTable;
.sp 1
int ImFileWrite( fd, "viff", flagsTable, dataTable )
	int         fd;
	TagTable   *flagsTable;
	TagTable   *dataTable;
.sp 1
int ImFileFWrite( fp, "viff", flagsTable, dataTable )
	FILE         *fp;
	TagTable   *flagsTable;
	TagTable   *dataTable;
\fR
.fi
.SH DESCRIPTION
.LP
\fBViff\fR image files are generated by the Khoros Image Processing package
from the University of New Mexico.
.SH "FILE RECOGNITION"
Khoros \fBviff\fR files are recognized by the following
filename suffixes:  .xv and .viff.
.SH NOTES
SDSC image library support of the 
Khoros \fBviff\fR format does not require
use of any Khoros libraries and contains no proprietary code.  
Khoros \fBviff\fR format handling
is available on any machine for which the SDSC image library is available.
.SS "Reading Khoros VIFF files"
The SDSC image library reads single-image files containing uncompressed
images with 1 or 3 data bands of implicit 1- or 2-byte data.
Single-band 1-bit images are read into \fBIMVFBMONO\fR VFBs,
single-band 8-bit images are read into \fBIMVFBINDEX8\fR VFBs,
single-band 16-bit images are read into \fBIMVFBINDEX16\fR VFBs, and
3-band 8-bit image data is read into \fBIMVFBRGB\fR VFBs.
Color tables, if any, are read in and associated with the VFB.
.SS "Writing Khoros Viff files"
Image library \fBIMVFBRGB\fR VFBs are written as 3-band 8-bit per channel
uncompressed images with or without a color lookup table.
\fBIMVFBINDEX8\fR and \fBIMVFBINDEX16\fR images are written as single-band
8-bit or 16-bit uncompressed images with or without color lookup tables.
Finally, \fBIMVFBMONO\fR images are written as single-band 1-bit uncompressed
images without color lookup tables.
.LP
Other image library VFB types are converted to \fBIMVFBMONO\fR,
\fBIMVFBINDEX8\fR, \fBIMVFBINDEX16\fR, or \fBIMVFBRGB\fR VFB's
prior to being written out.  See the
\fBImFileWrite\fR(3IM) \fBman\fP page for details.
.SH ERRORS
In addition to those listed for \fBImFileRead\fR(3IM),
Khoros \fBVIFF\fR file reading returns the following error codes:
.ne 4
.LP
.if t .in +0.5i
.if n .in +5
.TS
l l.
IMEMALLOC       Cannot allocate enough memory
IMESYNTAX       Not a Viff image
IMESYNTAX       Unacceptable byte ordering
IMESYNTAX       Can only deal with implicit images
IMESYNTAX       Unacceptable data storage type for image	
IMESYNTAX       Unacceptable data storage type for map data
IMESYNTAX       Unacceptable encoding scheme for image
IMESYNTAX       Unacceptable color space scheme
IMESYNTAX       Only 1 image allowed
IMESYNTAX       Only 1 or 3 data bands allowed
.TE
.if t .in -0.5i
.if n .in -5
.LP
.SH DOCUMENTATION
\fIKhoros Programmers Manual, Volume II, Chapter 1\fR,
University of New Mexico, 1991.
.SH "SEE ALSO"
\fBImIntro\fR(3IM),
\fBImErrNo\fR(3IM),
\fBimconv\fR(1IM),
\fBimfile\fR(1IM),
\fBimformats\fR(1IM)
.SH AUTHOR
Chris Groening 
.br
San Diego Supercomputer Center
.SH CONTACT
SDSC consultants, (619)534-5100, \fBconsult@y1.sdsc.edu\fR
.br
