'\"et
.if t .TH IMPCX 3IM "August 24, 1992" "San Diego Supercomputer Center" "SDSC IMAGE LIBRARY"
.if n .TH IMPCX 3IM "August 24, 1992" "SDSC" "SDSC IMAGE LIBRARY"
.SH NAME
impcx \- ZSoft IBM PC Paintbrush file translation
.SH SYNOPSIS
.nf
\fB
#include <stdio.h>
#include "sdsc.h"
#include "im.h"
.sp 1
int ImFileRead( fd, "pcx", flagsTable, dataTable )
	int         fd;
	TagTable   *flagsTable;
	TagTable   *dataTable;
.sp 1
int ImFileFRead( fp, "pcx", flagsTable, dataTable )
	FILE         *fp;
	TagTable   *flagsTable;
	TagTable   *dataTable;
.sp 1
int ImFileWrite( fd, "pcx", flagsTable, dataTable )
	int         fd;
	TagTable   *flagsTable;
	TagTable   *dataTable;
.sp 1
int ImFileFWrite( fp, "pcx", flagsTable, dataTable )
	FILE         *fp;
	TagTable   *flagsTable;
	TagTable   *dataTable;
\fR
.fi
.SH DESCRIPTION
The \fBpcx\fR image file format was invented by ZSoft for use in its IBM PC
\fBPC Paintbrush\fR tool series.  It has become a defacto standard
in the IBM PC world and is regularly used for the storage
of monochrome and color pixel information by paint-type tools.
.LP
See the documentation for each of the IBM PC tools for details on how
to use them.
.SH "FILE RECOGNITION"
ZSoft \fBpcx\fR files are recognized by these filename suffixes: .pcx
and .pcc. 
.SH NOTES
SDSC image library support of the ZSoft \fBpcx\fR format does not require
use of IBM PC graphics or compute hardware and contains no proprietary code.
ZSoft \fBpcx\fR format handling
is available on any machine for which the SDSC image library is available.
.SS "Reading ZSoft PCX files"
The SDSC image library can read ZSoft \fBpcx\fR files 
and map them to VFBs are as follows:
.ne 4
.LP
.if t .in +0.5i
.if n .in +5
.TS
l l.
\fBDepth/color	Mapped to VFB\fR		
1-bit monochrome	IMVFBMONO without CLT
2-bit color index	IMVFBINDEX8 with or without CLT
3-bit color index	IMVFBINDEX8 with or without CLT
4-bit color index	IMVFBINDEX8 with or without CLT
8-bit color index	IMVFBINDEX8 with or without CLT
.TE
.if t .in -0.5i
.if n .in -5
.LP
2-, 3-, 4- and 8-bit depths may or may not contain a pallete (color
lookup table).  
.SS "Writing ZSoft PCX files"
Images to be written out are mapped from image library VFBs are as
follows: 
.ne 4
.LP
.if t .in +0.5i
.if n .in +5
.TS
l l.
\fBMapped from VFB	Depth/color\fR
IMVFBMONO	1-bit monochrome
IMVFBINDEX8	8-bit color index
.TE
.if t .in -0.5i
.if n .in -5
.LP
If the incoming VFB has a CLT, the image written to the \fBpcx\fR file 
contains a pallete.
.LP
\fBpcx\fR files are always compressed with a variant of RLE encoding.
However, ZSoft's \fBpcx\fR RLE encoding scheme was poorly designed.
In the worst case, a compressed \fBpcx\fR file may require
\fIdouble\fP the disk space that an uncompressed image would occupy.
Unfortunately, ZSoft's \fBpcx\fR file format does not allow for
uncompressed images or compression schemes other than their faulty
RLE scheme. 
.LP 
Other image library VFB types are converted to one of the above
types prior to being written out.   See the \fBImFileWrite\fR(3IM)
\fBman\fP page for details.
.SH ERRORS
In addition to those listed for \fBImFileRead\fR(3IM),
ZSoft \fBpcx\fR file reading returns the following error codes: 
.ne 4
.LP
.if t .in +0.5i
.if n .in +5
.TS
l l.
IMEMALLOC	Cannot allocate enough memory
IMESYNTAX	Unknown parameter in file header
IMESYS	System call error in read operation
.TE
.if t .in -0.5i
.if n .in -5
.LP
In addition to those listed for \fBImFileWrite\fR(3IM),
ZSoft \fBpcx\fR file writing returns the following error codes: 
.ne 2
.LP
.if t .in +0.5i
.if n .in +5
.TS
l l.
IMEMALLOC	Cannot allocate enough memory
IMESYS	System call error in write operation
.TE
.if t .in -0.5i
.if n .in -5
.SH DOCUMENTATION
\fITechnical Reference Manual\fR, ZSoft Corporation, 1988.
.LP
\fIBit-Mapped Graphics\fR, Steve Rimmer, Windcrest/McGraw-Hill publishing, 1990.
.SH SEE ALSO
\fBImIntro\fR(3IM),
\fBImErrNo\fR(3IM),
\fBimconv\fR(1IM),
\fBimfile\fR(1IM),
\fBimformats\fR(1IM)
.SH AUTHOR
Dave Nadeau
.br
San Diego Supercomputer Center
.SH CONTACT
SDSC consultants, (619)534-5100, \fBconsult@y1.sdsc.edu\fR
.br
