'\"t
.if t .TH IMBMP 3IM "August 19, 1992" "San Diego Supercomputer Center" "SDSC IMAGE LIBRARY"
.if n .TH IMBMP 3IM "August 19, 1992" "SDSC" "SDSC IMAGE LIBRARY"
.SH NAME
imbmp \- Microsoft Windows BMP file translation
.SH SYNOPSIS
.nf
\fB
#include <stdio.h>
#include "sdsc.h"
#include "im.h"
.sp 1
int ImFileRead( fd, "bmp", flagsTable, dataTable )
	int         fd;
	TagTable   *flagsTable;
	TagTable   *dataTable;
.sp 1
int ImFileFRead( fp, "bmp", flagsTable, dataTable )
	FILE         *fp;
	TagTable   *flagsTable;
	TagTable   *dataTable;
.sp 1
int ImFileWrite( fd, "bmp", flagsTable, dataTable )
	int         fd;
	TagTable   *flagsTable;
	TagTable   *dataTable;
.sp 1
int ImFileFWrite( fp, "bmp", flagsTable, dataTable )
	FILE         *fp;
	TagTable   *flagsTable;
	TagTable   *dataTable;
\fR
.fi
.SH DESCRIPTION
.LP
\fBbmp\fR image files are generated by programs running in the
Microsoft Windows 3.0, and later, environments.  This environment
commonly runs on IBM PC's and compatibles.
.LP
\fBbmp\fR files
store color and B&W image bitmaps used in screen backgrounds
and in other image work.  See \fBimico\fR (3IM) and \fBimcur\fR (3IM)
for discussion of the Microsoft Windows icon and cursor storage
formats, respectively.
.SH "FILE RECOGNITION"
Microsoft Windows \fBbmp\fR files are recognized by the following
filename suffix:  .bmp.
.SH NOTES
SDSC image library support of the 
Microsoft Windows \fBbmp\fR format does not require
use of any Windows libraries and contains no proprietary code.  
Microsoft Windows \fBbmp\fR format handling
is available on any machine for which the SDSC image library is available.
.SS "Reading Microsoft Windows BMP files"
The SDSC image library reads non-compressed, pixel packed 1-, 4-, and
8-bit color indexed images; RLE compressed 4- and 8-bit color
indexed images; and non-compressed 24-bit RGB Microsoft Windows
\fBbmp\fR images and stores them as \fBIMVFBINDEX8\fR VFB with CLT's
or \fBIMVFBRGB\fR VFB's, as appropriate.
.SS "Writing Microsoft Windows BMP files"
Image library \fBIMVFBMONO\fR VFBs are written to non-compressed, pixel
packed 1-bit \fBbmp\fR files.
Image library \fBIMVFBINDEX8\fR VFBs are written to non-compressed, pixel
packed or RLE compressed 4- or 8-bit \fBbmp\fR files, with preference to
non-compressed, pixel packed files.
Image library \fBIMVFBRGB\fR VFBs are written 
to non-compressed 24-bit RGB \fBbmp\fR files.
.LP
Other image library VFB types are converted to \fBIMVFBMONO\fR,
\fBIMVFBINDEX8\fR, or \fBIMVFBRGB\fR VFB's
prior to being written out.  See the
\fBImFileWrite\fR(3IM) \fBman\fP page for details.
.SS "Special Note"
The utilities supplied with the current version of Windows, 3.1,
do not support RLE compressed 4- or 8-bit images.  For this reason,
the SDSC Image Tools default to writing non-compressed \fBbmp\fR files.
This default can be overriden by specifying the
\fI-outcompress rle\fR flag on \fBimconv (1IM)\fR or by setting the
the "image compress" tag in the \fIFlagsTable\fR when calling
\fBImFileWrite (3IM)\fR.
.SH ERRORS
In addition to those listed for \fBImFileRead\fR(3IM),
Microsoft Windows \fBbmp\fR file reading returns the following error codes:
.ne 4
.LP
.if t .in +0.5i
.if n .in +5
.TS
l l.
IMEDEPTH	Image depth not supported
IMEMAGIC	Bad magic number in header
.TE
.if t .in -0.5i
.if n .in -5
.SH DOCUMENTATION
\fIMicrosoft Windows Programmer's Reference Volumes 3 and 4\fR,
Microsoft, Inc.
.SH "SEE ALSO"
\fBImIntro\fR(3IM),
\fBImErrNo\fR(3IM),
\fBimconv\fR(1IM),
\fBimcur\fR(3IM),
\fBimfile\fR(1IM),
\fBimformats\fR(1IM),
\fBimico\fR(3IM) 
.SH AUTHOR
Toan-Vinh Le
.br
San Diego Supercomputer Center
.SH CONTACT
SDSC consultants, (619)534-5100, \fBconsult@y1.sdsc.edu\fR
.br
